/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.registry;

import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import studio.fantasyit.maid_storage_manager.items.ChangeFlag;
import studio.fantasyit.maid_storage_manager.items.CraftGuide;
import studio.fantasyit.maid_storage_manager.items.FilterListItem;
import studio.fantasyit.maid_storage_manager.items.HangUpItem;
import studio.fantasyit.maid_storage_manager.items.LogisticsGuide;
import studio.fantasyit.maid_storage_manager.items.MaidInteractItem;
import studio.fantasyit.maid_storage_manager.items.PortableCraftCalculatorBauble;
import studio.fantasyit.maid_storage_manager.items.ProgressPad;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.items.StorageDefineBauble;
import studio.fantasyit.maid_storage_manager.items.WorkCardItem;
import studio.fantasyit.maid_storage_manager.items.WrittenInvListItem;

public class ItemRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"maid_storage_manager");
    public static final RegistryObject<Item> REQUEST_LIST_ITEM = ItemRegistry.item("request_list", RequestListItem::new);
    public static final RegistryObject<Item> INVENTORY_LIST = ItemRegistry.item("inventory_list", MaidInteractItem::new);
    public static final RegistryObject<Item> WRITTEN_INVENTORY_LIST = ItemRegistry.item("written_inventory_list", WrittenInvListItem::new);
    public static final RegistryObject<Item> FILTER_LIST = ItemRegistry.item("filter_list", FilterListItem::new);
    public static final RegistryObject<Item> STORAGE_DEFINE_BAUBLE = ItemRegistry.item("storage_define_bauble", StorageDefineBauble::new);
    public static final RegistryObject<Item> NO_ACCESS = ItemRegistry.item("no_access", HangUpItem::new);
    public static final RegistryObject<Item> ALLOW_ACCESS = ItemRegistry.item("allow_access", HangUpItem::new);
    public static final RegistryObject<Item> CRAFT_GUIDE = ItemRegistry.item("craft_guide", CraftGuide::new);
    public static final RegistryObject<Item> PORTABLE_CRAFT_CALCULATOR_BAUBLE = ItemRegistry.item("portable_craft_calculator_bauble", PortableCraftCalculatorBauble::new);
    public static final RegistryObject<Item> WORK_CARD = ItemRegistry.item("work_card", WorkCardItem::new);
    public static final RegistryObject<Item> LOGISTICS_GUIDE = ItemRegistry.item("logistics_guide", LogisticsGuide::new);
    public static final RegistryObject<Item> CHANGE_FLAG = ItemRegistry.item("change_flag", ChangeFlag::new);
    public static final RegistryObject<Item> PROGRESS_PAD = ItemRegistry.item("progress_pad", ProgressPad::new);

    protected static RegistryObject<Item> item(String name, Supplier<Item> properties) {
        RegistryObject item = ITEMS.register(name, properties);
        return item;
    }

    protected static RegistryObject<Item> item(String name) {
        return ItemRegistry.item(name, () -> new Item(new Item.Properties()));
    }

    protected static RegistryObject<Item> item(RegistryObject<Block> block) {
        return ItemRegistry.item(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }
}

