/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.stone_cutter;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.container.CountSlot;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.stone_cutter.StoneCutterCraftScreen;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class StoneCutterCraftMenu
extends AbstractCraftMenu<StoneCutterCraftMenu> {
    SimpleContainer displayOnlySlots = new SimpleContainer(15);
    List<ItemStack> availableItems = new ArrayList<ItemStack>();
    public int page = 0;
    public int maxPage = 1;

    public StoneCutterCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_STONE_CUTTER.get(), p_38852_, player);
        this.recalculateRecipe();
    }

    @Override
    protected void addFilterSlots() {
        this.m_38897_(new FilterSlot(this.stepDataContainer, 0, 47, 39));
        this.m_38897_(new FilterSlot(this.stepDataContainer, 1, 109, 39, true));
    }

    @Override
    protected void addSpecialSlots() {
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(0), this.stepDataContainer));
        this.m_38895_(new CountSlot(this.stepDataContainer.getCountMutable(1), this.stepDataContainer));
    }

    @Override
    public void save() {
        if (this.player.m_9236_().f_46443_) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof StoneCutterCraftScreen) {
                StoneCutterCraftScreen screen2 = (StoneCutterCraftScreen)screen;
                screen2.handleGuiPacket(CraftGuideGuiPacket.Type.SET_ITEM, 0, 0, new CompoundTag());
            }
            this.recalculateRecipe();
        }
        super.save();
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.recalculateRecipe();
                this.save();
                break;
            }
            case SET_ALL_INPUT: {
                if (data == null) break;
                ListTag list = data.m_128437_("inputs", 10);
                for (int i = 0; i < 2; ++i) {
                    this.stepDataContainer.m_6836_(i, ItemStackUtil.parseStack(list.m_128728_(i)));
                }
                this.recalculateRecipe();
                this.save();
                break;
            }
            case PAGE_UP: 
            case PAGE_DOWN: {
                this.page = value;
                this.reArrangeSlotItem();
                break;
            }
            case COUNT: {
                this.stepDataContainer.setCount(key, value);
                this.stepDataContainer.m_6596_();
            }
        }
    }

    private void reArrangeSlotItem() {
        if (this.page >= this.maxPage) {
            this.page = this.maxPage - 1;
        }
        for (int i = 0; i < 15; ++i) {
            int index = this.page * 5 + i;
            if (index < this.availableItems.size()) {
                this.displayOnlySlots.m_6836_(i, this.availableItems.get(index));
                continue;
            }
            this.displayOnlySlots.m_6836_(i, ItemStack.f_41583_);
        }
    }

    @Override
    public void recalculateRecipe() {
        List<StonecutterRecipe> recipe;
        if (this.displayOnlySlots == null) {
            return;
        }
        if (!this.stepDataContainer.m_8020_(0).m_41619_() && !(recipe = RecipeUtil.getStonecuttingRecipe(this.player.m_9236_(), this.stepDataContainer.m_8020_(0))).isEmpty()) {
            this.availableItems = recipe.stream().map(re -> re.m_8043_(this.player.m_9236_().m_9598_())).toList();
            Optional<ItemStack> first = this.availableItems.stream().filter(itemStack -> ItemStackUtil.isSameInCrafting(this.stepDataContainer.m_8020_(1), itemStack)).findAny();
            if (first.isEmpty()) {
                this.stepDataContainer.setItemNoTrigger(1, ItemStack.f_41583_);
            } else {
                this.stepDataContainer.setCount(1, this.stepDataContainer.getCount(0) * first.get().m_41613_());
            }
            this.maxPage = (Math.max(this.availableItems.size() - 15, 0) + 4) / 5 + 1;
            this.reArrangeSlotItem();
            return;
        }
        this.stepDataContainer.setItemNoTrigger(1, ItemStack.f_41583_);
        this.availableItems = new ArrayList<ItemStack>();
        this.maxPage = 1;
        this.reArrangeSlotItem();
    }
}

