/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.config;

import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.task.MaidTaskConfigGui;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import org.apache.commons.lang3.mutable.MutableObject;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.menu.base.ImageAsset;
import studio.fantasyit.maid_storage_manager.network.MaidDataSyncPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;

public class StorageManagerMaidConfigGui
extends MaidTaskConfigGui<Container> {
    private StorageManagerConfigData.Data currentMAData;
    private OptionRow configButton;
    float scrollOffset = 0.0f;
    Float startDragScrollOffset = Float.valueOf(0.0f);
    Float startDragScreenOffset = Float.valueOf(0.0f);
    private final List<OptionRow> options = new ArrayList<OptionRow>();
    private static final int SCROLL_AREA_HEIGHT = 112;
    private static final ImageAsset ROW_BG_HOVER = new ImageAsset(new ResourceLocation("maid_storage_manager", "textures/gui/maid_work_setting.png"), 1, 136, 154, 13);
    private static final ImageAsset ROW_BG = new ImageAsset(new ResourceLocation("maid_storage_manager", "textures/gui/maid_work_setting.png"), 1, 123, 154, 13);
    private static final ImageAsset BAR = ImageAsset.from4Point(new ResourceLocation("maid_storage_manager", "textures/gui/maid_work_setting.png"), 0, 0, 8, 111);
    private static final ImageAsset BAR_BLOCK = ImageAsset.from4Point(new ResourceLocation("maid_storage_manager", "textures/gui/maid_work_setting.png"), 0, 112, 6, 120);
    private static final ImageAsset BAR_BLOCK_ACTIVE = ImageAsset.from4Point(new ResourceLocation("maid_storage_manager", "textures/gui/maid_work_setting.png"), 7, 112, 12, 120);
    int lastScrolling = -1;
    long startMills = -1L;

    public StorageManagerMaidConfigGui(Container screenContainer, Inventory inv, Component titleIn) {
        super((TaskConfigContainer)screenContainer, inv, titleIn);
    }

    protected void initAdditionData() {
        this.currentMAData = (StorageManagerConfigData.Data)this.maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault());
    }

    protected void initAdditionWidgets() {
        super.initAdditionWidgets();
        this.options.clear();
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.memory_assistant"), (Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.memoryAssistant())), button -> {
            int oNxt = Math.max(this.currentMAData.memoryAssistant().ordinal() - 1, 0);
            StorageManagerConfigData.MemoryAssistant v = StorageManagerConfigData.MemoryAssistant.values()[oNxt];
            this.currentMAData.memoryAssistant(v);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(v)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.MemoryAssistant, this.maid.m_19879_(), v.ordinal());
        }, button -> {
            int oNxt = Math.min(this.currentMAData.memoryAssistant().ordinal() + 1, StorageManagerConfigData.MemoryAssistant.values().length - 1);
            StorageManagerConfigData.MemoryAssistant v = StorageManagerConfigData.MemoryAssistant.values()[oNxt];
            this.currentMAData.memoryAssistant(v);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(v)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.MemoryAssistant, this.maid.m_19879_(), v.ordinal());
        }));
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.no_sort_placement"), (Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.noSortPlacement())), button -> {
            this.currentMAData.noSortPlacement(false);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(false)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.NoPlaceSort, this.maid.m_19879_(), 0);
            this.configButton.setValue((Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.suppressStrategy())));
        }, button -> {
            this.currentMAData.noSortPlacement(true);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(true)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.NoPlaceSort, this.maid.m_19879_(), 1);
            this.configButton.setValue((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.fast_sort.disable"));
        }));
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.co_work"), (Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.coWorkMode())), button -> {
            this.currentMAData.coWorkMode(false);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(false)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.CoWork, this.maid.m_19879_(), 0);
        }, button -> {
            this.currentMAData.coWorkMode(true);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(true)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.CoWork, this.maid.m_19879_(), 1);
        }));
        this.configButton = new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.fast_sort_mode"), (Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.suppressStrategy())), button -> {
            if (this.currentMAData.noSortPlacement()) {
                return;
            }
            int oNxt = Math.max(this.currentMAData.suppressStrategy().ordinal() - 1, 0);
            StorageManagerConfigData.SuppressStrategy v = StorageManagerConfigData.SuppressStrategy.values()[oNxt];
            this.currentMAData.suppressStrategy(v);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(v)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.FastSort, this.maid.m_19879_(), v.ordinal());
        }, button -> {
            if (this.currentMAData.noSortPlacement()) {
                return;
            }
            int oNxt = Math.min(this.currentMAData.suppressStrategy().ordinal() + 1, StorageManagerConfigData.SuppressStrategy.values().length - 1);
            StorageManagerConfigData.SuppressStrategy v = StorageManagerConfigData.SuppressStrategy.values()[oNxt];
            this.currentMAData.suppressStrategy(v);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(v)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.FastSort, this.maid.m_19879_(), v.ordinal());
        });
        this.options.add(this.configButton);
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.allow_seek_meal"), (Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.allowSeekWorkMeal())), button -> {
            this.currentMAData.allowSeekWorkMeal(false);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(false)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.AllowSeekWorkMeal, this.maid.m_19879_(), 0);
        }, button -> {
            this.currentMAData.allowSeekWorkMeal(true);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(true)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.AllowSeekWorkMeal, this.maid.m_19879_(), 1);
        }));
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.memorize_craft_guide"), (Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.useMemorizedCraftGuide())), button -> {
            this.currentMAData.useMemorizedCraftGuide(false);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(false)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.MemorizeCraftGuide, this.maid.m_19879_(), 0);
        }, button -> {
            this.currentMAData.useMemorizedCraftGuide(true);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(true)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.MemorizeCraftGuide, this.maid.m_19879_(), 1);
        }));
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.max_parallel"), (Component)Component.m_237113_((String)String.valueOf(this.currentMAData.maxParallel())), button -> {
            this.currentMAData.maxParallel(this.currentMAData.maxParallel() - 1);
            button.setValue((Object)Component.m_237113_((String)String.valueOf(this.currentMAData.maxParallel())));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.MaxParallel, this.maid.m_19879_(), this.currentMAData.maxParallel());
        }, button -> {
            this.currentMAData.maxParallel(this.currentMAData.maxParallel() + 1);
            button.setValue((Object)Component.m_237113_((String)String.valueOf(this.currentMAData.maxParallel())));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.MaxParallel, this.maid.m_19879_(), this.currentMAData.maxParallel());
        }));
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.crafting_repeat_count"), (Component)Component.m_237113_((String)String.valueOf(this.currentMAData.maxCraftingLayerRepeatCount())), button -> {
            this.currentMAData.maxCraftingLayerRepeatCount(this.currentMAData.maxCraftingLayerRepeatCount() / 2);
            button.setValue((Object)Component.m_237113_((String)String.valueOf(this.currentMAData.maxCraftingLayerRepeatCount())));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.CraftingRepeatCount, this.maid.m_19879_(), this.currentMAData.maxCraftingLayerRepeatCount());
        }, button -> {
            this.currentMAData.maxCraftingLayerRepeatCount(this.currentMAData.maxCraftingLayerRepeatCount() * 2);
            button.setValue((Object)Component.m_237113_((String)String.valueOf(this.currentMAData.maxCraftingLayerRepeatCount())));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.CraftingRepeatCount, this.maid.m_19879_(), this.currentMAData.maxCraftingLayerRepeatCount());
        }));
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.auto_sorting"), (Component)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(this.currentMAData.autoSorting())), button -> {
            this.currentMAData.autoSorting(false);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(false)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.AutoSorting, this.maid.m_19879_(), 0);
        }, button -> {
            this.currentMAData.autoSorting(true);
            button.setValue((Object)Component.m_237115_((String)StorageManagerConfigData.getTranslationKey(true)));
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.AutoSorting, this.maid.m_19879_(), 1);
        }));
        this.options.add(new OptionRow((Component)Component.m_237115_((String)"gui.maid_storage_manager.config.item_type_limit"), this.getItemTypeLimitButtonText(), button -> {
            this.currentMAData.itemTypeLimit(switch (this.currentMAData.itemTypeLimit()) {
                case -1, 0 -> -1;
                default -> this.currentMAData.itemTypeLimit() / 2;
            });
            button.setValue((Object)this.getItemTypeLimitButtonText());
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.ItemTypeLimit, this.maid.m_19879_(), this.currentMAData.itemTypeLimit());
        }, button -> {
            this.currentMAData.itemTypeLimit(switch (this.currentMAData.itemTypeLimit()) {
                case 0 -> 1;
                case -1 -> 0;
                default -> this.currentMAData.itemTypeLimit() * 2;
            });
            button.setValue((Object)this.getItemTypeLimitButtonText());
            Network.sendMaidDataSync(MaidDataSyncPacket.Type.ItemTypeLimit, this.maid.m_19879_(), this.currentMAData.itemTypeLimit());
        }));
    }

    private Component getItemTypeLimitButtonText() {
        if (this.currentMAData.itemTypeLimit() == -1) {
            return Component.m_237115_((String)"gui.maid_storage_manager.config.item_type_limit_unlimited");
        }
        if (this.currentMAData.itemTypeLimit() == 0) {
            return Component.m_237115_((String)"gui.maid_storage_manager.config.item_type_limit_keep");
        }
        return Component.m_237113_((String)String.valueOf(this.currentMAData.itemTypeLimit()));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        super.m_7286_(graphics, partialTicks, x, y);
        int startLeft = this.f_97735_ + 87;
        int startTop = this.f_97736_ + 36;
        graphics.m_280588_(startLeft, startTop, startLeft + StorageManagerMaidConfigGui.ROW_BG.w + 11, startTop + 112);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)startLeft, (float)startTop - this.scrollOffset, 0.0f);
        this.renderScrollList(graphics, x, y, startLeft, (int)((float)startTop - this.scrollOffset));
        graphics.m_280168_().m_85849_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_((float)startLeft, (float)startTop, 0.0f);
        BAR.blit(graphics, StorageManagerMaidConfigGui.ROW_BG.w + 1, 1);
        BAR_BLOCK.blit(graphics, StorageManagerMaidConfigGui.ROW_BG.w + 2, (int)this.getScrollBlockTop() + 1);
        graphics.m_280168_().m_85849_();
        graphics.m_280618_();
    }

    private void renderScrollList(GuiGraphics graphics, int x, int y, int baseX, int baseY) {
        int hoverId = this.getMouseOverRowId(x, y);
        for (int i = 0; i < this.options.size(); ++i) {
            (hoverId == i ? ROW_BG_HOVER : ROW_BG).blit(graphics, 0, i * 13);
            if (hoverId == i && this.lastScrolling != i) {
                this.lastScrolling = i;
                this.startMills = Util.m_137550_();
            }
            this.drawScrollingStringWithoutShadow(graphics, this.f_96547_, this.options.get(i).label(), 5, i * 13 + 3, 0x444444, 103, baseX, baseY, hoverId == i);
            this.drawCenteredStringWithoutShadow(graphics, this.f_96547_, (Component)this.options.get(i).value().getValue(), 134, i * 13 + 3, ChatFormatting.GREEN.m_126665_(), 40);
        }
    }

    private boolean isInScrollArea(double mouseX, double mouseY) {
        return mouseX >= (double)(this.f_97735_ + 87) && mouseX <= (double)(this.f_97735_ + 87 + StorageManagerMaidConfigGui.ROW_BG.w + 10) && mouseY >= (double)(this.f_97736_ + 36) && mouseY <= (double)(this.f_97736_ + 36 + 112);
    }

    private int getMouseOverRowId(double mouseX, double mouseY) {
        if (this.isInScrollArea(mouseX, mouseY)) {
            return (int)(mouseY - (double)this.f_97736_ - 36.0 + (double)this.scrollOffset) / StorageManagerMaidConfigGui.ROW_BG.h;
        }
        return -1;
    }

    public void drawCenteredStringWithoutShadow(GuiGraphics graphics, Font pFont, Component pText, int pX, int pY, int pColor, int maxWidth) {
        FormattedCharSequence formattedcharsequence = pText.m_7532_();
        int textWidth = pFont.m_92724_(formattedcharsequence);
        int drawWidth = Math.max(textWidth, maxWidth);
        int alignWidth = Math.min(maxWidth, textWidth);
        float scale = (float)maxWidth / (float)drawWidth;
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, scale);
        graphics.drawString(pFont, formattedcharsequence, ((float)pX - (float)alignWidth / 2.0f) / scale, ((float)(pY - 3) + (14.0f - 8.0f * scale) / 2.0f) / scale, pColor, false);
        graphics.m_280168_().m_85849_();
    }

    public void drawScrollingStringWithoutShadow(GuiGraphics graphics, Font pFont, Component pText, int pX, int pY, int pColor, int maxWidth, int baseX, int baseY, boolean enableScroll) {
        int i = pFont.m_92852_((FormattedText)pText);
        Objects.requireNonNull(this.f_96547_);
        int maxY = pY + 9;
        int maxX = pX + maxWidth;
        int j = (pY + maxY - 9) / 2 + 1;
        int k = maxX - pX;
        graphics.m_280588_(pX + baseX, pY + baseY, maxX + baseX, maxY + baseY);
        if (i > k && enableScroll) {
            int l = i - k;
            double d0 = (double)(Util.m_137550_() - this.startMills) / 600.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1) - Math.PI) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            graphics.m_280614_(pFont, pText, pX - (int)d3, pY, pColor, false);
        } else {
            graphics.m_280614_(pFont, pText, pX, pY, pColor, false);
        }
        graphics.m_280618_();
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        if (this.isInScrollArea(p_94686_, p_94687_)) {
            this.scroll(-3.0 * p_94688_);
            return true;
        }
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    private double getS2SFactor() {
        return (double)(this.options.size() * StorageManagerMaidConfigGui.ROW_BG.h - 112) / (double)(StorageManagerMaidConfigGui.BAR.h - StorageManagerMaidConfigGui.BAR_BLOCK.h - 4);
    }

    public double getScrollBlockTop() {
        return (double)this.scrollOffset / this.getS2SFactor() + 1.0;
    }

    public boolean isOnScrollBlock(double mouseX, double mouseY) {
        if (!this.isInScrollArea(mouseX, mouseY)) {
            return false;
        }
        return mouseX - (double)this.f_97735_ - 87.0 > (double)StorageManagerMaidConfigGui.ROW_BG.w && mouseY - (double)this.f_97736_ - 36.0 > this.getScrollBlockTop() && mouseY - (double)this.f_97736_ - 36.0 < this.getScrollBlockTop() + (double)StorageManagerMaidConfigGui.BAR_BLOCK.h;
    }

    public void scroll(double delta) {
        this.scrollOffset += (float)delta;
        if (this.scrollOffset > (float)(this.options.size() * StorageManagerMaidConfigGui.ROW_BG.h - 112)) {
            this.scrollOffset = this.options.size() * StorageManagerMaidConfigGui.ROW_BG.h - 112;
        }
        if (this.scrollOffset < 0.0f) {
            this.scrollOffset = 0.0f;
        }
    }

    public boolean m_6375_(double p_97748_, double p_97749_, int p_97750_) {
        if (this.isInScrollArea(p_97748_, p_97749_)) {
            if (this.isOnScrollBlock(p_97748_, p_97749_)) {
                this.startDragScrollOffset = Float.valueOf(this.scrollOffset);
                this.startDragScreenOffset = Float.valueOf((float)p_97749_);
                return true;
            }
            int rowId = this.getMouseOverRowId(p_97748_, p_97749_);
            int dx = (int)(p_97748_ - (double)this.f_97735_ - 87.0);
            if (rowId >= 0 && rowId < this.options.size()) {
                OptionRow option = this.options.get(rowId);
                if (dx > 109 && dx < 122) {
                    option.left.accept(option.value);
                } else if (dx > 144 && dx < 155) {
                    option.right.accept(option.value);
                }
            }
            return true;
        }
        return super.m_6375_(p_97748_, p_97749_, p_97750_);
    }

    public boolean m_7979_(double p_97752_, double p_97753_, int p_97754_, double p_97755_, double p_97756_) {
        if (this.startDragScreenOffset != null && this.startDragScrollOffset != null) {
            this.scrollOffset = (float)((double)this.startDragScrollOffset.floatValue() + (double)((float)(p_97753_ - (double)this.startDragScreenOffset.floatValue())) * this.getS2SFactor());
            this.scroll(0.0);
        }
        return super.m_7979_(p_97752_, p_97753_, p_97754_, p_97755_, p_97756_);
    }

    public boolean m_6348_(double p_97812_, double p_97813_, int p_97814_) {
        this.startDragScreenOffset = null;
        this.startDragScrollOffset = null;
        return super.m_6348_(p_97812_, p_97813_, p_97814_);
    }

    record OptionRow(Component label, MutableObject<Component> value, Consumer<MutableObject<Component>> left, Consumer<MutableObject<Component>> right) {
        public OptionRow(Component label, Component value, Consumer<MutableObject<Component>> left, Consumer<MutableObject<Component>> right) {
            this(label, (MutableObject<Component>)new MutableObject((Object)value), left, right);
        }

        public void setValue(Component value) {
            this.value.setValue((Object)value);
        }
    }

    public static class Container
    extends TaskConfigContainer {
        public Container(int id, Inventory inventory, int entityId) {
            super((MenuType)GuiRegistry.STORAGE_MANAGER_MAID_CONFIG_GUI.get(), id, inventory, entityId);
        }
    }
}

