/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.place;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.behavior.base.MaidMoveToBlockTaskWithArrivalMap;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.maid.memory.PlacingInventoryMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StoragePredictor;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IFilterable;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;
import studio.fantasyit.maid_storage_manager.util.PosUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class PlaceMoveBehavior
extends MaidMoveToBlockTaskWithArrivalMap {
    private Target chestPos;
    private ArrayList<ItemStack> maidAvailableItems;

    public PlaceMoveBehavior() {
        super((float)Config.placeSpeed, 3);
        this.verticalSearchStart = 1;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.PLACE) {
            return false;
        }
        if (MemoryUtil.isWorking(owner)) {
            return false;
        }
        if (Conditions.isWaitingForReturn(owner)) {
            return false;
        }
        return !Conditions.isNothingToPlace(owner);
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        super.m_6735_(level, (LivingEntity)maid, p_22542_);
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        this.maidAvailableItems = new ArrayList();
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (inv.getStackInSlot(i).m_41619_() || inv.getStackInSlot(i).m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) && !RequestListItem.isIgnored(inv.getStackInSlot(i))) continue;
            this.maidAvailableItems.add(inv.getStackInSlot(i).m_41777_());
        }
        if (!this.priorityTarget(level, maid)) {
            this.searchForDestination(level, maid);
        }
        if (!maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.TARGET_POS.get())) {
            if (!MemoryUtil.getPlacingInv(maid).isAnySuccess()) {
                MemoryUtil.getPlacingInv(maid).addFailCount();
                if (MemoryUtil.getPlacingInv(maid).getFailCount() >= 2 && MemoryUtil.getPlacingInv(maid).anySuppressed()) {
                    DebugData.sendDebug("[PLACE]Suppress clear L ALL", new Object[0]);
                    MemoryUtil.getPlacingInv(maid).removeSuppressed();
                    MemoryUtil.getPlacingInv(maid).resetFailCount();
                }
                if (MemoryUtil.getPlacingInv(maid).getFailCount() >= 5) {
                    ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.chest_full");
                }
            } else {
                MemoryUtil.getPlacingInv(maid).resetFailCount();
            }
            MemoryUtil.getPlacingInv(maid).resetVisitedPos();
            MemoryUtil.getPlacingInv(maid).clearTarget();
            MemoryUtil.getPlacingInv(maid).resetAnySuccess();
            MemoryUtil.clearTarget(maid);
            DebugData.sendDebug("[PLACE]Reset (Iter all)", new Object[0]);
        } else if (this.chestPos != null) {
            MemoryUtil.getPlacingInv(maid).setTarget(this.chestPos);
            maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(this.chestPos.pos));
        }
    }

    private boolean priorityTarget(ServerLevel level, EntityMaid maid) {
        BlockPos nearestFromTargetList;
        if (Conditions.noSortPlacement(maid)) {
            return false;
        }
        ArrayList<Target> suppressedFilterTarget = new ArrayList<Target>();
        ArrayList<Target> suppressedContentTarget = new ArrayList<Target>();
        Target targetContent = null;
        ArrayList<ItemStack> targetContentList = new ArrayList<ItemStack>();
        List<BlockPos> targetContentPos = null;
        Target targetFilter = null;
        ArrayList<ItemStack> targetFilterList = new ArrayList<ItemStack>();
        List<BlockPos> targetFilterPos = null;
        MaidPathFindingBFS pathFinding = new MaidPathFindingBFS(maid.m_21573_().m_26575_(), level, maid);
        Map<Target, List<ViewedInventoryMemory.ItemCount>> blockPosListMap = MemoryUtil.getViewedInventory(maid).positionFlatten();
        for (Map.Entry<Target, List<ViewedInventoryMemory.ItemCount>> blockPos : blockPosListMap.entrySet()) {
            boolean found;
            List<BlockPos> possibleMove;
            if (targetFilter != null) break;
            Target validTarget = MaidStorage.getInstance().isValidTarget(level, (LivingEntity)maid, blockPos.getKey().getPos(), blockPos.getKey().side);
            if (validTarget != null && !MoveUtil.isValidTarget(level, maid, validTarget, false) || StorageAccessUtil.findTargetRewrite(level, maid, blockPos.getKey(), false).isEmpty() || MemoryUtil.getPlacingInv(maid).isVisitedPos(validTarget) || (possibleMove = MoveUtil.getAllAvailablePosForTarget(level, maid, blockPos.getKey().getPos(), pathFinding)).isEmpty()) continue;
            if (validTarget != null) {
                IFilterable ift;
                @Nullable IMaidStorage type = MaidStorage.getInstance().getStorage(validTarget.getType());
                if (type == null || !type.supportPlace()) continue;
                @Nullable IStorageContext context = type.onPreviewFilter(level, maid, validTarget);
                if (context != null) {
                    context.start(maid, level, validTarget);
                }
                if (context instanceof IFilterable && (ift = (IFilterable)((Object)context)).isWhitelist()) {
                    found = false;
                    for (ItemStack itemStack : this.maidAvailableItems) {
                        if (!ift.isAvailable(itemStack)) continue;
                        found = true;
                        targetFilterList.add(itemStack);
                    }
                    if (found) {
                        if (MemoryUtil.getPlacingInv(maid).isSuppressed(validTarget)) {
                            targetFilterList.clear();
                            suppressedFilterTarget.add(validTarget);
                            continue;
                        }
                        targetFilter = validTarget;
                        targetFilterPos = possibleMove;
                    }
                }
            }
            if (targetContent != null) continue;
            boolean foundTarget = false;
            for (ViewedInventoryMemory.ItemCount itemCount : blockPos.getValue()) {
                found = false;
                for (ItemStack itemStack : this.maidAvailableItems) {
                    if (itemCount.getFirst().m_41619_() || !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)itemCount.getFirst())) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                foundTarget = true;
                targetContentList.add(itemCount.getFirst());
            }
            if (!foundTarget) continue;
            if (MemoryUtil.getPlacingInv(maid).isSuppressed(validTarget)) {
                suppressedContentTarget.add(validTarget);
                targetContentList.clear();
                continue;
            }
            targetContentPos = possibleMove;
            targetContent = validTarget;
        }
        PlacingInventoryMemory placingInv = MemoryUtil.getPlacingInv(maid);
        if (targetFilter != null) {
            placingInv.setArrangeItems(targetFilterList);
            this.chestPos = targetFilter;
            nearestFromTargetList = MoveUtil.getNearestFromTargetList(level, maid, targetFilterPos);
            if (nearestFromTargetList == null) {
                MemoryUtil.getPlacingInv(maid).addVisitedPos(targetFilter);
                return this.priorityTarget(level, maid);
            }
            MemoryUtil.setTarget(maid, nearestFromTargetList, (float)Config.placeSpeed);
            DebugData.sendDebug("[PLACE]Priority By Filter %s", targetFilter.toString());
            targetFilterList.forEach(i -> DebugData.sendDebug("+ Arranged:%s", i.m_41720_().toString()));
            return true;
        }
        if (StorageManagerConfigData.get(maid).suppressStrategy() == StorageManagerConfigData.SuppressStrategy.AFTER_EACH && !suppressedFilterTarget.isEmpty()) {
            placingInv.removeSuppressed(suppressedFilterTarget);
            DebugData.sendDebug("[PLACE]Suppress clear L Filter", new Object[0]);
            return this.priorityTarget(level, maid);
        }
        if (targetContent != null) {
            placingInv.setArrangeItems(targetContentList);
            this.chestPos = targetContent;
            nearestFromTargetList = MoveUtil.getNearestFromTargetList(level, maid, targetContentPos);
            if (nearestFromTargetList == null) {
                MemoryUtil.getPlacingInv(maid).addVisitedPos(targetContent);
                return this.priorityTarget(level, maid);
            }
            MemoryUtil.setTarget(maid, nearestFromTargetList, (float)Config.placeSpeed);
            DebugData.sendDebug("[PLACE]Priority By Content %s", targetContent);
            targetContentList.forEach(i -> DebugData.sendDebug("+ Arranged:%s", i.m_41720_().toString()));
            return true;
        }
        if (!(StorageManagerConfigData.get(maid).suppressStrategy() != StorageManagerConfigData.SuppressStrategy.AFTER_EACH && StorageManagerConfigData.get(maid).suppressStrategy() != StorageManagerConfigData.SuppressStrategy.AFTER_PRIORITY || suppressedFilterTarget.isEmpty() && suppressedContentTarget.isEmpty())) {
            DebugData.sendDebug("[PLACE]Suppress clear L Match", new Object[0]);
            MemoryUtil.getPlacingInv(maid).removeSuppressed(suppressedContentTarget);
            MemoryUtil.getPlacingInv(maid).removeSuppressed(suppressedFilterTarget);
            return this.priorityTarget(level, maid);
        }
        return false;
    }

    protected boolean shouldMoveTo(ServerLevel serverLevel, EntityMaid entityMaid, BlockPos blockPos) {
        if (!PosUtil.isSafePos((Level)serverLevel, blockPos)) {
            return false;
        }
        Target canTouchChest = MoveUtil.findTargetForPos(serverLevel, entityMaid, blockPos, MemoryUtil.getPlacingInv(entityMaid), false, StoragePredictor::isPlaceable);
        if (canTouchChest != null) {
            this.chestPos = canTouchChest;
            MemoryUtil.getPlacingInv(entityMaid).setArrangeItems(this.maidAvailableItems);
            DebugData.sendDebug("[PLACE]Normal %s", canTouchChest);
            return true;
        }
        return false;
    }
}

