/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.logistics.recycle;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import java.util.Objects;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.LogisticsMemory;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.StorageVisitLock;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInsertableContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class LogisticsRecycleBehavior
extends Behavior<EntityMaid> {
    private final BehaviorBreath breath = new BehaviorBreath();
    @Nullable
    IStorageContext context;
    int currentSlot = 0;
    private Target target;
    CraftLayer layer = null;
    private StorageVisitLock.LockContext lock;

    public LogisticsRecycleBehavior() {
        super(Map.of());
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (!MemoryUtil.getLogistics(maid).shouldWork()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.RECYCLE) {
            return false;
        }
        if (this.layer == null) {
            return false;
        }
        if (this.currentSlot >= maid.getAvailableInv(false).getSlots()) {
            return false;
        }
        return this.context != null && !this.context.isDone();
    }

    protected boolean checkExtraStartConditions(ServerLevel p_22538_, EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getCurrentLogisticsGuideItem().m_41619_()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.RECYCLE) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        this.lock = StorageVisitLock.DUMMY;
        if (MemoryUtil.getLogistics(maid).hasTarget()) {
            this.target = MemoryUtil.getLogistics(maid).getTarget();
            this.context = Objects.requireNonNull(MaidStorage.getInstance().getStorage(this.target.getType())).onStartPlace(level, maid, this.target);
            if (this.context != null) {
                this.context.start(maid, level, this.target);
            }
            this.layer = MemoryUtil.getLogistics(maid).getCraftLayer();
            this.lock = StorageVisitLock.getWriteLock(this.target, maid);
        }
        this.currentSlot = 0;
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        if (!this.lock.checkAndTryGrantLock()) {
            return;
        }
        if (!this.breath.breathTick(maid)) {
            return;
        }
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < 5 && this.currentSlot < availableInv.getSlots(); ++i) {
            if (!availableInv.getStackInSlot(this.currentSlot).m_41619_()) continue;
            ++this.currentSlot;
        }
        if (this.currentSlot < availableInv.getSlots()) {
            IStorageContext iStorageContext;
            ItemStack stack = availableInv.getStackInSlot(this.currentSlot);
            if (!stack.m_41619_() && this.inInput(stack) && (iStorageContext = this.context) instanceof IStorageInsertableContext) {
                IStorageInsertableContext isic = (IStorageInsertableContext)iStorageContext;
                ItemStack notInserted = isic.insert(stack);
                availableInv.setStackInSlot(this.currentSlot, notInserted);
            }
            ++this.currentSlot;
        }
    }

    protected boolean inInput(ItemStack stack) {
        if (this.layer != null) {
            return this.layer.getItems().stream().anyMatch(itemStack -> ItemStackUtil.isSame(itemStack, stack, false));
        }
        return false;
    }

    protected void stop(@NotNull ServerLevel level, @NotNull EntityMaid maid, long p_22550_) {
        this.lock.release();
        if (this.context != null) {
            this.context.finish();
        }
        MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.FINISH);
        MemoryUtil.getLogistics(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

