/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.logistics.craft;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.LogisticsMemory;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class LogisticCraftWorkBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    AbstractCraftActionContext context;
    CraftGuideStepData craftGuideStepData;
    private CraftLayer layer;
    private boolean done;
    private boolean fail;
    private int tryTick;

    public LogisticCraftWorkBehavior() {
        super(Map.of());
    }

    protected boolean canStillUse(ServerLevel level, EntityMaid maid, long p_22547_) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (!MemoryUtil.getLogistics(maid).shouldWork()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.CRAFT) {
            return false;
        }
        return !this.done;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.LOGISTICS) {
            return false;
        }
        if (!MemoryUtil.getLogistics(maid).shouldWork()) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getStage() != LogisticsMemory.Stage.CRAFT) {
            return false;
        }
        if (MemoryUtil.getLogistics(maid).getCraftLayer() == null) {
            return false;
        }
        CraftGuideStepData stepData = MemoryUtil.getLogistics(maid).getCraftLayer().getStepData();
        if (stepData == null) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid, stepData.actionType.pathCloseEnoughThreshold());
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTimeIn) {
        this.fail = false;
        this.tryTick = 0;
        if (!MemoryUtil.getLogistics(maid).hasTarget()) {
            this.done = true;
            this.fail = true;
            return;
        }
        this.layer = MemoryUtil.getLogistics(maid).getCraftLayer();
        this.craftGuideStepData = this.layer.getStepData();
        if (this.craftGuideStepData == null) {
            MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.OUTPUT);
            this.done = true;
            return;
        }
        this.done = false;
        this.breath.reset();
        this.context = this.layer.startStep(maid);
        if (this.context == null) {
            this.fail = true;
            this.done = true;
            return;
        }
        AbstractCraftActionContext.Result start = this.context.start();
        if (start == AbstractCraftActionContext.Result.SUCCESS) {
            this.fail = false;
            this.done = true;
        } else if (start == AbstractCraftActionContext.Result.FAIL) {
            this.fail = true;
            this.done = true;
        }
        if (this.layer.getCraftData().map(CraftGuideData::getAllOutputItems).map(l -> l.size() > 0).orElse(false).booleanValue()) {
            ChatTexts.progress(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting_progress", (Object[])new Object[]{this.layer.getCraftData().map(CraftGuideData::getAllOutputItems).map(l -> ((ItemStack)l.get(0)).m_41786_()).orElse((Component)Component.m_237119_()), String.valueOf(this.layer.getDoneCount() + 1), this.layer.getCount().toString()}), (double)this.layer.getDoneCount().intValue() / (double)this.layer.getCount().intValue());
        }
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        ++this.tryTick;
        if (this.tryTick > Config.maxCraftTries) {
            this.fail = true;
            this.done = true;
            return;
        }
        if (!this.breath.breathTick(maid)) {
            return;
        }
        AbstractCraftActionContext.Result tick = this.context.tick();
        if (this.context.skipNextBreath()) {
            this.breath.reset();
        }
        switch (tick) {
            case SUCCESS: {
                this.fail = false;
                this.done = true;
                break;
            }
            case FAIL: {
                this.fail = true;
                this.done = true;
                break;
            }
            case CONTINUE: {
                this.tryTick = 0;
                break;
            }
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        super.m_6732_(level, (LivingEntity)maid, p_22550_);
        if (this.context != null) {
            this.context.stop();
        }
        MemoryUtil.getLogistics(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
        if (this.fail) {
            MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.OUTPUT);
            ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.crafting_fail");
        } else {
            ChatTexts.progress(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting_progress", (Object[])new Object[]{this.layer.getCraftData().map(CraftGuideData::getAllOutputItems).map(l -> l.isEmpty() ? Component.m_237119_() : ((ItemStack)l.get(0)).m_41786_()).orElse((Component)Component.m_237119_()), String.valueOf(this.layer.getDoneCount() + 1), this.layer.getCount().toString()}), (double)this.layer.getDoneCount().intValue() / (double)this.layer.getCount().intValue());
            DebugData.sendDebug("[REQUEST_CRAFT_WORK]crafting done %s", this.layer.getStep());
            this.layer.nextStep();
            if (this.layer.isDone()) {
                DebugData.sendDebug("[REQUEST_CRAFT_WORK]layer done", new Object[0]);
                MemoryUtil.getLogistics(maid).setStage(LogisticsMemory.Stage.OUTPUT);
            }
        }
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

