/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.cowork;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.MoveUtil;

public class FollowActionBehavior
extends MaidCheckRateTask {
    public FollowActionBehavior() {
        super(Map.of((MemoryModuleType)MemoryModuleRegistry.CO_WORK_MODE.get(), MemoryStatus.VALUE_PRESENT));
        this.setMaxCheckRate(10);
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid owner) {
        return MemoryUtil.getCurrentlyWorking(owner) == ScheduleBehavior.Schedule.CO_WORK;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        LivingEntity owner = maid.m_269323_();
        if (owner == null) {
            return;
        }
        if (maid.m_20270_((Entity)owner) < 2.0f) {
            this.standBack(level, maid, owner);
        } else {
            this.traceOwner(maid, owner);
        }
    }

    private void standBack(ServerLevel level, EntityMaid maid, LivingEntity owner) {
        Vec3 standBackDirection = maid.m_20182_().m_82546_(owner.m_20182_()).m_82541_().m_82490_(2.0);
        BlockPos standBackSearchCenter = BlockPos.m_274446_((Position)maid.m_20182_().m_82549_(standBackDirection));
        BlockPos targetPos = MoveUtil.selectPosForTarget(level, maid, standBackSearchCenter);
        if (targetPos != null) {
            MemoryUtil.setTarget(maid, targetPos, (float)Config.followSpeed);
            if (MemoryUtil.getCoWorkTargetStorage(maid) == null) {
                EntityTracker tracker = new EntityTracker((Entity)owner, true);
                maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)tracker);
            }
        }
    }

    private void traceOwner(EntityMaid maid, LivingEntity owner) {
        EntityTracker tracker = new EntityTracker((Entity)owner, true);
        WalkTarget walktarget = new WalkTarget((PositionTracker)tracker, (float)Config.followSpeed, 4);
        maid.m_6274_().m_21879_(MemoryModuleType.f_26370_, (Object)walktarget);
        if (MemoryUtil.getCoWorkTargetStorage(maid) == null) {
            maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)tracker);
        }
    }
}

