/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideRenderData;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.render.ItemStackLighting;

public class CustomItemRenderer
extends BlockEntityWithoutLevelRenderer {
    static CustomItemRenderer instance;
    private final BlockEntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_167982_();

    public static CustomItemRenderer getInstance() {
        if (instance == null) {
            instance = new CustomItemRenderer();
        }
        return instance;
    }

    public CustomItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public void m_108829_(@NotNull ItemStack itemStack, @NotNull ItemDisplayContext context, @NotNull PoseStack pose, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        pose.m_85836_();
        if (context != ItemDisplayContext.FIXED && context != ItemDisplayContext.GUI) {
            pose.m_85841_(0.5f, 0.5f, 1.0f);
            pose.m_85837_(0.5, 0.8, 0.0);
        }
        if (itemStack.m_150930_((Item)ItemRegistry.FILTER_LIST.get())) {
            this.renderFilter(itemStack, context, pose, multiBufferSource, light, overlay);
        }
        if (itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get())) {
            this.renderCraft(itemStack, context, pose, multiBufferSource, light, overlay);
        }
        if (itemStack.m_150930_((Item)ItemRegistry.LOGISTICS_GUIDE.get())) {
            this.renderLogistics(itemStack, context, pose, multiBufferSource, light, overlay);
        }
        pose.m_85849_();
    }

    private void renderLogistics(@NotNull ItemStack itemStack, @NotNull ItemDisplayContext context, @NotNull PoseStack pose, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation("maid_storage_manager", "logistics_guide", "inventory"));
        for (RenderType rendertype : model.getRenderTypes(itemStack, false)) {
            VertexConsumer vertexconsumer = ItemRenderer.m_115211_((MultiBufferSource)multiBufferSource, (RenderType)rendertype, (boolean)true, (boolean)itemStack.m_41790_());
            Minecraft.m_91087_().m_91291_().m_115189_(model, itemStack, light, overlay, pose, vertexconsumer);
        }
    }

    private void renderFilter(@NotNull ItemStack itemStack, @NotNull ItemDisplayContext context, @NotNull PoseStack pose, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        int i;
        ItemStack item;
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation("maid_storage_manager", "filter_list_base", "inventory"));
        for (RenderType rendertype : model.getRenderTypes(itemStack, false)) {
            VertexConsumer vertexconsumer = ItemRenderer.m_115211_((MultiBufferSource)multiBufferSource, (RenderType)rendertype, (boolean)true, (boolean)itemStack.m_41790_());
            Minecraft.m_91087_().m_91291_().m_115189_(model, itemStack, light, overlay, pose, vertexconsumer);
        }
        ListTag list = itemStack.m_41784_().m_128437_("items", 10);
        List<ItemStack> items = list.stream().map(e -> ((CompoundTag)e).m_128469_("item")).map(ItemStack::m_41712_).filter(e -> !e.m_41619_()).toList();
        if (!items.isEmpty() && !(item = items.get(i = Minecraft.m_91087_().f_91074_.f_19797_ / 20 % items.size())).m_41619_()) {
            pose.m_85836_();
            if (context != ItemDisplayContext.FIXED) {
                pose.m_85837_(0.22, 0.22, 0.54);
            } else {
                Quaternionf rotation = new Quaternionf();
                rotation.rotateAxis((float)Math.PI, 0.0f, 1.0f, 0.0f);
                pose.m_252781_(rotation);
                pose.m_85837_(-0.78, 0.23, -0.46);
            }
            pose.m_85841_(0.55f, 0.55f, 1.0f);
            pose.m_252931_(new Matrix4f().scale(1.0f, 1.0f, 0.01f));
            pose.m_252880_(0.5f, 0.5f, 0.5f);
            ItemStackLighting.flushAndSetup(multiBufferSource, pose);
            Minecraft.m_91087_().m_91291_().m_115143_(item, ItemDisplayContext.GUI, true, pose, multiBufferSource, light, overlay, Minecraft.m_91087_().m_91291_().m_174264_(item, null, null, 0));
            ItemStackLighting.flushAndRestore(multiBufferSource);
            pose.m_85849_();
        }
    }

    private void renderCraft(@NotNull ItemStack itemStack, @NotNull ItemDisplayContext context, @NotNull PoseStack pose, @NotNull MultiBufferSource multiBufferSource, int light, int overlay) {
        ItemStack icon;
        int i;
        ItemStack item;
        CraftGuideRenderData data = CraftGuideRenderData.fromItemStack(itemStack);
        List<ItemStack> items = data.outputs;
        BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation("maid_storage_manager", items.isEmpty() ? "craft_guide_base" : "craft_guide_base_blank", "inventory"));
        for (RenderType rendertype : model.getRenderTypes(itemStack, false)) {
            VertexConsumer vertexconsumer = ItemRenderer.m_115211_((MultiBufferSource)multiBufferSource, (RenderType)rendertype, (boolean)true, (boolean)itemStack.m_41790_());
            Minecraft.m_91087_().m_91291_().m_115189_(model, itemStack, light, overlay, pose, vertexconsumer);
        }
        if (!items.isEmpty() && !(item = items.get(i = Minecraft.m_91087_().f_91074_.f_19797_ / 20 % items.size())).m_41619_()) {
            pose.m_85836_();
            if (context != ItemDisplayContext.FIXED) {
                pose.m_85837_(0.22, 0.22, 0.54);
            } else {
                Quaternionf rotation = new Quaternionf();
                rotation.rotateAxis((float)Math.PI, 0.0f, 1.0f, 0.0f);
                pose.m_252781_(rotation);
                pose.m_85837_(-0.78, 0.23, -0.46);
            }
            pose.m_85837_(0.0, -0.05, 0.0);
            pose.m_85841_(0.55f, 0.55f, 1.0f);
            pose.m_252931_(new Matrix4f().scale(1.0f, 1.0f, 0.01f));
            pose.m_252880_(0.5f, 0.5f, 0.5f);
            ItemStackLighting.flushAndSetup(multiBufferSource, pose);
            Minecraft.m_91087_().m_91291_().m_115143_(item, ItemDisplayContext.GUI, true, pose, multiBufferSource, light, overlay, Minecraft.m_91087_().m_91291_().m_174264_(item, null, null, 0));
            ItemStackLighting.flushAndRestore(multiBufferSource);
            pose.m_85849_();
        }
        if (!data.icon.m_41619_() && (icon = data.icon) != null) {
            pose.m_85836_();
            if (context != ItemDisplayContext.FIXED) {
                pose.m_85837_(0.22, 0.22, 0.54);
            } else {
                Quaternionf rotation = new Quaternionf();
                rotation.rotateAxis((float)Math.PI, 0.0f, 1.0f, 0.0f);
                pose.m_252781_(rotation);
                pose.m_85837_(-0.78, 0.23, -0.46);
            }
            pose.m_252880_(0.3f, -0.2f, 0.02f);
            pose.m_85841_(0.4f, 0.4f, 1.0f);
            pose.m_252931_(new Matrix4f().scale(1.0f, 1.0f, 0.01f));
            pose.m_252880_(0.5f, 0.5f, 0.5f);
            ItemStackLighting.flushAndSetup(multiBufferSource, pose);
            Minecraft.m_91087_().m_91291_().m_115143_(icon, ItemDisplayContext.GUI, true, pose, multiBufferSource, light, overlay, Minecraft.m_91087_().m_91291_().m_174264_(icon, null, null, 0));
            ItemStackLighting.flushAndRestore(multiBufferSource);
            pose.m_85849_();
        }
    }
}

