/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.handler.BaubleItemHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.items.MaidInteractItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class PortableCraftCalculatorBauble
extends MaidInteractItem
implements IMaidBauble {
    public static final String TAG_STORED_RECIPE = "recipes";
    public static final String TAG_STORED_LAYERS = "layers";
    public static final String TAG_PROGRESS = "progress";

    public static ItemStack getCalculator(EntityMaid maid) {
        BaubleItemHandler inv = maid.getMaidBauble();
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (!stack.m_150930_((Item)ItemRegistry.PORTABLE_CRAFT_CALCULATOR_BAUBLE.get())) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static void update(EntityMaid maid) {
        ItemStack calculator = PortableCraftCalculatorBauble.getCalculator(maid);
        if (calculator.m_41619_()) {
            return;
        }
        PortableCraftCalculatorBauble.update(maid, calculator);
    }

    public static void update(EntityMaid maid, ItemStack calculator) {
        CompoundTag tag = calculator.m_41784_();
        if (Conditions.takingRequestList(maid)) {
            tag.m_128405_(TAG_STORED_RECIPE, MemoryUtil.getCrafting((EntityMaid)maid).craftGuides.size());
        } else {
            tag.m_128473_(TAG_STORED_RECIPE);
        }
        calculator.m_41751_(tag);
    }

    public void onTick(EntityMaid maid, ItemStack baubleItem) {
        if (maid.m_9236_().f_46443_) {
            return;
        }
        PortableCraftCalculatorBauble.update(maid, baubleItem);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, @NotNull List<Component> toolTip, @NotNull TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, toolTip, p_41424_);
        toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.portable_craft_calculator.desc").m_130940_(ChatFormatting.GRAY));
        if (itemStack.m_41782_()) {
            CompoundTag tag = itemStack.m_41784_();
            if (tag.m_128441_(TAG_STORED_RECIPE)) {
                toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.portable_craft_calculator.stored_recipe", (Object[])new Object[]{tag.m_128451_(TAG_STORED_RECIPE)}));
            } else {
                toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.portable_craft_calculator.waiting_for_request"));
            }
            if (tag.m_128441_(TAG_STORED_LAYERS) && tag.m_128451_(TAG_STORED_LAYERS) != 0) {
                toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.portable_craft_calculator.stored_layers", (Object[])new Object[]{tag.m_128451_(TAG_STORED_LAYERS)}));
                if (tag.m_128441_(TAG_PROGRESS)) {
                    toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.portable_craft_calculator.progress", (Object[])new Object[]{tag.m_128451_(TAG_PROGRESS)}));
                }
            }
        }
    }

    public PortableCraftCalculatorBauble() {
        super(new Item.Properties().m_41487_(1));
    }
}

