/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.ICraftGraphLike;
import studio.fantasyit.maid_storage_manager.craft.algo.utils.ResultListUtils;
import studio.fantasyit.maid_storage_manager.craft.data.CraftResultContext;
import studio.fantasyit.maid_storage_manager.craft.debug.CraftingDebugContext;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;

public class BiCraftCountCalculator
implements IDebugContextSetter {
    private final ICraftGraphLike availableCraftGraph;
    private final int availableSlots;
    private List<Pair<ItemStack, Integer>> fails = new ArrayList<Pair<ItemStack, Integer>>();
    private List<Pair<ItemStack, Integer>> fullGroupFails = List.of();
    private final ItemStack item;
    int currentRequire = 0;
    int maxRequire = 0;
    boolean singleItemProcess = false;
    List<CraftLayer> results = new ArrayList<CraftLayer>();
    boolean hasAnySuccessCraftingCalc = false;
    private CraftingDebugContext debugContext = CraftingDebugContext.Dummy.INSTANCE;

    public BiCraftCountCalculator(ICraftGraphLike availableCraftGraph, ItemStack item, int requireCount, int availableSlots) {
        this.availableCraftGraph = availableCraftGraph;
        this.currentRequire = requireCount;
        this.maxRequire = requireCount;
        this.availableSlots = availableSlots;
        this.item = item;
        availableCraftGraph.setSpeed(128);
        availableCraftGraph.startContext(this.item, requireCount);
    }

    public boolean tick() {
        if (!this.availableCraftGraph.buildGraph()) {
            return true;
        }
        if (!this.availableCraftGraph.processQueues()) {
            return true;
        }
        this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Crafting Inv Simulator Start", new Object[0]);
        List<CraftLayer> currentResults = this.availableCraftGraph.getResults();
        CraftResultContext context = null;
        boolean success = false;
        if (currentResults.size() > Config.craftingMaxLayerLimit) {
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Crafting Inv Simulator Failed Due to too large layer list", new Object[0]);
            currentResults = null;
        }
        if (currentResults != null && !currentResults.isEmpty()) {
            this.hasAnySuccessCraftingCalc = true;
            context = new CraftResultContext(currentResults);
            if (context.getSlotConsume() <= this.availableSlots) {
                this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Inv OK", new Object[0]);
                success = true;
            }
            if (!success) {
                context.splitTaskWith(this.availableSlots);
                if (context.getSlotConsume() <= this.availableSlots) {
                    this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Inv OK (Store steps)", new Object[0]);
                    success = true;
                }
            }
            if (!success) {
                this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Splitting steps", new Object[0]);
                ResultListUtils.unsetPlaceBefore(currentResults);
                currentResults = ResultListUtils.splitIntoSingleStep(currentResults);
                if (currentResults.size() > Config.craftingMaxLayerLimit) {
                    this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Crafting Inv Simulator Failed Due to too large layer list", new Object[0]);
                    context = null;
                } else {
                    context = new CraftResultContext(currentResults);
                }
            }
            if (context != null && context.getSlotConsume() <= this.availableSlots) {
                this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Inv OK", new Object[0]);
                success = true;
            }
            if (!success && context != null) {
                context.splitTaskWith(this.availableSlots);
                if (context.getSlotConsume() <= this.availableSlots) {
                    this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Inv OK (Store steps)", new Object[0]);
                    success = true;
                }
            }
            if (!success) {
                currentResults = null;
            }
        }
        if (currentResults != null && !currentResults.isEmpty()) {
            if (!this.singleItemProcess && this.currentRequire != 1 && this.availableCraftGraph.shouldStartUsingSingleItemProcess()) {
                this.singleItemProcess = true;
                this.currentRequire = 1;
                this.availableCraftGraph.restoreCurrentAndStartContext(this.item, this.currentRequire);
                return true;
            }
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Step done * %s", this.currentRequire);
            this.results.addAll(currentResults);
            this.maxRequire -= this.currentRequire;
            this.currentRequire = this.maxRequire;
            if (this.singleItemProcess) {
                this.currentRequire = 1;
            }
            context.forEachRemaining(this.availableCraftGraph::addRemainItem);
            currentResults.get(currentResults.size() - 1).getItems().stream().filter(itemStack -> !ItemStackUtil.isSame(itemStack, this.item, false)).forEach(t -> this.availableCraftGraph.addRemainItem((ItemStack)t, t.m_41613_()));
            if (this.maxRequire <= 0) {
                return false;
            }
            this.availableCraftGraph.startContext(this.item, this.currentRequire);
            this.fullGroupFails = List.of();
        } else {
            if (this.maxRequire == this.currentRequire) {
                this.fullGroupFails = this.availableCraftGraph.getFails();
            }
            this.debugContext.logNoLevel(CraftingDebugContext.TYPE.SIMULATOR, "Step fail with %d", this.currentRequire);
            this.currentRequire /= 2;
            Optional<Integer> maxAvailable = this.availableCraftGraph.getMaxAvailable();
            if (maxAvailable.isPresent()) {
                while (maxAvailable.get() < this.currentRequire) {
                    this.currentRequire /= 2;
                }
            }
            if (this.currentRequire == 0) {
                this.fails.addAll(this.fullGroupFails);
                this.availableCraftGraph.restoreCurrent();
                return false;
            }
            this.availableCraftGraph.setSpeed(64);
            this.availableCraftGraph.restoreCurrentAndStartContext(this.item, this.currentRequire);
        }
        return true;
    }

    public List<CraftLayer> getResults() {
        return this.results;
    }

    public List<Pair<ItemStack, Integer>> getFails() {
        return this.fails;
    }

    public boolean hasAnySuccessCraftingCalc() {
        return this.hasAnySuccessCraftingCalc;
    }

    public int getWorstRestSteps() {
        return MathUtil.biMaxStepCalc(this.maxRequire) - (int)MathUtil.log2((double)this.maxRequire / (double)this.currentRequire);
    }

    public int getNotCraftedCount() {
        return this.maxRequire;
    }

    @Override
    public void setDebugContext(CraftingDebugContext context) {
        this.debugContext = context;
    }
}

