/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.LLMCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatManager;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.papi.PapiReplacer;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ResponseCallback;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMConfig;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMMessage;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.FunctionToolCall;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.openai.response.ToolCall;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.CappedQueue;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.ai.AiUtils;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.CraftMemory;
import studio.fantasyit.maid_storage_manager.network.JEIRequestResultPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class RequestItemUtil {
    public static void stopJobAndStoreOrThrowItem(EntityMaid maid, @Nullable IStorageContext storeTo, @Nullable Entity targetEntity) {
        Level level = maid.m_9236_();
        ItemStack reqList = maid.m_21205_();
        CompoundTag tag = reqList.m_41784_();
        if (tag.m_128471_("virtual")) {
            if (tag.m_128461_("virtual_source").equals("AI")) {
                RequestItemUtil.sendToolResponseB(maid, reqList);
            } else if (tag.m_128461_("virtual_source").equals("JEI")) {
                LivingEntity livingEntity = maid.m_269323_();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)livingEntity;
                    Network.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new JEIRequestResultPacket((Component)Component.m_237110_((String)"gui.maid_storage_manager.jei_request.finish", (Object[])new Object[]{maid.m_5446_()})));
                }
            } else if (tag.m_128461_("virtual_source").equals("DISPATCHED")) {
                RequestItemUtil.dispatchedTaskDone(maid, reqList);
            } else if (tag.m_128461_("virtual_source").equals("DISPATCH_FIND")) {
                RequestItemUtil.dispatchFindTaskDone(maid, reqList);
            }
        } else if (tag.m_128451_("interval") <= 0 && targetEntity != null) {
            Vec3 targetDir = MathUtil.getFromToWithFriction((Entity)maid, targetEntity.m_20182_());
            tag.m_128379_("ignore_task", true);
            reqList.m_41751_(tag);
            InvUtil.throwItem(maid, reqList, targetDir, true);
            MemoryUtil.setReturnToScheduleAt(maid, level.m_7654_().m_129921_() + 80);
        } else if (tag.m_128451_("interval") > 0 || storeTo == null || !InvUtil.tryPlace(storeTo, reqList).m_41619_()) {
            if (tag.m_128451_("interval") > 0) {
                tag.m_128405_("cooling", tag.m_128451_("interval"));
            } else {
                tag.m_128379_("ignore_task", true);
            }
            reqList.m_41751_(tag);
            if (!InvUtil.tryPlace((IItemHandler)maid.getAvailableInv(false), reqList).m_41619_()) {
                InvUtil.throwItem(maid, reqList);
            }
        }
        MemoryUtil.getRequestProgress(maid).clearTarget();
        MemoryUtil.getRequestProgress(maid).stopWork();
        maid.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
    }

    private static void sendToolResponseB(EntityMaid maid, ItemStack reqList) {
        if (!Config.twoStepAiResponse) {
            return;
        }
        MaidAIChatManager aiChatManager = maid.getAiChatManager();
        LLMSite llmSite = aiChatManager.getLLMSite();
        ServerPlayer owner = (ServerPlayer)maid.m_269323_();
        if (llmSite == null || owner == null) {
            return;
        }
        LLMClient client = llmSite.client();
        StringBuilder sb = new StringBuilder();
        CompoundTag tag = reqList.m_41784_();
        ListTag list = tag.m_128437_("items", 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack itemstack;
            CompoundTag itemTag = list.m_128728_(i);
            if (!itemTag.m_128441_("item") || (itemstack = ItemStackUtil.parseStack(itemTag.m_128469_("item"))).m_41619_()) continue;
            int collected = itemTag.m_128451_("collected");
            int requested = itemTag.m_128451_("requested");
            if (itemTag.m_128471_("done")) {
                sb.append("[Finished]");
            } else {
                sb.append("[Processing]");
            }
            sb.append(itemstack.m_41786_().getString());
            sb.append(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_())));
            sb.append(" has collected ");
            sb.append(collected);
            sb.append(" and plans to get ");
            sb.append(requested == -1 ? "any amount" : Integer.valueOf(requested));
            sb.append(".");
            sb.append("\n");
        }
        FunctionToolCall functionToolCall = new FunctionToolCall("stock", "{}");
        String id = UUID.randomUUID().toString();
        ToolCall toolCall = new ToolCall(id, functionToolCall);
        List llmMessages = aiChatManager.getSetting().map(s -> {
            String setting = s.getSetting(maid, AiUtils.transformLanguage(owner.getLanguage()));
            CappedQueue history = aiChatManager.getHistory();
            ArrayList chatList = Lists.newArrayList();
            chatList.add(LLMMessage.systemChat((EntityMaid)maid, (String)setting));
            history.getDeque().descendingIterator().forEachRemaining(chatList::add);
            return chatList;
        }).orElseGet(() -> {
            if (StringUtils.isNotBlank((CharSequence)aiChatManager.customSetting)) {
                String setting = PapiReplacer.replace((String)aiChatManager.customSetting, (EntityMaid)maid, (String)AiUtils.transformLanguage(owner.getLanguage()));
                CappedQueue history = aiChatManager.getHistory();
                ArrayList chatList = Lists.newArrayList();
                chatList.add(LLMMessage.systemChat((EntityMaid)maid, (String)setting));
                history.getDeque().descendingIterator().forEachRemaining(chatList::add);
                return chatList;
            }
            return Lists.newArrayList();
        });
        llmMessages.add(LLMMessage.userChat((EntityMaid)maid, (String)"Please query and tell me the situation of last task."));
        llmMessages.add(LLMMessage.assistantChat((EntityMaid)maid, (String)"Query task progress.", List.of(toolCall)));
        llmMessages.add(LLMMessage.toolChat((EntityMaid)maid, (String)sb.toString(), (String)id));
        LLMCallback callback = new LLMCallback(aiChatManager, "Please query and tell me the situation of last task.", 0L);
        LLMConfig config = LLMConfig.normalChat((String)aiChatManager.getLLMModel(), (EntityMaid)maid);
        client.chat(llmMessages, config, (ResponseCallback)callback);
    }

    private static void dispatchedTaskDone(EntityMaid maid, ItemStack reqList) {
        CompoundTag data = RequestListItem.getVirtualData(reqList);
        if (data == null) {
            return;
        }
        UUID masterUUID = data.m_128342_("master");
        int index = data.m_128451_("index");
        Entity targetEntity = ((ServerLevel)maid.m_9236_()).m_8791_(masterUUID);
        if (!(targetEntity instanceof EntityMaid)) {
            return;
        }
        EntityMaid toMaid = (EntityMaid)targetEntity;
        CraftMemory targetCraftingMemory = MemoryUtil.getCrafting(toMaid);
        if (!targetCraftingMemory.hasPlan()) {
            return;
        }
        CraftLayerChain targetPlan = targetCraftingMemory.plan();
        targetPlan.dispatchedDone(maid, toMaid, index, RequestListItem.isAllSuccess(reqList), reqList);
        targetPlan.showCraftingProgress(toMaid);
    }

    private static void dispatchFindTaskDone(EntityMaid maid, ItemStack reqList) {
        CompoundTag data = RequestListItem.getVirtualData(reqList);
        if (data == null) {
            return;
        }
        UUID masterUUID = data.m_128342_("master");
        Entity targetEntity = ((ServerLevel)maid.m_9236_()).m_8791_(masterUUID);
        ItemStack toItem = reqList.m_41777_();
        RequestListItem.clearAllNonSuccess(toItem);
        CompoundTag tag = toItem.m_41784_();
        tag.m_128473_("virtual");
        tag.m_128473_("virtual_source");
        toItem.m_41751_(tag);
        if (targetEntity instanceof EntityMaid) {
            EntityMaid toMaid = (EntityMaid)targetEntity;
            ItemStack restItem = InvUtil.tryPlace((IItemHandler)toMaid.getAvailableInv(true), toItem);
            if (restItem.m_41619_()) {
                MemoryUtil.getRequestProgress(toMaid).newWork(RequestListItem.getUUID(toItem));
                MemoryUtil.getRequestProgress(toMaid).setTryCrafting(true);
            }
            toItem = restItem;
        }
        if (!toItem.m_41619_()) {
            InvUtil.throwItem(maid, toItem);
        }
    }

    public static ItemStack makeVirtualItemStack(List<ItemStack> list, @Nullable Target target, @Nullable Entity targetEntity, String virtual_source) {
        ItemStack itemStack = ((Item)ItemRegistry.REQUEST_LIST_ITEM.get()).m_7968_().m_41777_();
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128379_("virtual", true);
        tag.m_128359_("virtual_source", virtual_source);
        ListTag listTag = new ListTag();
        for (int i = 0; i < Math.max(list.size(), 10); ++i) {
            ItemStack item = i < list.size() ? list.get(i) : ItemStack.f_41583_;
            CompoundTag tmp = new CompoundTag();
            tmp.m_128405_("requested", item.m_41613_());
            tmp.m_128365_("item", (Tag)ItemStackUtil.saveStack(item.m_255036_(1)));
            listTag.add((Object)tmp);
        }
        tag.m_128365_("items", (Tag)listTag);
        tag.m_128379_("blackmode", false);
        tag.m_128379_("stock_mode", false);
        tag.m_128379_("ignore_task", false);
        tag.m_128379_("match_tag", false);
        tag.m_128405_("interval", 0);
        if (target != null) {
            tag.m_128365_("storage", (Tag)target.toNbt());
        } else if (targetEntity != null) {
            tag.m_128362_("storage_entity", targetEntity.m_20148_());
        }
        tag.m_128362_("uuid", UUID.randomUUID());
        itemStack.m_41751_(tag);
        return itemStack;
    }

    public static ItemStack makeVirtualItemStack(ItemStack source, String virtual_source) {
        CompoundTag tag = source.m_41783_().m_6426_();
        tag.m_128379_("virtual", true);
        tag.m_128359_("virtual_source", virtual_source);
        ItemStack itemStack = ((Item)ItemRegistry.REQUEST_LIST_ITEM.get()).m_7968_().m_41777_();
        itemStack.m_41751_(tag);
        return itemStack;
    }

    public static void markVisForCurrentRequestList(ServerLevel level, EntityMaid maid, AbstractTargetMemory target) {
        Target storageBlock = RequestListItem.getStorageBlock(maid.m_21205_());
        if (storageBlock != null) {
            target.addVisitedPos(storageBlock);
            StorageAccessUtil.checkNearByContainers((Level)level, storageBlock.getPos(), pos -> target.addVisitedPos(storageBlock.sameType((BlockPos)pos, null)));
        }
    }
}

