/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.maid.memory.CraftMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.LogisticsMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.MealMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.PlacingInventoryMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.RequestProgressMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ResortingMemory;
import studio.fantasyit.maid_storage_manager.maid.memory.ViewedInventoryMemory;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class MemoryUtil {
    public static BlockPos getTargetPos(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).filter(t -> t instanceof BlockPosTracker).map(t -> (BlockPosTracker)t).map(BlockPosTracker::m_6675_).orElse(null);
    }

    public static RequestProgressMemory getRequestProgress(EntityMaid maid) {
        if (!maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.REQUEST_PROGRESS.get())) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.REQUEST_PROGRESS.get(), (Object)new RequestProgressMemory());
        }
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.REQUEST_PROGRESS.get()).orElse(null);
    }

    public static ViewedInventoryMemory getViewedInventory(EntityMaid maid) {
        if (!maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.VIEWED_INVENTORY.get())) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.VIEWED_INVENTORY.get(), (Object)new ViewedInventoryMemory());
        }
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.VIEWED_INVENTORY.get()).orElse(null);
    }

    public static void setReturnToScheduleAt(EntityMaid maid, int time) {
        maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.RETURN_TO_SCHEDULE_AT.get(), (Object)time);
    }

    public static Integer getReturnToScheduleAt(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.RETURN_TO_SCHEDULE_AT.get()).orElse(null);
    }

    public static void clearReturnWorkSchedule(EntityMaid maid) {
        maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.RETURN_TO_SCHEDULE_AT.get());
    }

    public static void clearTarget(EntityMaid maid) {
        maid.m_6274_().m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
        maid.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }

    public static PlacingInventoryMemory getPlacingInv(EntityMaid maid) {
        if (!maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.PLACING_INVENTORY.get())) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.PLACING_INVENTORY.get(), (Object)new PlacingInventoryMemory());
        }
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.PLACING_INVENTORY.get()).orElse(null);
    }

    public static ResortingMemory getResorting(EntityMaid maid) {
        if (!maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.RESORTING.get())) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.RESORTING.get(), (Object)new ResortingMemory());
        }
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.RESORTING.get()).orElse(null);
    }

    public static void setTarget(EntityMaid maid, BlockPos goal, float collectSpeed) {
        maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new BlockPosTracker(goal));
        BehaviorUtils.m_22617_((LivingEntity)maid, (BlockPos)goal, (float)collectSpeed, (int)0);
    }

    public static void setTarget(EntityMaid maid, Entity entity, float collectSpeed) {
        maid.m_6274_().m_21879_((MemoryModuleType)InitEntities.TARGET_POS.get(), (Object)new EntityTracker(entity, true));
        BehaviorUtils.m_22590_((LivingEntity)maid, (Entity)entity, (float)collectSpeed, (int)0);
    }

    public static ScheduleBehavior.Schedule getCurrentlyWorking(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.CURRENTLY_WORKING.get()).orElse(ScheduleBehavior.Schedule.NO_SCHEDULE);
    }

    public static CraftMemory getCrafting(EntityMaid maid) {
        if (!maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.CRAFTING.get())) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.CRAFTING.get(), (Object)new CraftMemory());
        }
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.CRAFTING.get()).orElse(null);
    }

    public static LogisticsMemory getLogistics(EntityMaid maid) {
        if (!maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.LOGISTICS.get())) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.LOGISTICS.get(), (Object)new LogisticsMemory());
        }
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.LOGISTICS.get()).orElse(null);
    }

    public static MealMemory getMeal(EntityMaid maid) {
        if (!maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.MEAL.get())) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.MEAL.get(), (Object)new MealMemory());
        }
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.MEAL.get()).orElse(null);
    }

    public static void setLookAt(EntityMaid maid, BlockPos pos) {
        maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos));
    }

    public static void setLookAt(EntityMaid maid, Entity target) {
        maid.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker(target, true));
    }

    public static BlockPos getInteractPos(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.INTERACTION_RESULT.get()).orElse(null);
    }

    public static void setInteractPos(EntityMaid maid, BlockPos above) {
        maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.INTERACTION_RESULT.get(), (Object)above);
    }

    public static void clearInteractPos(EntityMaid maid) {
        maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.INTERACTION_RESULT.get());
    }

    public static Target getCoWorkTargetStorage(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.CO_WORK_TARGET_STORAGE.get()).orElse(null);
    }

    public static boolean isCoWorking(EntityMaid maid) {
        return maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.CO_WORK_MODE.get());
    }

    public static boolean isWorking(EntityMaid maid) {
        return maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.IS_WORKING.get());
    }

    public static void setWorking(EntityMaid maid, boolean working) {
        if (working) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.IS_WORKING.get(), (Object)true);
        } else {
            maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.IS_WORKING.get());
        }
    }

    public static void resetParallelWorking(EntityMaid maid) {
        maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.PARALLEL_WORKING.get());
    }

    public static boolean isParallelWorking(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.PARALLEL_WORKING.get()).orElse(0) > 0;
    }

    public static void joinAndStartParallelWorking(EntityMaid maid) {
        int parallelWorking = maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.PARALLEL_WORKING.get()).orElse(0) + 1;
        maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.PARALLEL_WORKING.get(), (Object)parallelWorking);
        MemoryUtil.setWorking(maid, true);
    }

    public static void leaveParallelWorking(EntityMaid maid) {
        int parallelWorking = maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.PARALLEL_WORKING.get()).orElse(0) - 1;
        if (parallelWorking <= 0) {
            parallelWorking = 0;
            MemoryUtil.setWorking(maid, false);
        }
        maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.PARALLEL_WORKING.get(), (Object)parallelWorking);
    }

    public static boolean canPickUpItemTemp(EntityMaid maid, UUID target) {
        if (maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.ENABLE_PICKUP_TEMP.get())) {
            return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.ENABLE_PICKUP_TEMP.get()).map(uuid -> uuid.equals(target)).orElse(false);
        }
        return false;
    }

    public static void setPickUpItemTemp(EntityMaid maid, UUID target) {
        maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.ENABLE_PICKUP_TEMP.get(), (Object)target);
    }

    public static void clearPickUpItemTemp(EntityMaid maid) {
        maid.m_6274_().m_21936_((MemoryModuleType)MemoryModuleRegistry.ENABLE_PICKUP_TEMP.get());
    }

    public static void goRestrictCenterAndWait(EntityMaid maid, float speed) {
        if (!maid.m_21536_()) {
            return;
        }
        BlockPos restrictCenter = maid.getSchedulePos().getWorkPos();
        if (maid.m_20238_(restrictCenter.m_252807_()) < 9.0) {
            return;
        }
        MemoryUtil.setTarget(maid, restrictCenter, speed);
        MemoryUtil.setGoingCenter(maid, true);
    }

    public static boolean isGoingCenter(EntityMaid maid) {
        return maid.m_6274_().m_21952_((MemoryModuleType)MemoryModuleRegistry.RETURN_CENTER.get()).orElse(false);
    }

    public static void setGoingCenter(EntityMaid maid, boolean goingCenter) {
        maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.RETURN_CENTER.get(), (Object)goingCenter);
    }
}

