/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.Logger;
import studio.fantasyit.maid_storage_manager.entity.VirtualItemEntity;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInsertableContext;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class InvUtil {
    public static boolean hasAnyFree(IItemHandler container) {
        for (int i = 0; i < container.getSlots(); ++i) {
            if (!container.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack tryPlace(IItemHandler container, ItemStack itemStack) {
        int i;
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        ItemStack restItem = itemStack.m_41777_();
        for (i = 0; !(i >= container.getSlots() || ItemStack.m_150942_((ItemStack)container.getStackInSlot(i), (ItemStack)restItem) && (restItem = container.insertItem(i, restItem, false)).m_41619_()); ++i) {
        }
        for (i = 0; !(i >= container.getSlots() || container.isItemValid(i, itemStack) && (restItem = container.insertItem(i, restItem, false)).m_41619_()); ++i) {
        }
        return restItem;
    }

    public static ItemStack tryPlace(IStorageContext container, ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return itemStack;
        }
        if (container instanceof IStorageInsertableContext) {
            IStorageInsertableContext isic = (IStorageInsertableContext)container;
            return isic.insert(itemStack);
        }
        return itemStack;
    }

    public static ItemStack tryExtract(IItemHandler inv, ItemStack itemStack, boolean matchTag) {
        int extractCurrent;
        ItemStack get;
        ItemStack stackInSlot;
        int count = 0;
        int max = itemStack.m_41613_();
        for (int i = 0; !(i >= inv.getSlots() || ItemStackUtil.isSame(stackInSlot = inv.getStackInSlot(i), itemStack, matchTag) && (count += (get = inv.extractItem(i, extractCurrent = Math.min(max - count, stackInSlot.m_41613_()), false)).m_41613_()) >= max); ++i) {
        }
        return itemStack.m_255036_(count);
    }

    public static ItemStack tryExtractForCrafting(IItemHandler inv, ItemStack itemStack) {
        int extractCurrent;
        ItemStack get;
        ItemStack stackInSlot;
        int count = 0;
        int max = itemStack.m_41613_();
        for (int i = 0; !(i >= inv.getSlots() || ItemStackUtil.isSameInCrafting(stackInSlot = inv.getStackInSlot(i), itemStack) && (count += (get = inv.extractItem(i, extractCurrent = Math.min(max - count, stackInSlot.m_41613_()), false)).m_41613_()) >= max); ++i) {
        }
        return itemStack.m_255036_(count);
    }

    public static int maxCanPlace(IItemHandler container, ItemStack itemStack) {
        int count = 0;
        ItemStack testStack = itemStack.m_255036_(itemStack.m_41741_());
        for (int i = 0; i < container.getSlots(); ++i) {
            if (!container.isItemValid(i, itemStack)) continue;
            @NotNull ItemStack rest = container.insertItem(i, testStack, true);
            if (rest.m_41619_()) {
                count += itemStack.m_41741_();
                continue;
            }
            count += itemStack.m_41741_() - rest.m_41613_();
        }
        return count;
    }

    public static boolean isEmpty(CombinedInvWrapper availableInv) {
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            if (availableInv.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static List<ItemStack> forSlotMatches(IItemHandler container, Predicate<ItemStack> matches) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack stackInSlot = container.getStackInSlot(i);
            if (!matches.test(stackInSlot)) continue;
            list.add(stackInSlot);
        }
        return list;
    }

    public static int freeSlots(IItemHandler availableInv) {
        int count = 0;
        for (int i = 0; i < availableInv.getSlots(); ++i) {
            if (!availableInv.getStackInSlot(i).m_41619_()) continue;
            ++count;
        }
        return count;
    }

    public static ItemEntity throwItem(EntityMaid maid, ItemStack itemStack) {
        Vec3 direction = Vec3.m_82498_((float)maid.m_146909_(), (float)maid.m_146908_()).m_82541_().m_82490_(0.5);
        return InvUtil.throwItem(maid, itemStack, direction);
    }

    public static ItemEntity throwItem(EntityMaid maid, ItemStack itemStack, Vec3 direction) {
        return InvUtil.throwItem(maid, itemStack, direction, false);
    }

    public static ItemEntity throwItem(EntityMaid maid, ItemStack itemStack, Vec3 direction, boolean noPickUpDelay) {
        Level level = maid.m_9236_();
        ItemEntity itementity = new ItemEntity(level, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), itemStack);
        maid.m_8132_();
        itementity.m_20256_(direction);
        itementity.m_149678_();
        if (noPickUpDelay) {
            itementity.m_32061_();
        }
        level.m_7967_((Entity)itementity);
        return itementity;
    }

    public static VirtualItemEntity throwItemVirtual(EntityMaid maid, ItemStack itemStack, Vec3 direction) {
        if (MemoryUtil.getCrafting(maid).hasPlan() && MemoryUtil.getCrafting(maid).plan().isMaster()) {
            Logger.debug("[II]throw %s %d", itemStack.m_41720_(), itemStack.m_41613_());
        }
        Level level = maid.m_9236_();
        VirtualItemEntity itementity = VirtualItemEntity.create(level, maid.m_20182_(), itemStack);
        maid.m_8132_();
        itementity.m_20256_(direction);
        level.m_7967_((Entity)itementity);
        return itementity;
    }

    public static void pickUpVirtual(EntityMaid maid, VirtualItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.getItem();
        CombinedInvWrapper availableInv = maid.getAvailableInv(true);
        ItemStack rest = InvUtil.tryPlace((IItemHandler)availableInv, itemStack);
        if (MemoryUtil.getCrafting(maid).hasPlan() && MemoryUtil.getCrafting(maid).plan().isMaster()) {
            Logger.debug("[II]pickup %s %d", itemStack.m_41720_(), itemStack.m_41613_() - rest.m_41613_());
        }
        if (rest.m_41619_()) {
            ((ServerLevel)maid.m_9236_()).m_7726_().m_8445_((Entity)itemEntity, (Packet)new ClientboundTakeItemEntityPacket(itemEntity.m_19879_(), maid.m_19879_(), 1));
            itemEntity.m_146870_();
        } else {
            itemEntity.setItem(rest);
        }
    }

    public static int getTargetIndex(EntityMaid maid, ItemStack itemStack, boolean matchTag) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemStackUtil.isSame(inv.getStackInSlot(i), itemStack, matchTag)) continue;
            return i;
        }
        return -1;
    }

    public static int getTargetIndexInCrafting(EntityMaid maid, ItemStack itemStack) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemStackUtil.isSameInCrafting(inv.getStackInSlot(i), itemStack)) continue;
            return i;
        }
        return -1;
    }

    public static void swapHandAndSlot(EntityMaid maid, int slot) {
        CombinedInvWrapper inv = maid.getAvailableInv(true);
        ItemStack hand = maid.m_21205_();
        maid.m_21008_(InteractionHand.MAIN_HAND, inv.getStackInSlot(slot));
        inv.setStackInSlot(slot, hand);
    }

    public static void mergeSameStack(IItemHandler inv) {
        for (int i = inv.getSlots() - 1; i >= 0; --i) {
            ItemStack stackInSlot = inv.getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            for (int j = 0; j < i; ++j) {
                ItemStack stackInSlot1 = inv.getStackInSlot(j);
                ItemStack rest = inv.insertItem(i, stackInSlot1, false);
                if (rest.m_41613_() == stackInSlot1.m_41613_()) continue;
                inv.extractItem(j, stackInSlot1.m_41613_() - rest.m_41613_(), false);
            }
        }
    }
}

