/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.rs;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.rs.AbstractRSContext;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class RSCollectContext
extends AbstractRSContext
implements IStorageExtractableContext {
    int current = 0;
    List<ItemStack> task = null;
    boolean matchNbt = false;

    @Override
    public void start(EntityMaid maid, ServerLevel level, Target target) {
        super.start(maid, level, target);
    }

    @Override
    public boolean isDone() {
        return super.isDone() || this.network == null || this.task != null && this.current >= this.task.size();
    }

    @Override
    public boolean hasTask() {
        return this.task != null;
    }

    @Override
    public void clearTask() {
        this.task = null;
        this.current = 0;
    }

    @Override
    public void tick(Function<ItemStack, ItemStack> callback) {
        if (this.network == null || this.task == null || this.current >= this.task.size()) {
            return;
        }
        List<ItemStack> itemStack = List.of(this.task.get(this.current));
        int toCollect = this.task.get(this.current).m_41613_();
        if (!this.matchNbt) {
            itemStack = this.stackListStacks.stream().filter(stack -> ItemStackUtil.isSame((ItemStack)stack.getStack(), this.task.get(this.current), this.matchNbt)).map(StackListEntry::getStack).toList();
        }
        for (ItemStack stack2 : itemStack) {
            ItemStack rested;
            int currentToCollect;
            ItemStack extractedSim = this.network.extractItem(stack2, currentToCollect = Math.min(toCollect, stack2.m_41613_()), Action.SIMULATE);
            if (extractedSim.m_41619_() || (currentToCollect -= (rested = callback.apply(extractedSim)).m_41613_()) <= 0) continue;
            this.network.extractItem(stack2, currentToCollect, Action.PERFORM);
            if ((toCollect -= currentToCollect) > 0) continue;
            break;
        }
        ++this.current;
    }

    @Override
    public void setExtract(List<ItemStack> itemList, boolean matchNbt) {
        this.task = itemList;
        this.matchNbt = matchNbt;
        this.current = 0;
    }

    @Override
    public void setExtractByExisting(Predicate<ItemStack> predicate) {
        if (this.stackListStacks != null) {
            this.setExtract(this.stackListStacks.stream().map(StackListEntry::getStack).filter(predicate).toList(), true);
        } else {
            this.setExtract(List.of(), true);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.current = 0;
    }

    @Override
    public void finish() {
        super.finish();
        if (this.task != null) {
            this.current = this.task.size();
        }
    }
}

