/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.create.stock;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.integration.create.CreateIntegration;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.create.stock.AbstractCreateContext;
import studio.fantasyit.maid_storage_manager.storage.create.stock.ChainRouterManager;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CreateCollectContext
extends AbstractCreateContext
implements IStorageExtractableContext {
    protected ChainConveyorBlockEntity chainConveyorBlockEntity;
    protected BlockPos connection;
    protected List<IItemHandler> itemHandlers = new ArrayList<IItemHandler>();
    protected String targetPackageName;
    protected List<ItemStack> itemList;
    protected List<ItemStack> sentRequests = new ArrayList<ItemStack>();
    protected List<ItemStack> costedSlots = new ArrayList<ItemStack>();
    protected boolean matchNbt;
    int waitCircle = 0;
    int timeoutAt = Integer.MAX_VALUE;
    boolean reversed = false;
    BlockPos relativePos;
    double onChainPos;
    int nextStartUpdateAt = 0;
    private CombinedInvWrapper availableInv;
    public static TagKey<Block> CreatePackageContainer = TagKey.m_203882_((ResourceKey)ForgeRegistries.BLOCKS.getRegistryKey(), (ResourceLocation)new ResourceLocation("maid_storage_manager", "create_package_container"));

    @Override
    public void start(EntityMaid maid, ServerLevel level, Target target) {
        super.start(maid, level, target);
        this.targetPackageName = CreateIntegration.getAddress(maid, CreateIntegration.AddressType.REQUEST);
        this.rescanItemHandler();
        this.reselectChain();
        this.availableInv = maid.getAvailableInv(true);
        for (int i = 0; i < this.availableInv.getSlots(); ++i) {
            if (this.availableInv.getStackInSlot(i).m_41619_()) continue;
            this.isEnoughToAddItem(this.availableInv.getStackInSlot(i));
        }
    }

    private void rescanItemHandler() {
        this.itemHandlers.clear();
        ServerLevel level = (ServerLevel)this.maid.m_9236_();
        BlockPos.m_121921_((AABB)this.maid.m_20191_().m_82400_(5.0)).forEach(pos -> {
            BlockEntity be;
            BlockState state = level.m_8055_(pos);
            if (state.m_204336_(CreatePackageContainer) && (be = level.m_7702_(pos)) != null) {
                be.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(this.itemHandlers::add);
            }
        });
    }

    public void reselectChain() {
        Level level = this.maid.m_9236_();
        MutableDouble minDistance = new MutableDouble(Double.MAX_VALUE);
        MutableDouble minPos = new MutableDouble(Double.MAX_VALUE);
        MutableObject selected = new MutableObject(null);
        MutableObject selectedConnection = new MutableObject(null);
        BlockPos.m_121921_((AABB)this.maid.m_20191_().m_82400_(20.0)).forEach(pos -> {
            BlockEntity patt5212$temp;
            BlockState state = level.m_8055_(pos);
            if (state.m_60713_((Block)AllBlocks.CHAIN_CONVEYOR.get()) && (patt5212$temp = level.m_7702_(pos)) instanceof ChainConveyorBlockEntity) {
                ChainConveyorBlockEntity chainConveyor = (ChainConveyorBlockEntity)patt5212$temp;
                if (chainConveyor.connections.isEmpty()) {
                    return;
                }
                chainConveyor.connections.forEach(connection -> {
                    Pair<Double, Double> dis = this.getDistanceToBeConnectionAndPosition((BlockPos)pos, (BlockPos)connection, this.maid.m_146892_());
                    if ((Double)dis.getA() < minDistance.doubleValue()) {
                        minDistance.setValue((Number)dis.getA());
                        minPos.setValue((Number)dis.getB());
                        selected.setValue((Object)chainConveyor);
                        selectedConnection.setValue(connection);
                    }
                });
            }
        });
        this.chainConveyorBlockEntity = (ChainConveyorBlockEntity)selected.getValue();
        this.connection = (BlockPos)selectedConnection.getValue();
        if (this.chainConveyorBlockEntity != null && this.connection != null) {
            DebugData.sendDebug("[Create Chain]Select Chain %s connection %s(%s)", ((ChainConveyorBlockEntity)selected.getValue()).m_58899_().m_123344_(), this.connection.m_123344_(), ((ChainConveyorBlockEntity)selected.getValue()).m_58899_().m_121955_((Vec3i)this.connection).m_123344_());
            this.relativePos = ((ChainConveyorBlockEntity)selected.getValue()).m_58899_().m_121996_((Vec3i)this.maid.m_20183_());
            this.reversed = this.chainConveyorBlockEntity.reversed;
            this.onChainPos = minPos.getValue();
            if (ChainRouterManager.isChanged(this.targetPackageName, this.chainConveyorBlockEntity.m_58899_().m_121955_((Vec3i)this.connection), this.connection)) {
                this.nextStartUpdateAt = ChainRouterManager.getLastTick(this.targetPackageName) + 100 + 20;
                DebugData.sendDebug("[Create Chain]Delayed for router updates", new Object[0]);
            }
            ChainRouterManager.set(this.targetPackageName, this.chainConveyorBlockEntity.m_58899_().m_121955_((Vec3i)this.connection), this.connection, this.maid.f_19797_);
        }
    }

    public void clearCurrentChain() {
        BlockEntity blockEntity;
        if (this.chainConveyorBlockEntity != null && this.connection != null && (blockEntity = this.maid.m_9236_().m_7702_(this.chainConveyorBlockEntity.m_58899_().m_121955_((Vec3i)this.connection))) instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)blockEntity;
            ccbe.travelPorts.remove(this.relativePos);
        }
        this.connection = null;
        this.chainConveyorBlockEntity = null;
    }

    private void updateChainRoute() {
        if (this.nextStartUpdateAt > this.maid.f_19797_) {
            return;
        }
        BlockEntity blockEntity = this.maid.m_9236_().m_7702_(this.chainConveyorBlockEntity.m_58899_().m_121955_((Vec3i)this.connection));
        if (blockEntity instanceof ChainConveyorBlockEntity) {
            ChainConveyorBlockEntity ccbe = (ChainConveyorBlockEntity)blockEntity;
            BlockPos rev = this.connection.m_142393_(-1);
            ccbe.routingTable.receivePortInfo(this.targetPackageName, rev);
            ccbe.travelPorts.put(this.relativePos, new ChainConveyorBlockEntity.ConnectedPort((float)this.onChainPos, rev, this.targetPackageName));
            ChainRouterManager.update(this.targetPackageName, this.maid.f_19797_);
        }
    }

    @Override
    public boolean isDone() {
        if (this.itemList == null) {
            return false;
        }
        if (this.current < this.itemList.size()) {
            return false;
        }
        if (this.sentRequests.isEmpty()) {
            return true;
        }
        return this.maid.f_19797_ > this.timeoutAt;
    }

    @Override
    public boolean hasTask() {
        return this.itemList != null;
    }

    @Override
    public void clearTask() {
        this.itemList = null;
        this.sentRequests.clear();
    }

    public boolean isEnoughToAddItem(ItemStack itemStack) {
        ItemStackUtil.addToList(this.costedSlots, itemStack, false);
        int tot = 0;
        for (ItemStack ii : this.costedSlots) {
            tot += (ii.m_41613_() + ii.m_41741_() - 1) / ii.m_41741_();
        }
        return tot <= this.availableInv.getSlots();
    }

    @Override
    public void tick(Function<ItemStack, ItemStack> callback) {
        if (this.waitCircle++ % 4 == 0 && this.itemList != null && this.current < this.itemList.size()) {
            ItemStack itemStack = this.itemList.get(this.current);
            MutableInt toCollect = new MutableInt(0);
            this.stacks.forEach(bigItemStack -> {
                if (ItemStackUtil.isSame(itemStack, bigItemStack.stack, this.matchNbt)) {
                    toCollect.add(bigItemStack.count);
                }
            });
            if (toCollect.getValue() > itemStack.m_41741_()) {
                toCollect.setValue(itemStack.m_41741_());
            }
            if (this.isEnoughToAddItem(itemStack.m_255036_(toCollect.getValue().intValue()))) {
                if (toCollect.intValue() > 0) {
                    if (toCollect.intValue() > itemStack.m_41613_()) {
                        toCollect.setValue(itemStack.m_41613_());
                    }
                    this.be.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, new PackageOrder(List.of(new BigItemStack(itemStack, toCollect.getValue().intValue()))), null, this.targetPackageName);
                    ItemStackUtil.addToList(this.sentRequests, itemStack.m_255036_(toCollect.getValue().intValue()), this.matchNbt);
                    this.itemList.get(this.current).m_41774_(toCollect.getValue().intValue());
                }
                if (this.itemList.get(this.current).m_41619_() || toCollect.getValue() == 0) {
                    ++this.current;
                }
            } else {
                this.current = this.itemList.size();
            }
            if (this.current >= this.itemList.size()) {
                this.timeoutAt = this.maid.f_19797_ + 600;
            }
        }
        if (this.waitCircle % 30 == 0) {
            this.rescanItemHandler();
        }
        this.dealPackagesForChain(callback);
        this.itemHandlers.forEach(itemHandler -> this.watchItemHandler((IItemHandler)itemHandler, callback));
        List<ItemStack> list = this.maid.m_9236_().m_142425_(EntityTypeTest.m_156916_(PackageEntity.class), this.maid.m_20191_().m_82377_(7.0, 7.0, 7.0), e -> PackageItem.getAddress((ItemStack)e.box).equals(this.targetPackageName)).stream().map(e -> {
            e.m_142687_(Entity.RemovalReason.DISCARDED);
            return e.box;
        }).toList();
        if (!list.isEmpty()) {
            this.dealTakenPackages(callback, list);
        }
    }

    @Override
    public void finish() {
        this.clearCurrentChain();
    }

    @Override
    public void reset() {
        this.clearCurrentChain();
        this.reselectChain();
        this.timeoutAt = Integer.MAX_VALUE;
        this.current = 0;
        this.sentRequests.clear();
    }

    private void watchItemHandler(IItemHandler itemHandler, Function<ItemStack, ItemStack> callback) {
        ArrayList<ItemStack> takenPackages = new ArrayList<ItemStack>();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            ItemStack itemStack;
            @NotNull ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.m_41619_() || !PackageItem.isPackage((ItemStack)stack) || !PackageItem.getAddress((ItemStack)stack).equals(this.targetPackageName) || (itemStack = itemHandler.extractItem(i, 1, false)).m_41619_()) continue;
            takenPackages.add(itemStack);
        }
        if (takenPackages.isEmpty()) {
            return;
        }
        this.maid.m_6674_(InteractionHand.MAIN_HAND);
        this.dealTakenPackages(callback, takenPackages);
    }

    private void dealTakenPackages(Function<ItemStack, ItemStack> callback, List<ItemStack> takenPackages) {
        takenPackages.forEach(itemStack -> {
            ItemStackHandler t = PackageItem.getContents((ItemStack)itemStack);
            for (int i = 0; i < t.getSlots(); ++i) {
                ItemStack stack = t.getStackInSlot(i);
                ItemStackUtil.removeIsMatchInList(this.sentRequests, stack.m_41777_(), this.matchNbt);
                ItemStack rest = (ItemStack)callback.apply(stack);
                if (rest.m_41619_()) continue;
                InvUtil.throwItem(this.maid, rest);
            }
        });
    }

    public void dealPackagesForChain(Function<ItemStack, ItemStack> callback) {
        if (this.chainConveyorBlockEntity == null) {
            return;
        }
        if (!this.chainConveyorBlockEntity.connections.contains(this.connection) || this.chainConveyorBlockEntity.reversed != this.reversed) {
            this.clearCurrentChain();
            this.reselectChain();
            return;
        }
        this.updateChainRoute();
        ArrayList<ItemStack> takenPackages = new ArrayList<ItemStack>();
        this.chainConveyorBlockEntity.getTravellingPackages().forEach((conn, packages) -> packages.removeIf(packageBox -> {
            if (!PackageItem.getAddress((ItemStack)packageBox.item).equals(this.targetPackageName)) {
                return false;
            }
            if (packageBox.worldPosition == null || packageBox.worldPosition.m_82554_(this.maid.m_20182_()) > 7.0) {
                return false;
            }
            takenPackages.add(packageBox.item);
            this.maid.m_6674_(InteractionHand.MAIN_HAND);
            return true;
        }));
        this.chainConveyorBlockEntity.getLoopingPackages().removeIf(packageBox -> {
            if (!PackageItem.getAddress((ItemStack)packageBox.item).equals(this.targetPackageName)) {
                return false;
            }
            if (packageBox.worldPosition.m_82554_(this.maid.m_20182_()) > 8.0) {
                return false;
            }
            this.maid.m_6674_(InteractionHand.MAIN_HAND);
            takenPackages.add(packageBox.item);
            return true;
        });
        if (!takenPackages.isEmpty()) {
            this.chainConveyorBlockEntity.sendData();
        }
        this.dealTakenPackages(callback, takenPackages);
    }

    @Override
    public void setExtract(List<ItemStack> itemList, boolean matchNbt) {
        this.itemList = new ArrayList<ItemStack>(itemList.stream().map(ItemStack::m_41777_).toList());
        this.matchNbt = matchNbt;
        this.current = 0;
    }

    @Override
    public void setExtractByExisting(Predicate<ItemStack> predicate) {
        if (this.stacks != null) {
            this.setExtract(this.stacks.stream().map(s -> s.stack).filter(predicate).toList(), true);
        } else {
            this.setExtract(List.of(), true);
        }
    }

    private Pair<Double, Double> getDistanceToBeConnectionAndPosition(BlockPos pos, BlockPos connection, Vec3 origin) {
        Vec3 chainP1 = pos.m_252807_();
        Vec3 chainDir = Vec3.m_82528_((Vec3i)connection);
        double onChainLen = chainDir.m_82526_(origin.m_82546_(chainP1));
        if (onChainLen < 0.0) {
            return new Pair((Object)origin.m_82554_(chainP1), (Object)0.0);
        }
        if (onChainLen > chainDir.m_82553_()) {
            return new Pair((Object)origin.m_82554_(Vec3.m_82528_((Vec3i)pos.m_121955_((Vec3i)connection))), (Object)chainDir.m_82553_());
        }
        return new Pair((Object)Math.sqrt(origin.m_82557_(chainP1) + Math.pow(onChainLen, 2.0)), (Object)onChainLen);
    }
}

