/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.tacz;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.menu.base.ImageAsset;
import studio.fantasyit.maid_storage_manager.menu.container.RollingTextWidget;
import studio.fantasyit.maid_storage_manager.menu.container.SelectButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftScreen;
import studio.fantasyit.maid_storage_manager.menu.craft.tacz.TaczCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
@IPNIgnore
public class TaczCraftScreen
extends AbstractCraftScreen<TaczCraftMenu> {
    private static final ResourceLocation background = new ResourceLocation("maid_storage_manager", "textures/gui/craft/type/tacz.png");
    private static final ImageAsset BTN_SELECTED = new ImageAsset(background, 177, 25, 66, 16);
    private static final ImageAsset BTN_NORMAL = new ImageAsset(background, 177, 43, 66, 16);
    private static final ImageAsset BTN_BACK_NORMAL = new ImageAsset(background, 176, 60, 68, 18);
    private static final ImageAsset BTN_BACK_HOVER = new ImageAsset(background, 176, 78, 68, 18);
    private static final ImageAsset BTN_PAGEDOWN = new ImageAsset(background, 176, 0, 68, 6);
    private static final ImageAsset BTN_PAGEDOWN_HOVER = new ImageAsset(background, 176, 6, 68, 6);
    private static final ImageAsset BTN_PAGEUP = new ImageAsset(background, 176, 12, 68, 6);
    private static final ImageAsset BTN_PAGEUP_HOVER = new ImageAsset(background, 176, 18, 68, 6);
    int selected = -1;
    int page = 0;
    int maxPage = 0;
    protected List<SelectButtonWidget<Boolean>> buttons = new ArrayList<SelectButtonWidget<Boolean>>();
    protected List<RollingTextWidget> rollingTexts = new ArrayList<RollingTextWidget>();
    SelectButtonWidget<Boolean> pageDownBtn;
    SelectButtonWidget<Boolean> pageUpBtn;
    protected List<Integer> pageNo = new ArrayList<Integer>();
    private List<Pair<ItemStack, String>> taczRecipes = new ArrayList<Pair<ItemStack, String>>();
    private ResourceLocation blockId;

    public TaczCraftScreen(TaczCraftMenu p_97741_, Inventory p_97742_, Component p_97743_) {
        super(p_97741_, p_97742_, p_97743_, background);
    }

    @Override
    protected void m_7856_() {
        ((TaczCraftMenu)this.m_6262_()).setScreenListener(this);
        this.initRecipe();
        super.m_7856_();
        String recipeId = ((TaczCraftMenu)this.f_97732_).getRecipeId();
        for (int i = 0; i < this.taczRecipes.size(); ++i) {
            if (!((String)this.taczRecipes.get(i).getB()).equals(recipeId)) continue;
            this.selected = i;
            this.page = this.pageNo.get(i);
            this.updateButtons();
            break;
        }
    }

    private void initRecipe() {
        this.taczRecipes.clear();
        this.blockId = ((TaczCraftMenu)this.f_97732_).getBlockId();
        ((TaczCraftMenu)this.f_97732_).getAllRecipes(this.taczRecipes);
    }

    @Override
    protected void addButtons() {
        this.buttons.clear();
        this.pageNo.clear();
        this.rollingTexts.forEach(rollingText -> {
            rollingText.f_93624_ = false;
        });
        this.rollingTexts.clear();
        int y = 38;
        int height = 130;
        int currentPage = 0;
        for (int i = 0; i < this.taczRecipes.size(); ++i) {
            Pair<ItemStack, String> taczRecipe = this.taczRecipes.get(i);
            int finalI = i;
            SelectButtonWidget btn = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Boolean>(31, y + 1, value -> {
                boolean toValue;
                boolean bl = toValue = this.selected == finalI;
                if (value != null) {
                    toValue = !toValue;
                    this.selected = toValue ? finalI : -1;
                    CompoundTag tag = new CompoundTag();
                    tag.m_128359_("block_id", this.blockId.toString());
                    tag.m_128359_("recipe_id", toValue ? (String)taczRecipe.getB() : "");
                    this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.EXTRA, 0, 0, tag));
                    this.updateButtons();
                }
                return new SelectButtonWidget.Option<Boolean>(toValue, toValue ? BTN_SELECTED : BTN_NORMAL, toValue ? BTN_SELECTED : BTN_NORMAL, (Component)Component.m_237119_());
            }, this));
            RollingTextWidget text = (RollingTextWidget)this.m_169394_((Renderable)new RollingTextWidget(this.getGuiLeft() + 50, this.getGuiTop() + y, 48, 18, ((ItemStack)taczRecipe.getA()).m_41786_()));
            this.rollingTexts.add(text);
            this.buttons.add(btn);
            this.pageNo.add(currentPage);
            if ((y += TaczCraftScreen.BTN_BACK_NORMAL.h - 1) + TaczCraftScreen.BTN_BACK_NORMAL.h - 1 <= height) continue;
            y = 38;
            ++currentPage;
        }
        if (y == 38) {
            --currentPage;
        }
        this.maxPage = currentPage;
        this.pageDownBtn = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Boolean>(30, 127, v -> {
            if (v != null) {
                ++this.page;
                if (this.page > this.maxPage) {
                    this.page = this.maxPage;
                }
                this.updateButtons();
            }
            return new SelectButtonWidget.Option<Boolean>(true, BTN_PAGEDOWN, BTN_PAGEDOWN_HOVER, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.page_down"));
        }, this));
        this.pageUpBtn = (SelectButtonWidget)this.m_142416_((GuiEventListener)new SelectButtonWidget<Boolean>(30, 29, v -> {
            if (v != null) {
                --this.page;
                if (this.page < 0) {
                    this.page = 0;
                }
                this.updateButtons();
            }
            return new SelectButtonWidget.Option<Boolean>(true, BTN_PAGEUP, BTN_PAGEUP_HOVER, (Component)Component.m_237115_((String)"gui.maid_storage_manager.craft_guide.common.page_up"));
        }, this));
        this.updateButtons();
    }

    protected void updateButtons() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).setVisible(this.page == this.pageNo.get(i));
            this.buttons.get(i).setOption(null);
            this.rollingTexts.get((int)i).f_93624_ = this.page == this.pageNo.get(i);
        }
        this.pageUpBtn.setVisible(this.page != 0);
        this.pageDownBtn.setVisible(this.page != this.maxPage);
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        super.m_7286_(guiGraphics, p_97788_, p_97789_, p_97790_);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        for (SelectButtonWidget<Boolean> booleanSelectButtonWidget : this.buttons) {
            if (!booleanSelectButtonWidget.isVisible()) continue;
            BTN_BACK_NORMAL.blit(guiGraphics, booleanSelectButtonWidget.m_252754_() - 1, booleanSelectButtonWidget.m_252907_() - 1);
        }
        for (SelectButtonWidget<Boolean> button : this.buttons) {
            if (!button.isVisible() || !button.m_274382_()) continue;
            BTN_BACK_HOVER.blit(guiGraphics, button.m_252754_() - 1, button.m_252907_() - 1);
        }
        if (!((TaczCraftMenu)this.f_97732_).stepDataContainer.m_8020_(10).m_41619_()) {
            guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.maid_storage_manager.craft_guide.tacz.amount", (Object[])new Object[]{((TaczCraftMenu)this.f_97732_).stepDataContainer.getCount(10)}), relX + 113, relY + 127, 0xFFFFFF);
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int p_283661_, int p_281248_, float p_281886_) {
        super.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        for (int i = 0; i < this.taczRecipes.size(); ++i) {
            if (this.pageNo.get(i) != this.page) continue;
            graphics.m_280480_((ItemStack)this.taczRecipes.get(i).getA(), this.buttons.get(i).m_252754_(), this.buttons.get(i).m_252907_());
        }
    }

    @Override
    public boolean m_6050_(double _x, double _y, double p_94688_) {
        double x = _x - (double)this.getGuiLeft();
        double y = _y - (double)this.getGuiTop();
        if (x >= 30.0 && y >= 38.0 && x <= 97.0 && y <= 128.0) {
            if (p_94688_ < 0.0) {
                this.pageDownBtn.m_5716_(x, y);
            } else if (p_94688_ > 0.0) {
                this.pageUpBtn.m_5716_(x, y);
            }
            return true;
        }
        return super.m_6050_(_x, _y, p_94688_);
    }

    @Override
    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        super.m_280072_(graphics, x, y);
        for (int i = 0; i < this.taczRecipes.size(); ++i) {
            if (!this.buttons.get(i).isVisible() || !this.buttons.get(i).m_274382_()) continue;
            graphics.m_280153_(this.f_96547_, (ItemStack)this.taczRecipes.get(i).getA(), x, y);
        }
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        if (type == CraftGuideGuiPacket.Type.EXTRA) {
            String recipeId = ((TaczCraftMenu)this.f_97732_).getRecipeId();
            for (int i = 0; i < this.taczRecipes.size(); ++i) {
                if (!((String)this.taczRecipes.get(i).getB()).equals(recipeId)) continue;
                this.selected = i;
                this.page = this.pageNo.get(i);
                this.updateButtons();
                break;
            }
        }
    }
}

