/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.menu.container.FilterContainer;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;

public class CommonStepDataContainer
extends FilterContainer
implements ISaveFilter {
    public final CraftGuideStepData step;
    CraftAction actionType;
    public boolean optional;
    public boolean matchTag;
    public int inputCount = 0;
    public int padCount = 0;
    public int outputCount = 0;

    public CommonStepDataContainer(CraftGuideStepData step, AbstractContainerMenu menu) {
        super(3, menu);
        this.step = step;
        this.actionType = step.actionType;
        this.inputCount = step.actionType.inputCount();
        this.outputCount = step.actionType.outputCount();
        this.padCount = this.inputCount + this.outputCount < 3 ? 3 - this.inputCount - this.outputCount : 0;
        if (this.inputCount + this.outputCount > 3) {
            this.outputCount = 3 - this.inputCount;
        }
        if (this.outputCount < 0) {
            this.outputCount = 0;
            this.inputCount = 3;
        }
        for (int i = 0; i < this.inputCount; ++i) {
            this.setItemNoTrigger(i, step.getInput().get(i));
            this.setCount(i, step.getInput().get(i).m_41613_());
        }
        int inputOffset = this.inputCount == 0 ? 0 : Math.max(this.inputCount, 2);
        for (int i = 0; i < this.outputCount; ++i) {
            this.setItemNoTrigger(inputOffset + i, step.getOutput().get(i));
            this.setCount(inputOffset + i, step.getOutput().get(i).m_41613_());
        }
        this.optional = step.isOptional();
    }

    @Override
    public int m_6643_() {
        return this.actionType.inputCount() + this.actionType.outputCount() + this.padCount;
    }

    public void setAction(ResourceLocation action) {
        int currentInputs = this.inputCount;
        int currentOutputs = this.outputCount;
        this.step.setAction(action);
        this.actionType = this.step.actionType;
        this.inputCount = this.step.actionType.inputCount();
        this.outputCount = this.step.actionType.outputCount();
        this.padCount = this.inputCount + this.outputCount < 3 ? 3 - this.inputCount - this.outputCount : 0;
        if (this.inputCount + this.outputCount > 3) {
            this.outputCount = 3 - this.inputCount;
        }
        if (this.outputCount < 0) {
            this.outputCount = 0;
            this.inputCount = 3;
        }
    }

    @Override
    public void save() {
        if (this.inputCount != 0) {
            for (int i = 0; i < this.inputCount; ++i) {
                int count = this.count[i].getValue();
                this.step.setInput(i, this.m_8020_(i).m_255036_(count));
            }
        } else {
            this.step.clearInput();
        }
        int inputOffset = this.inputCount + this.padCount;
        if (this.outputCount != 0) {
            for (int i = 0; i < this.outputCount; ++i) {
                int count = this.count[inputOffset + i].getValue();
                this.step.setOutput(i, this.m_8020_(inputOffset + i).m_255036_(count));
            }
        } else {
            this.step.clearOutput();
        }
        this.step.optional = this.optional;
    }
}

