/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.common;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.CraftManager;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.menu.base.ImageAsset;
import studio.fantasyit.maid_storage_manager.menu.container.SelectButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.common.CommonCraftAssets;
import studio.fantasyit.maid_storage_manager.registry.SoundEventRegistry;

public class CommonActionSelectionWidget
extends AbstractWidget {
    private static final ResourceLocation background = new ResourceLocation("maid_storage_manager", "textures/gui/craft/type/common.png");
    private static final ImageAsset BUTTON_NORMAL = new ImageAsset(background, 176, 214, 56, 15);
    private static final ImageAsset BUTTON_HOVER = new ImageAsset(background, 176, 229, 56, 15);
    private static final ImageAsset ARROW = new ImageAsset(background, 219, 120, 11, 9);
    private static final ImageAsset BACK = new ImageAsset(background, 176, 131, 70, 83);
    private static final int GAP_SIZE = 1;
    private static final int DIFF_X = 6;
    private static final int DIFF_Y = 13;
    List<SelectButtonWidget<CraftAction>> buttons = new ArrayList<SelectButtonWidget<CraftAction>>();
    final List<CraftAction> actions = CraftManager.getInstance().getCommonActions();
    int currentId = 0;
    boolean visible = false;
    Consumer<CraftAction> callback = null;
    AbstractContainerScreen<?> screen;
    long lastRollTick = 0L;

    public CommonActionSelectionWidget(int p_93629_, int p_93630_, AbstractContainerScreen<?> screen) {
        super(p_93629_, p_93630_, CommonActionSelectionWidget.BACK.w, CommonActionSelectionWidget.BACK.h, (Component)Component.m_237113_((String)""));
        for (int i = 0; i < 4; ++i) {
            this.buttons.add(new SelectButtonWidget<CraftAction>(0, 0, this.getIdForButtonI(i), screen));
        }
        this.screen = screen;
    }

    public Function<@Nullable CraftAction, SelectButtonWidget.Option<CraftAction>> getIdForButtonI(int i) {
        return ca -> {
            if (ca == null) {
                ca = this.actions.get((this.currentId + i) % this.actions.size());
            } else {
                this.setSelectedAction((CraftAction)ca);
                if (this.callback != null) {
                    this.callback.accept(this.getSelected());
                }
                this.hide();
            }
            return new SelectButtonWidget.Option<CraftAction>((CraftAction)ca, BUTTON_NORMAL, BUTTON_HOVER, CommonCraftAssets.translationForAction(ca.type()));
        };
    }

    public void setSelectedAction(CraftAction action) {
        for (int i = 0; i < this.actions.size(); ++i) {
            if (!this.actions.get(i).type().equals((Object)action.type())) continue;
            this.currentId = i;
            this.buttons.forEach(b -> b.setOption(null));
            return;
        }
    }

    public void expandFrom(AbstractWidget widget) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.buttons.get(i).m_252865_(widget.m_252754_() - this.screen.getGuiLeft());
            this.buttons.get(i).m_253211_(widget.m_252907_() - this.screen.getGuiTop() + (CommonActionSelectionWidget.BUTTON_NORMAL.h + 1) * i);
        }
        this.m_252865_(widget.m_252754_() - 6);
        this.m_253211_(widget.m_252907_() - 13);
        this.visible = true;
        this.f_93623_ = true;
    }

    public void hide() {
        this.visible = false;
        this.f_93623_ = false;
    }

    public void setCallback(Consumer<CraftAction> callback) {
        this.callback = callback;
    }

    public CraftAction getSelected() {
        return this.actions.get(this.currentId);
    }

    protected void m_87963_(GuiGraphics guiGraphics, int x, int y, float pt) {
        if (!this.visible) {
            return;
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        int left = this.m_252754_();
        int top = this.m_252907_();
        BACK.blit(guiGraphics, left, top);
        for (SelectButtonWidget<CraftAction> button : this.buttons) {
            button.m_88315_(guiGraphics, x, y, pt);
            CommonCraftAssets.imageForAction(button.getData().type()).blit(guiGraphics, button.m_252754_() + 2, button.m_252907_() + 2);
            RenderSystem.disableDepthTest();
            guiGraphics.m_280430_(this.screen.getMinecraft().f_91062_, CommonCraftAssets.translationForAction(button.getData().type()), button.m_252754_() + 18, button.m_252907_() + 3, -1);
            RenderSystem.disableDepthTest();
        }
        ARROW.blit(guiGraphics, left - 4, top + 13 + CommonActionSelectionWidget.BUTTON_HOVER.h / 2 - 4);
        guiGraphics.m_280168_().m_85849_();
    }

    public void m_94757_(double x, double y) {
        this.buttons.forEach(b -> b.m_94757_(x, y));
    }

    public boolean m_6050_(double p_94734_, double p_94735_, double p_94736_) {
        long currentTime = System.currentTimeMillis();
        if (this.lastRollTick + 50L > currentTime) {
            return false;
        }
        this.lastRollTick = currentTime;
        this.currentId = p_94736_ < 0.0 ? ++this.currentId : --this.currentId;
        if (this.currentId < 0) {
            this.currentId = this.actions.size() - 1;
        }
        if (this.currentId >= this.actions.size()) {
            this.currentId = 0;
        }
        if (this.callback != null) {
            this.callback.accept(this.actions.get(this.currentId));
        }
        this.buttons.forEach(b -> b.setOption(null));
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundEventRegistry.CRAFT_ACTION_ROLL.get()), (float)1.0f));
        return true;
    }

    public boolean m_5953_(double p_93672_, double p_93673_) {
        return super.m_5953_(p_93672_, p_93673_);
    }

    public boolean m_6375_(double x, double y, int p_93643_) {
        if (this.visible && this.f_93623_) {
            for (SelectButtonWidget<CraftAction> button : this.buttons) {
                if (!button.m_6375_(x, y, p_93643_)) continue;
                return true;
            }
        }
        return false;
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }
}

