/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.base;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.base.AbstractFilterScreen;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.SelectButtonWidget;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.menu.craft.base.ICraftGuiPacketReceiver;
import studio.fantasyit.maid_storage_manager.menu.craft.base.StepDataContainer;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
@IPNIgnore
public abstract class AbstractCraftScreen<T extends AbstractCraftMenu>
extends AbstractFilterScreen<T>
implements ICraftGuiPacketReceiver {
    protected boolean enableScroll = false;
    protected final ResourceLocation iBackground;

    public AbstractCraftScreen(T p_97741_, Inventory p_97742_, Component p_97743_, ResourceLocation background) {
        this(p_97741_, p_97742_, p_97743_, background, false);
    }

    public AbstractCraftScreen(T p_97741_, Inventory p_97742_, Component p_97743_, ResourceLocation background, boolean enableScroll) {
        super(p_97741_, p_97742_, p_97743_);
        this.enableScroll = enableScroll;
        this.iBackground = background;
        this.f_97726_ = 176;
        this.f_97727_ = 245;
        this.f_97731_ = this.f_97727_ - 94;
        this.f_97730_ = 8;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButtons();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float p_97788_, int p_97789_, int p_97790_) {
        this.m_280273_(guiGraphics);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280398_(this.iBackground, relX, relY, 0, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    protected void addButtons() {
    }

    protected void sendAndTriggerLocalPacket(CraftGuideGuiPacket packet) {
        Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)packet);
        ((AbstractCraftMenu)this.f_97732_).handleGuiPacket(packet.type, packet.key, packet.value, packet.data);
        this.handleGuiPacket(packet.type, packet.key, packet.value, packet.data);
    }

    protected void m_280072_(@NotNull GuiGraphics graphics, int x, int y) {
        if (((AbstractCraftMenu)this.f_97732_).m_142621_().m_41619_()) {
            int inGuiX = x - this.getGuiLeft();
            int inGuiY = y - this.getGuiTop();
            for (Slot slot : ((AbstractCraftMenu)this.m_6262_()).f_38839_) {
                FilterSlot filterSlot;
                if (slot.f_40220_ > inGuiX || slot.f_40220_ + 16 < inGuiX || slot.f_40221_ > inGuiY || slot.f_40221_ + 16 < inGuiY || !(slot instanceof FilterSlot) || !(filterSlot = (FilterSlot)slot).m_6659_()) continue;
                if (!filterSlot.m_7993_().m_41619_()) {
                    graphics.m_280153_(this.f_96547_, filterSlot.m_7993_(), x, y);
                }
                return;
            }
            this.m_6702_().forEach(renderable -> {
                SelectButtonWidget buttonWidget;
                if (renderable.m_5953_((double)x, (double)y) && renderable instanceof SelectButtonWidget && (buttonWidget = (SelectButtonWidget)((Object)renderable)).m_142518_()) {
                    graphics.m_280557_(this.f_96547_, buttonWidget.getTooltipComponent(), x, y);
                }
            });
        }
        super.m_280072_(graphics, x, y);
    }

    public void m_88315_(GuiGraphics graphics, int p_283661_, int p_281248_, float p_281886_) {
        super.m_88315_(graphics, p_283661_, p_281248_, p_281886_);
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 2000.0f);
        this.m_280072_(graphics, p_283661_, p_281248_);
        graphics.m_280168_().m_85849_();
        RenderSystem.disableDepthTest();
        this.renderNumberLabel(graphics);
        RenderSystem.enableDepthTest();
    }

    private void renderNumberLabel(@NotNull GuiGraphics graphics) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 1000.0f);
        int relX = (this.f_96543_ - this.f_97726_) / 2;
        int relY = (this.f_96544_ - this.f_97727_) / 2;
        for (Slot slot : ((AbstractCraftMenu)this.m_6262_()).f_38839_) {
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            Container container = filterSlot.f_40218_;
            if (!(container instanceof StepDataContainer)) continue;
            StepDataContainer sdc = (StepDataContainer)container;
            if (!filterSlot.m_6659_() || !filterSlot.m_6657_()) continue;
            int count = sdc.getCount(filterSlot.m_150661_());
            String text = String.valueOf(count);
            if (count == -1) {
                text = "*";
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(0.6f, 0.6f, 1.0f);
            int n = (int)(((double)(relX + filterSlot.f_40220_ + 16) - (double)this.f_96547_.m_92895_(text) * 0.6) / (double)0.6f);
            double d = relY + filterSlot.f_40221_ + 16;
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280488_(this.f_96547_, text, n, (int)((d - 9.0 * 0.6) / (double)0.6f), 0xFFFFFF);
            graphics.m_280168_().m_85849_();
        }
        graphics.m_280168_().m_85849_();
    }

    @Override
    public void accept(FilterSlot slot, ItemStack item) {
        if (!slot.m_6659_() || slot.readonly) {
            return;
        }
        slot.m_5852_(item);
        this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.SET_ITEM, slot.f_40219_, 0, ItemStackUtil.saveStack(item)));
    }

    @Override
    public List<FilterSlot> getSlots() {
        return ((AbstractCraftMenu)this.f_97732_).f_38839_.stream().filter(slot -> {
            if (!(slot instanceof FilterSlot)) return false;
            FilterSlot fs = (FilterSlot)((Object)slot);
            if (fs.readonly) return false;
            return true;
        }).map(slot -> (FilterSlot)((Object)slot)).toList();
    }

    public boolean m_6050_(double p_94686_, double p_94687_, double p_94688_) {
        if (!this.enableScroll) {
            return false;
        }
        @Nullable Slot slot = this.getSlotUnderMouse();
        if (slot instanceof FilterSlot) {
            FilterSlot filterSlot = (FilterSlot)slot;
            Container container = filterSlot.f_40218_;
            if (container instanceof StepDataContainer) {
                StepDataContainer sdc = (StepDataContainer)container;
                if (!filterSlot.readonly) {
                    MutableInt count = new MutableInt(sdc.getCount(filterSlot.m_150661_()));
                    int dv = (int)(Math.abs(p_94688_) / p_94688_);
                    if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)340)) {
                        dv *= 10;
                    }
                    if (dv > 0) {
                        if (count.addAndGet(dv) == 0) {
                            count.addAndGet(1);
                        }
                    } else if (count.addAndGet(dv) <= 0) {
                        count.setValue(1);
                    }
                    this.sendAndTriggerLocalPacket(new CraftGuideGuiPacket(CraftGuideGuiPacket.Type.COUNT, filterSlot.m_150661_(), count.getValue()));
                }
            }
        }
        return super.m_6050_(p_94686_, p_94687_, p_94688_);
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
    }
}

