/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.data;

import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public class StorageManagerConfigData
implements TaskDataKey<Data> {
    public static TaskDataKey<Data> KEY = null;
    public static final ResourceLocation LOCATION = new ResourceLocation("maid_storage_manager", "storage_manager_config");

    public ResourceLocation getKey() {
        return LOCATION;
    }

    public CompoundTag writeSaveData(Data data) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("memoryAssistant", data.memoryAssistant().name());
        tag.m_128359_("suppressStrategy", data.suppressStrategy().name());
        tag.m_128379_("noSortPlacement", data.noSortPlacement());
        tag.m_128379_("coWorkMode", data.coWorkMode());
        tag.m_128379_("allowSeekWorkMeal", data.allowSeekWorkMeal());
        tag.m_128379_("useMemorizedCraftGuide", data.useMemorizedCraftGuide());
        tag.m_128405_("maxParallel", data.maxParallel());
        tag.m_128405_("maxCraftingLayerRepeatCount", data.maxCraftingLayerRepeatCount());
        return tag;
    }

    public Data readSaveData(CompoundTag compound) {
        MemoryAssistant memoryAssistant = MemoryAssistant.valueOf(compound.m_128461_("memoryAssistant"));
        SuppressStrategy suppressStrategy = compound.m_128441_("suppressStrategy") ? SuppressStrategy.valueOf(compound.m_128461_("suppressStrategy")) : SuppressStrategy.AFTER_ALL;
        boolean noSortPlacement = compound.m_128471_("noSortPlacement");
        boolean coWorkMode = compound.m_128471_("coWorkMode");
        boolean allowSeekWorkMeal = compound.m_128471_("allowSeekWorkMeal");
        boolean useMemorizedCraftGuide = compound.m_128471_("useMemorizedCraftGuide");
        int maxParallel = compound.m_128441_("maxParallel") ? compound.m_128451_("maxParallel") : 5;
        boolean alwaysSingleCrafting = compound.m_128471_("alwaysSingleCrafting");
        int maxCraftingLayerRepeatCount = compound.m_128441_("maxCraftingLayerRepeatCount") ? compound.m_128451_("maxCraftingLayerRepeatCount") : (alwaysSingleCrafting ? 1 : 8);
        return new Data(memoryAssistant, noSortPlacement, coWorkMode, suppressStrategy, allowSeekWorkMeal, useMemorizedCraftGuide, maxParallel, maxCraftingLayerRepeatCount);
    }

    public static String getTranslationKey(MemoryAssistant memoryAssistant) {
        return "gui.maid_storage_manager.config.memory_assistant." + (switch (memoryAssistant) {
            default -> throw new IncompatibleClassChangeError();
            case MemoryAssistant.MEMORY_ONLY -> "memory_only";
            case MemoryAssistant.MEMORY_FIRST -> "memory_first";
            case MemoryAssistant.ALWAYS_SCAN -> "always_scan";
        });
    }

    public static String getTranslationKey(SuppressStrategy memoryAssistant) {
        return "gui.maid_storage_manager.config.fast_sort." + (switch (memoryAssistant) {
            default -> throw new IncompatibleClassChangeError();
            case SuppressStrategy.AFTER_ALL -> "normal";
            case SuppressStrategy.AFTER_PRIORITY -> "filter";
            case SuppressStrategy.AFTER_EACH -> "all";
        });
    }

    public static String getTranslationKey(boolean enable) {
        return "gui.maid_storage_manager.config.bool." + (enable ? "enable" : "disable");
    }

    public static Data get(EntityMaid maid) {
        return (Data)maid.getOrCreateData(KEY, (Object)Data.getDefault());
    }

    public static final class Data {
        private boolean useMemorizedCraftGuide;
        private boolean coWorkMode;
        private MemoryAssistant memoryAssistant;
        private boolean noSortPlacement = false;
        private SuppressStrategy suppressStrategy = SuppressStrategy.AFTER_ALL;
        private boolean allowSeekWorkMeal = false;
        private int maxParallel;
        private int maxCraftingLayerRepeatCount;

        public Data(MemoryAssistant memoryAssistant, boolean noSortPlacement, boolean coWorkMode, SuppressStrategy suppressStrategy, boolean allowSeekWorkMeal, boolean useMemorizedCraftGuide, int maxParallel, int maxCraftingLayerRepeatCount) {
            this.memoryAssistant = memoryAssistant;
            this.noSortPlacement = noSortPlacement;
            this.coWorkMode = coWorkMode;
            this.suppressStrategy = suppressStrategy;
            this.allowSeekWorkMeal = allowSeekWorkMeal;
            this.useMemorizedCraftGuide = useMemorizedCraftGuide;
            this.maxParallel = maxParallel;
            this.maxCraftingLayerRepeatCount = maxCraftingLayerRepeatCount;
        }

        public static Data getDefault() {
            return new Data(MemoryAssistant.MEMORY_FIRST, false, false, SuppressStrategy.AFTER_EACH, false, false, 5, 8);
        }

        public MemoryAssistant memoryAssistant() {
            return this.memoryAssistant;
        }

        public boolean noSortPlacement() {
            return this.noSortPlacement;
        }

        public void memoryAssistant(MemoryAssistant memoryAssistant) {
            this.memoryAssistant = memoryAssistant;
        }

        public void noSortPlacement(boolean noSortPlacement) {
            this.noSortPlacement = noSortPlacement;
        }

        public boolean coWorkMode() {
            return this.coWorkMode;
        }

        public void coWorkMode(boolean coWorkMode) {
            this.coWorkMode = coWorkMode;
        }

        public SuppressStrategy suppressStrategy() {
            return this.suppressStrategy;
        }

        public void suppressStrategy(SuppressStrategy suppressStrategy) {
            this.suppressStrategy = suppressStrategy;
        }

        public boolean allowSeekWorkMeal() {
            return this.allowSeekWorkMeal;
        }

        public void allowSeekWorkMeal(boolean allowSeekWorkMeal) {
            this.allowSeekWorkMeal = allowSeekWorkMeal;
        }

        public boolean useMemorizedCraftGuide() {
            return this.useMemorizedCraftGuide;
        }

        public void useMemorizedCraftGuide(boolean useMemorizedCraftGuide) {
            this.useMemorizedCraftGuide = useMemorizedCraftGuide;
        }

        public int maxParallel() {
            return this.maxParallel;
        }

        public void maxParallel(int maxParallel) {
            this.maxParallel = Math.max(0, Math.min(10, maxParallel));
        }

        public int maxCraftingLayerRepeatCount() {
            return this.maxCraftingLayerRepeatCount;
        }

        public void maxCraftingLayerRepeatCount(int maxCraftingLayerRepeatCount) {
            if (maxCraftingLayerRepeatCount < 1) {
                maxCraftingLayerRepeatCount = 1;
            }
            for (int i = 1; i <= 64; i *= 2) {
                if (i == maxCraftingLayerRepeatCount) {
                    this.maxCraftingLayerRepeatCount = i;
                } else {
                    if (i <= maxCraftingLayerRepeatCount) continue;
                    this.maxCraftingLayerRepeatCount = i / 2;
                }
                return;
            }
            this.maxCraftingLayerRepeatCount = 32;
        }
    }

    public static enum MemoryAssistant {
        MEMORY_ONLY,
        MEMORY_FIRST,
        ALWAYS_SCAN;

    }

    public static enum SuppressStrategy {
        AFTER_EACH,
        AFTER_PRIORITY,
        AFTER_ALL;

    }
}

