/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.request.craft.gather;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayerChain;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.base.IMaidStorage;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageInteractContext;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;
import studio.fantasyit.maid_storage_manager.util.ViewedInventoryUtil;

public class RequestCraftGatherBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    IStorageContext context;
    private Target target;
    boolean changed = false;
    CraftLayerChain plan;
    CraftLayer layer;

    public RequestCraftGatherBehavior() {
        super(Map.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull EntityMaid maid) {
        if (MemoryUtil.getCurrentlyWorking(maid) != ScheduleBehavior.Schedule.REQUEST) {
            return false;
        }
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return false;
        }
        if (MemoryUtil.getCrafting(maid).isGatheringDispatched()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).hasTarget()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).hasPlan()) {
            return false;
        }
        if (!MemoryUtil.getCrafting(maid).plan().isCurrentGathering()) {
            return false;
        }
        return Conditions.hasReachedValidTargetOrReset(maid);
    }

    protected void start(@NotNull ServerLevel level, @NotNull EntityMaid maid, long gameTimeIn) {
        this.plan = MemoryUtil.getCrafting(maid).plan();
        this.layer = this.plan.getCurrentLayer();
        if (!MemoryUtil.getCrafting(maid).hasTarget()) {
            return;
        }
        this.target = MemoryUtil.getCrafting(maid).getTarget();
        IMaidStorage storage = MaidStorage.getInstance().getStorage(this.target.getType());
        if (storage == null) {
            return;
        }
        this.changed = false;
        this.context = storage.onStartCollect(level, maid, this.target);
        if (this.context != null) {
            this.context.start(maid, level, this.target);
        }
        this.plan.showCraftingProgress(maid);
        InvUtil.mergeSameStack((IItemHandler)maid.getAvailableInv(true));
    }

    protected boolean canStillUse(ServerLevel level, EntityMaid maid, long p_22547_) {
        if (!Conditions.takingRequestList(maid)) {
            return false;
        }
        if (!MemoryUtil.getRequestProgress(maid).isTryCrafting()) {
            return false;
        }
        if (MemoryUtil.getCrafting(maid).hasPlan() && this.layer.hasCollectedAll()) {
            return false;
        }
        return this.context != null && !this.context.isDone();
    }

    protected void tick(ServerLevel level, EntityMaid maid, long p_22553_) {
        if (!this.breath.breathTick(maid)) {
            return;
        }
        Function<ItemStack, ItemStack> taker = itemStack -> {
            int maxStore = InvUtil.maxCanPlace((IItemHandler)maid.getAvailableInv(false), itemStack);
            if (maxStore > 0) {
                ItemStack copy = itemStack.m_41777_();
                ItemStack toTake = this.layer.memorizeItem((ItemStack)itemStack, maxStore);
                if (toTake.m_41613_() > 0) {
                    this.changed = true;
                    this.plan.setStatusMessage(maid, (Component)Component.m_237110_((String)"chat_bubbles.maid_storage_manager.crafting_gathering_item", (Object[])new Object[]{itemStack.m_41786_(), String.valueOf(toTake.m_41613_())}));
                }
                copy.m_41774_(toTake.m_41613_());
                ViewedInventoryUtil.ambitiousRemoveItemAndSync(maid, level, this.target, itemStack, toTake.m_41613_());
                InvUtil.tryPlace((IItemHandler)maid.getAvailableInv(false), toTake);
                DebugData.invChange(DebugData.InvChange.IN, maid, toTake);
                return copy;
            }
            return itemStack;
        };
        IStorageContext iStorageContext = this.context;
        if (iStorageContext instanceof IStorageInteractContext) {
            IStorageInteractContext isic = (IStorageInteractContext)iStorageContext;
            isic.tick(taker);
        } else {
            iStorageContext = this.context;
            if (iStorageContext instanceof IStorageExtractableContext) {
                IStorageExtractableContext isec = (IStorageExtractableContext)iStorageContext;
                if (isec.hasTask()) {
                    isec.tick(taker);
                } else {
                    isec.setExtract(this.layer.getUnCollectedItems(), true);
                }
            }
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        super.m_6732_(level, (LivingEntity)maid, p_22550_);
        if (this.context != null) {
            this.context.finish();
            if (this.context.isDone() && !this.changed) {
                Target target = MemoryUtil.getCrafting(maid).getTarget();
                MemoryUtil.getCrafting(maid).addVisitedPos(target);
                StorageAccessUtil.checkNearByContainers((Level)level, target.getPos(), pos -> MemoryUtil.getCrafting(maid).addVisitedPos(target.sameType((BlockPos)pos, null)));
            }
        }
        MemoryUtil.getCrafting(maid).clearCheckItem();
        MemoryUtil.getCrafting(maid).clearTarget();
        MemoryUtil.clearTarget(maid);
        if (this.layer.hasCollectedAll()) {
            this.plan.finishGathering(maid);
        }
    }

    protected boolean m_7773_(long p_22537_) {
        return false;
    }
}

