/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior.place;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.behavior.ScheduleBehavior;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.BehaviorBreath;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class ThrowToPlaceBehavior
extends Behavior<EntityMaid> {
    BehaviorBreath breath = new BehaviorBreath();
    int count = 0;

    public ThrowToPlaceBehavior() {
        super(Map.of(), 1200);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel worldIn, @NotNull EntityMaid owner) {
        if (MemoryUtil.getCurrentlyWorking(owner) != ScheduleBehavior.Schedule.PLACE) {
            return false;
        }
        if (!super.m_6114_(worldIn, (LivingEntity)owner)) {
            return false;
        }
        return owner.m_20202_() != null;
    }

    protected boolean canStillUse(ServerLevel p_22545_, EntityMaid maid, long p_22547_) {
        if (Conditions.isWaitingForReturn(maid)) {
            return false;
        }
        if (this.count >= maid.getAvailableInv(false).getSlots()) {
            return !MemoryUtil.getViewedInventory(maid).getWaitingAdd().isEmpty();
        }
        return true;
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        this.count = 0;
        MemoryUtil.setWorking(maid, true);
    }

    protected void tick(ServerLevel p_22551_, EntityMaid maid, long p_22553_) {
        super.m_6725_(p_22551_, (LivingEntity)maid, p_22553_);
        if (!this.breath.breathTick(maid)) {
            return;
        }
        CombinedInvWrapper inv = maid.getAvailableInv(false);
        if (this.count >= inv.getSlots()) {
            return;
        }
        @NotNull ItemStack item = inv.extractItem(this.count, inv.getStackInSlot(this.count).m_41613_(), true);
        if (item.m_41619_()) {
            ++this.count;
            return;
        }
        if (item.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) && !RequestListItem.isIgnored(item)) {
            ++this.count;
            return;
        }
        item = inv.extractItem(this.count, inv.getStackInSlot(this.count).m_41613_(), false);
        InvUtil.throwItem(maid, item);
        MemoryUtil.getViewedInventory(maid).addWaitingAdd(item);
        ++this.count;
        if (this.count >= inv.getSlots()) {
            DebugData.sendDebug("[THROW]Start waiting", new Object[0]);
        }
    }

    protected void stop(ServerLevel level, EntityMaid maid, long p_22550_) {
        DebugData.sendDebug("[THROW]done", new Object[0]);
        MemoryUtil.getViewedInventory(maid).clearWaitingAdd();
        MemoryUtil.setWorking(maid, false);
        MemoryUtil.getCrafting(maid).tryStartIfHasPlan();
    }
}

