/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.behavior;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.maid.memory.LogisticsMemory;
import studio.fantasyit.maid_storage_manager.network.MaidDataSyncToClientPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.util.Conditions;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class ScheduleBehavior
extends Behavior<EntityMaid> {
    public ScheduleBehavior() {
        super(Map.of());
    }

    protected void start(ServerLevel level, EntityMaid maid, long p_22542_) {
        Schedule last;
        this.memoryTick(maid);
        Schedule next = last = MemoryUtil.getCurrentlyWorking(maid);
        Integer restartAt = MemoryUtil.getReturnToScheduleAt(maid);
        if (restartAt != null) {
            if (restartAt < level.m_7654_().m_129921_()) {
                MemoryUtil.clearReturnWorkSchedule(maid);
            }
            next = Schedule.NO_SCHEDULE;
        } else if (MemoryUtil.getViewedInventory(maid).isViewing()) {
            next = Schedule.VIEW;
        }
        if (MemoryUtil.getCrafting(maid).isGoPlacingBeforeCraft() && !MemoryUtil.getRequestProgress(maid).isReturning()) {
            if (Conditions.isNothingToPlace(maid)) {
                MemoryUtil.getCrafting(maid).setGoPlacingBeforeCraft(false);
                next = Schedule.NO_SCHEDULE;
            } else {
                next = Schedule.PLACE;
            }
        } else {
            next = Conditions.takingRequestList(maid) && (last == Schedule.REQUEST || InvUtil.hasAnyFree((IItemHandler)maid.getAvailableInv(false))) ? Schedule.REQUEST : (MemoryUtil.getLogistics(maid).shouldWork() ? (MemoryUtil.getLogistics(maid).getStage() == LogisticsMemory.Stage.FINISH && !Conditions.isNothingToPlace(maid) ? Schedule.PLACE : Schedule.LOGISTICS) : (MemoryUtil.getMeal(maid).isEating() ? Schedule.MEAL : (!Conditions.isNothingToPlace(maid) ? (maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.VISIBLE_PICKUP_ENTITIES.get()) && Conditions.shouldStopAndPickUpItems(maid) ? Schedule.NO_SCHEDULE : Schedule.PLACE) : (MemoryUtil.getResorting(maid).hasTarget() ? Schedule.RESORT : (MemoryUtil.getMeal(maid).hasTarget() ? Schedule.MEAL : (!MemoryUtil.getViewedInventory(maid).getMarkChanged().isEmpty() ? Schedule.VIEW : (MemoryUtil.isCoWorking(maid) ? Schedule.CO_WORK : (maid.m_6274_().m_21874_((MemoryModuleType)InitEntities.VISIBLE_PICKUP_ENTITIES.get()) ? Schedule.NO_SCHEDULE : Schedule.VIEW))))))));
        }
        if (last != next) {
            maid.m_6274_().m_21879_((MemoryModuleType)MemoryModuleRegistry.CURRENTLY_WORKING.get(), (Object)next);
            MemoryUtil.clearTarget(maid);
            DebugData.sendDebug("Schedule Change %s -> %s", last.toString(), next.toString());
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("id", next.ordinal());
            Network.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> maid), (Object)new MaidDataSyncToClientPacket(MaidDataSyncToClientPacket.Type.WORKING, maid.m_19879_(), nbt));
        }
    }

    protected void memoryTick(EntityMaid maid) {
        MemoryUtil.getMeal(maid).tick();
    }

    public static enum Schedule {
        NO_SCHEDULE,
        PLACE,
        VIEW,
        REQUEST,
        CO_WORK,
        LOGISTICS,
        RESORT,
        MEAL;

    }
}

