/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.debug.DebugData;
import studio.fantasyit.maid_storage_manager.items.MaidInteractItem;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.menu.ItemSelectorMenu;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class RequestListItem
extends MaidInteractItem
implements MenuProvider {
    public static final String TAG_ITEMS_DONE = "done";
    public static final String TAG_ITEMS_STORED = "stored";
    public static final String TAG_STORAGE = "storage";
    public static final String TAG_STORAGE_ENTITY = "storage_entity";
    public static final String TAG_ITEMS = "items";
    public static final String TAG_ITEMS_ITEM = "item";
    public static final String TAG_BLACKMODE = "blackmode";
    public static final String TAG_ITEMS_REQUESTED = "requested";
    public static final String TAG_ITEMS_COLLECTED = "collected";
    public static final String TAG_ITEMS_MISSING = "missing";
    public static final String TAG_ITEMS_FAIL_ADDITION = "fail";
    public static final String TAG_MATCH_TAG = "match_tag";
    public static final String TAG_UUID = "uuid";
    public static final String TAG_IGNORE_TASK = "ignore_task";
    public static final String TAG_COOLING_DOWN = "cooling";
    public static final String TAG_REPEAT_INTERVAL = "interval";
    public static final String TAG_STOCK_MODE = "stock_mode";
    public static final String TAG_HAS_CHECK_STOCK = "has_checked_stock";
    public static final String TAG_UNIT_SECOND = "unit_second";
    private static final String TAG_BLACKMODE_DONE = "blackmode_done";
    public static final String TAG_VIRTUAL = "virtual";
    public static final String TAG_VIRTUAL_SOURCE = "virtual_source";
    public static final String TAG_VIRTUAL_DATA = "virtual_data";

    public RequestListItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static boolean isIgnored(ItemStack mainHandItem) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!mainHandItem.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(mainHandItem.m_41783_());
        return tag.m_128471_(TAG_IGNORE_TASK);
    }

    public static int getRepeatInterval(ItemStack mainHandItem) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return 0;
        }
        if (!mainHandItem.m_41782_()) {
            return 0;
        }
        CompoundTag tag = Objects.requireNonNull(mainHandItem.m_41783_());
        return tag.m_128451_(TAG_REPEAT_INTERVAL);
    }

    public static void addItemStackCollected(ItemStack mainHandItem, ItemStack a, int count) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!mainHandItem.m_41782_()) {
            return;
        }
        CompoundTag tag = Objects.requireNonNull(mainHandItem.m_41783_());
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag tmp = items.m_128728_(i);
            ItemStack item = ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM));
            if (!ItemStackUtil.isSame(item, a, tag.m_128471_(TAG_MATCH_TAG))) continue;
            int newCount = tag.m_128451_(TAG_ITEMS_COLLECTED) + count;
            tmp.m_128405_(TAG_ITEMS_COLLECTED, newCount);
            if (newCount > tmp.m_128451_(TAG_ITEMS_REQUESTED) && tmp.m_128451_(TAG_ITEMS_REQUESTED) != -1) {
                tmp.m_128379_(TAG_ITEMS_DONE, true);
            }
            items.set(i, (Tag)tmp);
            break;
        }
        tag.m_128365_(TAG_ITEMS, (Tag)items);
        mainHandItem.m_41751_(tag);
    }

    public static void clearItemProcess(ItemStack target) {
        if (!target.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        CompoundTag tag = target.m_41784_();
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            tmp.m_128405_(TAG_ITEMS_COLLECTED, 0);
            tmp.m_128405_(TAG_ITEMS_DONE, 0);
            tmp.m_128405_(TAG_ITEMS_STORED, 0);
            tmp.m_128473_(TAG_ITEMS_MISSING);
            tmp.m_128473_(TAG_ITEMS_FAIL_ADDITION);
            list.set(i, (Tag)tmp);
        }
        tag.m_128473_(TAG_ITEMS_FAIL_ADDITION);
        tag.m_128405_(TAG_COOLING_DOWN, 0);
        tag.m_128379_(TAG_IGNORE_TASK, false);
        tag.m_128365_(TAG_ITEMS, (Tag)list);
        tag.m_128362_(TAG_UUID, UUID.randomUUID());
        tag.m_128379_(TAG_HAS_CHECK_STOCK, false);
        tag.m_128379_(TAG_BLACKMODE_DONE, false);
        target.m_41751_(tag);
    }

    public static void clearAllNonSuccess(ItemStack target) {
        if (!target.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        CompoundTag tag = target.m_41784_();
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag oDat;
            oDat.m_128379_(TAG_ITEMS_DONE, (oDat = list.m_128728_(i)).m_128451_(TAG_ITEMS_COLLECTED) >= oDat.m_128451_(TAG_ITEMS_REQUESTED) || oDat.m_128451_(TAG_ITEMS_REQUESTED) == -1);
            list.set(i, (Tag)oDat);
        }
        tag.m_128473_(TAG_ITEMS_FAIL_ADDITION);
        tag.m_128405_(TAG_COOLING_DOWN, 0);
        tag.m_128379_(TAG_IGNORE_TASK, false);
        tag.m_128365_(TAG_ITEMS, (Tag)list);
        target.m_41751_(tag);
    }

    public static boolean matchNbt(ItemStack mainHandItem) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!mainHandItem.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(mainHandItem.m_41783_());
        return tag.m_128471_(TAG_MATCH_TAG);
    }

    public static boolean isCoolingDown(ItemStack item) {
        if (!item.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!item.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(item.m_41783_());
        return tag.m_128451_(TAG_COOLING_DOWN) > 0;
    }

    public static void tickCoolingDown(ItemStack item) {
        if (!item.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!item.m_41782_()) {
            return;
        }
        CompoundTag tag = Objects.requireNonNull(item.m_41783_());
        if (tag.m_128451_(TAG_COOLING_DOWN) > 0) {
            tag.m_128405_(TAG_COOLING_DOWN, tag.m_128451_(TAG_COOLING_DOWN) - 1);
            item.m_41751_(tag);
            if (tag.m_128451_(TAG_COOLING_DOWN) == 0) {
                DebugData.sendDebug("Cooling Done(clear_repeat)", new Object[0]);
                RequestListItem.clearItemProcess(item);
            }
        }
    }

    public static void markDone(ItemStack mainHandItem, ItemStack target) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!mainHandItem.m_41782_()) {
            return;
        }
        CompoundTag tag = Objects.requireNonNull(mainHandItem.m_41783_());
        ListTag items = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag tmp = items.m_128728_(i);
            if (!ItemStack.m_150942_((ItemStack)ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM)), (ItemStack)target)) continue;
            tmp.m_128405_(TAG_ITEMS_DONE, 1);
            items.set(i, (Tag)tmp);
        }
        tag.m_128365_(TAG_ITEMS, (Tag)items);
        mainHandItem.m_41751_(tag);
    }

    public static void copyFailAdditionTo(ItemStack reqList, ItemStack mainHandItem, ItemStack targetItem) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get()) || !reqList.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!reqList.m_41782_()) {
            return;
        }
        CompoundTag fromTag = Objects.requireNonNull(reqList.m_41783_());
        CompoundTag toTag = mainHandItem.m_41784_();
        if (toTag.m_128441_(TAG_ITEMS_FAIL_ADDITION)) {
            toTag.m_128359_(TAG_ITEMS_FAIL_ADDITION, fromTag.m_128461_(TAG_ITEMS_FAIL_ADDITION));
        }
        ListTag list = fromTag.m_128437_(TAG_ITEMS, 10);
        ListTag toList = toTag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            ItemStack item = ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM));
            if (item.m_41619_() || !tmp.m_128441_(TAG_ITEMS_FAIL_ADDITION) && !tmp.m_128441_(TAG_ITEMS_MISSING)) continue;
            for (int j = 0; j < toList.size(); ++j) {
                CompoundTag tmp2 = toList.m_128728_(j);
                ItemStack toItem = ItemStackUtil.parseStack(tmp2.m_128469_(TAG_ITEMS_ITEM));
                if (!ItemStackUtil.isSame(item, toItem, true)) continue;
                tmp2.m_128359_(TAG_ITEMS_FAIL_ADDITION, tmp.m_128461_(TAG_ITEMS_FAIL_ADDITION));
                tmp2.m_128365_(TAG_ITEMS_MISSING, (Tag)tmp.m_128437_(TAG_ITEMS_MISSING, 10));
                toList.set(j, (Tag)tmp2);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand p_41434_) {
        if (player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(p_41434_));
        }
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!RequestListItem.isVirtual(serverPlayer.m_21205_())) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buffer -> {});
            }
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(p_41434_));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(p_41434_));
    }

    @Override
    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemStack, Player player, LivingEntity entity, InteractionHand p_41401_) {
        if (!player.m_9236_().f_46443_ && p_41401_ == InteractionHand.MAIN_HAND) {
            if (player.m_6144_()) {
                CompoundTag tag = itemStack.m_41784_();
                if (tag.m_128441_(TAG_STORAGE_ENTITY)) {
                    tag.m_128473_(TAG_STORAGE_ENTITY);
                } else {
                    if (tag.m_128441_(TAG_STORAGE)) {
                        tag.m_128473_(TAG_STORAGE);
                    }
                    tag.m_128362_(TAG_STORAGE_ENTITY, entity.m_20148_());
                }
                player.m_21205_().m_41751_(tag);
                return InteractionResult.SUCCESS;
            }
            if (entity instanceof EntityMaid && !RequestListItem.hasAnyStorage(itemStack)) {
                CompoundTag tag = itemStack.m_41784_();
                if (tag.m_128441_(TAG_STORAGE)) {
                    tag.m_128473_(TAG_STORAGE);
                }
                tag.m_128362_(TAG_STORAGE_ENTITY, player.m_20148_());
            }
        }
        return super.m_6880_(itemStack, player, entity, p_41401_);
    }

    @NotNull
    public InteractionResult m_6225_(@NotNull UseOnContext context) {
        Player player;
        if (!context.m_43725_().f_46443_ && (player = context.m_43723_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!serverPlayer.m_6144_()) {
                return InteractionResult.PASS;
            }
            BlockPos clickedPos = context.m_8083_();
            Target validTarget = MaidStorage.getInstance().isValidTarget((ServerLevel)context.m_43725_(), (LivingEntity)serverPlayer, clickedPos);
            if (validTarget != null) {
                ItemStack item = serverPlayer.m_21205_();
                CompoundTag tag = item.m_41784_();
                if (tag.m_128441_(TAG_STORAGE_ENTITY)) {
                    tag.m_128473_(TAG_STORAGE_ENTITY);
                }
                if (tag.m_128441_(TAG_STORAGE)) {
                    Target storage = Target.fromNbt(tag.m_128469_(TAG_STORAGE));
                    if (storage.getPos().equals((Object)clickedPos) && storage.getSide().isPresent() && storage.getSide().get() == context.m_43719_()) {
                        tag.m_128473_(TAG_STORAGE);
                        serverPlayer.m_213846_((Component)Component.m_237115_((String)"interaction.clear_storage"));
                    } else {
                        if (storage.pos.equals((Object)clickedPos)) {
                            storage.side = context.m_43719_();
                        } else {
                            storage.pos = clickedPos;
                            storage.side = null;
                        }
                        serverPlayer.m_213846_((Component)Component.m_237110_((String)"interaction.bind_storage", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
                        tag.m_128365_(TAG_STORAGE, (Tag)storage.toNbt());
                    }
                } else {
                    tag.m_128365_(TAG_STORAGE, (Tag)validTarget.toNbt());
                    serverPlayer.m_213846_((Component)Component.m_237110_((String)"interaction.bind_storage", (Object[])new Object[]{clickedPos.m_123341_(), clickedPos.m_123342_(), clickedPos.m_123343_()}));
                }
                item.m_41751_(tag);
            }
            return InteractionResult.CONSUME;
        }
        if (Objects.requireNonNull(context.m_43723_()).m_6144_()) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, @NotNull List<Component> toolTip, @NotNull TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, toolTip, p_41424_);
        toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.desc").m_130940_(ChatFormatting.GRAY));
        if (!itemStack.m_41782_()) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.no_tag"));
            return;
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (tag.m_128441_(TAG_VIRTUAL) && tag.m_128471_(TAG_VIRTUAL)) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.virtual").m_130940_(ChatFormatting.RED));
        }
        if (tag.m_128441_(TAG_STORAGE_ENTITY)) {
            String tuuid = tag.m_128342_(TAG_STORAGE_ENTITY).toString().substring(0, 8);
            toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.entity", (Object[])new Object[]{tuuid}));
        } else if (tag.m_128441_(TAG_STORAGE)) {
            Target storage = Target.fromNbt(tag.m_128469_(TAG_STORAGE));
            BlockPos storagePos = storage.getPos();
            toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.storage", (Object[])new Object[]{storagePos.m_123341_(), storagePos.m_123342_(), storagePos.m_123343_()}));
        } else {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.no_storage"));
        }
        if (!tag.m_128441_(TAG_ITEMS)) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.open_gui_to_config"));
        } else {
            ListTag list = tag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack;
                CompoundTag itemTag = list.m_128728_(i);
                if (!itemTag.m_128441_(TAG_ITEMS_ITEM) || (itemstack = ItemStackUtil.parseStack(itemTag.m_128469_(TAG_ITEMS_ITEM))).m_41619_()) continue;
                int collected = itemTag.m_128451_(TAG_ITEMS_COLLECTED);
                int requested = itemTag.m_128451_(TAG_ITEMS_REQUESTED);
                MutableComponent component = Component.m_237110_((String)"gui.maid_storage_manager.written_inventory_list.request_item_info", (Object[])new Object[]{itemstack.m_41786_().getString(), collected, String.valueOf(requested == -1 ? "*" : Integer.valueOf(requested))});
                component = itemTag.m_128471_(TAG_ITEMS_DONE) ? (collected >= requested || requested == -1 ? component.m_6881_().m_130940_(ChatFormatting.GREEN) : component.m_6881_().m_130940_(ChatFormatting.RED)) : component.m_6881_().m_130940_(ChatFormatting.GRAY);
                toolTip.add((Component)component);
            }
        }
        if (tag.m_128451_(TAG_REPEAT_INTERVAL) > 0) {
            if (tag.m_128471_(TAG_UNIT_SECOND)) {
                toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.repeat_interval_second", (Object[])new Object[]{tag.m_128451_(TAG_REPEAT_INTERVAL) / 20}));
            } else {
                toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.repeat_interval_tick", (Object[])new Object[]{tag.m_128451_(TAG_REPEAT_INTERVAL)}));
            }
            if (tag.m_128451_(TAG_COOLING_DOWN) > 0) {
                int cd = tag.m_128451_(TAG_COOLING_DOWN);
                if (tag.m_128471_(TAG_UNIT_SECOND)) {
                    cd /= 20;
                }
                toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.request_list.cooling_down", (Object[])new Object[]{cd}).m_130940_(ChatFormatting.GREEN));
            }
        }
    }

    public static boolean isAllStored(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        ListTag list = Objects.requireNonNull(tag).m_128437_(TAG_ITEMS, 10);
        return list.stream().map(t -> (CompoundTag)t).noneMatch(t -> {
            if (ItemStackUtil.parseStack(t.m_128469_(TAG_ITEMS_ITEM)).m_41619_()) {
                return false;
            }
            if (!t.m_128471_(TAG_ITEMS_DONE)) {
                return false;
            }
            return t.m_128451_(TAG_ITEMS_COLLECTED) > t.m_128451_(TAG_ITEMS_STORED);
        });
    }

    public static List<Pair<ItemStack, Integer>> getItemStacksNotDone(ItemStack stack) {
        return RequestListItem.getItemStacksNotDone(stack, true);
    }

    public static List<Pair<ItemStack, Integer>> getItemStacksNotDone(ItemStack stack, boolean includingNoRequest) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return List.of();
        }
        if (!stack.m_41782_()) {
            return List.of();
        }
        CompoundTag tag = stack.m_41783_();
        if (tag.m_128471_(TAG_BLACKMODE)) {
            return List.of();
        }
        ListTag list = Objects.requireNonNull(tag).m_128437_(TAG_ITEMS, 10);
        return list.stream().filter(t -> !((CompoundTag)t).m_128471_(TAG_ITEMS_DONE)).filter(t -> ((CompoundTag)t).m_128451_(TAG_ITEMS_REQUESTED) != -1 || includingNoRequest).map(t -> {
            ItemStack item = ItemStackUtil.parseStack(((CompoundTag)t).m_128469_(TAG_ITEMS_ITEM));
            int cnt = ((CompoundTag)t).m_128451_(TAG_ITEMS_REQUESTED);
            if (cnt != -1) {
                cnt -= ((CompoundTag)t).m_128451_(TAG_ITEMS_COLLECTED);
            }
            return new Pair((Object)item, (Object)cnt);
        }).filter(i -> !((ItemStack)i.getA()).m_41619_()).toList();
    }

    @Nullable
    public static UUID getStorageEntity(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return null;
        }
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        if (!tag.m_128441_(TAG_STORAGE_ENTITY)) {
            return null;
        }
        return tag.m_128342_(TAG_STORAGE_ENTITY);
    }

    @Nullable
    public static Target getStorageBlock(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return null;
        }
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        if (!tag.m_128441_(TAG_STORAGE)) {
            return null;
        }
        return Target.fromNbt(tag.m_128469_(TAG_STORAGE));
    }

    public static boolean hasAnyStorage(ItemStack stack) {
        Target storageBlock = RequestListItem.getStorageBlock(stack);
        if (storageBlock != null && storageBlock.getType() != AbstractTargetMemory.TargetData.NO_TARGET) {
            return true;
        }
        return RequestListItem.getStorageEntity(stack) != null;
    }

    public static ItemStack updateCollectedItem(ItemStack stack, ItemStack collected, int maxCollect, boolean isInCrafting) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return ItemStack.f_41583_;
        }
        if (!stack.m_41782_()) {
            return ItemStack.f_41583_;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        int nonCalc = Math.max(0, collected.m_41613_() - maxCollect);
        int rest = collected.m_41613_() - nonCalc;
        int available = collected.m_41613_();
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack requested;
            CompoundTag tmp = list.m_128728_(i);
            if (tmp.m_128471_(TAG_ITEMS_DONE) || !ItemStackUtil.isSame(collected, requested = ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM)), tag.m_128471_(TAG_MATCH_TAG), isInCrafting)) continue;
            if (tag.m_128471_(TAG_BLACKMODE)) {
                return collected;
            }
            int requestedCount = tmp.m_128451_(TAG_ITEMS_REQUESTED);
            int maxToStore = requestedCount;
            if (maxToStore == -1) {
                maxToStore = Integer.MAX_VALUE;
            }
            maxToStore -= tmp.m_128451_(TAG_ITEMS_COLLECTED);
            if ((maxToStore = Math.min(maxToStore, rest)) > 0) {
                rest -= maxToStore;
                int currentCollected = tmp.m_128451_(TAG_ITEMS_COLLECTED) + maxToStore;
                tmp.m_128405_(TAG_ITEMS_COLLECTED, currentCollected);
                list.set(i, (Tag)tmp);
                if (currentCollected >= requestedCount && requestedCount != -1) {
                    tmp.m_128379_(TAG_ITEMS_DONE, true);
                    list.set(i, (Tag)tmp);
                }
            }
            if (rest <= 0) break;
        }
        tag.m_128365_(TAG_ITEMS, (Tag)list);
        stack.m_41751_(tag);
        if (tag.m_128471_(TAG_BLACKMODE)) {
            rest = 0;
        }
        return collected.m_255036_(nonCalc + rest);
    }

    public static int updateStored(ItemStack stack, ItemStack toStore, boolean simulate, boolean isInCrafting) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return toStore.m_41613_();
        }
        if (!stack.m_41782_()) {
            return toStore.m_41613_();
        }
        int rest = toStore.m_41613_();
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            ItemStack target = ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM));
            int collected = tmp.m_128451_(TAG_ITEMS_COLLECTED);
            int stored = tmp.m_128451_(TAG_ITEMS_STORED);
            if (stored >= collected) continue;
            if (ItemStackUtil.isSame(toStore, target, tag.m_128471_(TAG_MATCH_TAG), isInCrafting)) {
                if (tag.m_128471_(TAG_BLACKMODE)) {
                    return rest;
                }
                int maxToStore = collected - stored;
                if ((maxToStore = Math.min(maxToStore, rest)) > 0) {
                    rest -= maxToStore;
                    if (!simulate) {
                        tmp.m_128405_(TAG_ITEMS_STORED, stored + maxToStore);
                    }
                    list.set(i, (Tag)tmp);
                }
            }
            if (rest <= 0) break;
        }
        tag.m_128365_(TAG_ITEMS, (Tag)list);
        stack.m_41751_(tag);
        if (tag.m_128471_(TAG_BLACKMODE)) {
            rest = 0;
        }
        return rest;
    }

    public static void updateCollectedNotStored(ItemStack stack, IItemHandler tmpStorage) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            ItemStack target = ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM));
            int requested = tmp.m_128451_(TAG_ITEMS_REQUESTED);
            int collected = tmp.m_128451_(TAG_ITEMS_COLLECTED);
            int stored = tmp.m_128451_(TAG_ITEMS_STORED);
            if (stored >= collected) continue;
            int count = 0;
            for (int j = 0; j < tmpStorage.getSlots(); ++j) {
                ItemStack itemStack = tmpStorage.getStackInSlot(j);
                if (!ItemStackUtil.isSame(itemStack, target, tag.m_128471_(TAG_MATCH_TAG))) continue;
                count += itemStack.m_41613_();
            }
            tmp.m_128405_(TAG_ITEMS_COLLECTED, stored + Math.min(requested - stored, count));
        }
    }

    public static void setFailAddition(ItemStack stack, ItemStack item, String failAddition) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            if (!ItemStack.m_150942_((ItemStack)ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM)), (ItemStack)item)) continue;
            tag.m_128359_(TAG_ITEMS_FAIL_ADDITION, failAddition);
            list.set(i, (Tag)tmp);
        }
        tag.m_128365_(TAG_ITEMS, (Tag)list);
    }

    public static void markAllDone(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!stack.m_41782_()) {
            return;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            tmp.m_128379_(TAG_ITEMS_DONE, true);
            list.set(i, (Tag)tmp);
        }
        tag.m_128379_(TAG_BLACKMODE_DONE, true);
        tag.m_128365_(TAG_ITEMS, (Tag)list);
    }

    @NotNull
    public static UUID getUUID(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return UUID.randomUUID();
        }
        if (!stack.m_41782_()) {
            return UUID.randomUUID();
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        if (!tag.m_128441_(TAG_UUID)) {
            tag.m_128362_(TAG_UUID, UUID.randomUUID());
        }
        return tag.m_128342_(TAG_UUID);
    }

    public static void setMissingItem(ItemStack requestListItem, ItemStack toSetFailItem, List<ItemStack> missing) {
        if (!requestListItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        if (!requestListItem.m_41782_()) {
            return;
        }
        CompoundTag tag = Objects.requireNonNull(requestListItem.m_41783_());
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            if (!ItemStack.m_150942_((ItemStack)ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM)), (ItemStack)toSetFailItem)) continue;
            ListTag missingList = tmp.m_128437_(TAG_ITEMS_MISSING, 10);
            for (ItemStack ti : missing) {
                if (ti.m_41619_() || ti.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) continue;
                int idx = -1;
                for (int j = 0; j < missingList.size(); ++j) {
                    if (!ItemStack.m_150942_((ItemStack)ItemStackUtil.parseStack(missingList.m_128728_(j)), (ItemStack)ti)) continue;
                    idx = j;
                }
                if (idx != -1) {
                    ItemStack toBeSaved = ItemStackUtil.parseStack(missingList.m_128728_(idx));
                    toBeSaved.m_41769_(ti.m_41613_());
                    missingList.set(idx, (Tag)ItemStackUtil.saveStack(toBeSaved));
                    continue;
                }
                if (missingList.size() >= 15) continue;
                missingList.add((Object)ItemStackUtil.saveStack(ti));
            }
            tmp.m_128365_(TAG_ITEMS_MISSING, (Tag)missingList);
            list.set(i, (Tag)tmp);
            break;
        }
        tag.m_128365_(TAG_ITEMS, (Tag)list);
        requestListItem.m_41751_(tag);
    }

    public static boolean isAllSuccess(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        if (tag.m_128471_(TAG_BLACKMODE)) {
            return tag.m_128471_(TAG_BLACKMODE_DONE);
        }
        ListTag list = tag.m_128437_(TAG_ITEMS, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            if (ItemStackUtil.parseStack(tmp.m_128469_(TAG_ITEMS_ITEM)).m_41619_() || tmp.m_128451_(TAG_ITEMS_REQUESTED) == -1 || tmp.m_128451_(TAG_ITEMS_COLLECTED) >= tmp.m_128451_(TAG_ITEMS_REQUESTED)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStockMode(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        return tag.m_128471_(TAG_STOCK_MODE);
    }

    public static boolean hasCheckedStock(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        return tag.m_128471_(TAG_HAS_CHECK_STOCK);
    }

    public static void setHasCheckedStock(ItemStack stack, boolean has) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_(TAG_HAS_CHECK_STOCK, has);
    }

    public static boolean isVirtual(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        return stack.m_41784_().m_128471_(TAG_VIRTUAL);
    }

    public static boolean isBlackMode(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        return tag.m_128471_(TAG_BLACKMODE);
    }

    public static boolean isBlackModeDone(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        return tag.m_128471_(TAG_BLACKMODE_DONE);
    }

    public static void setVirtualData(ItemStack stack, CompoundTag data) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(TAG_VIRTUAL_DATA, (Tag)data);
        stack.m_41751_(tag);
    }

    public static CompoundTag getVirtualData(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return null;
        }
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        return tag.m_128469_(TAG_VIRTUAL_DATA);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        if (RequestListItem.isVirtual(p_39956_.m_21120_(InteractionHand.MAIN_HAND))) {
            return null;
        }
        return new ItemSelectorMenu(p_39954_, p_39956_);
    }
}

