/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.maid.ChatTexts;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.maid.task.StorageManageTask;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.MaidStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class ChangeFlag
extends Item {
    public static final String TAG_STORAGES = "storages";

    public ChangeFlag() {
        super(new Item.Properties().m_41487_(1));
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.m_6225_(context);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ServerPlayer serverPlayer;
        Player player;
        if (!context.m_43725_().f_46443_ && (player = context.m_43723_()) instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_6144_()) {
            BlockPos clickedPos = context.m_8083_();
            Direction side = context.m_43719_();
            Target validTarget = MaidStorage.getInstance().isValidTarget((ServerLevel)context.m_43725_(), (LivingEntity)serverPlayer, clickedPos, side);
            if (validTarget != null) {
                ItemStack item = serverPlayer.m_21205_();
                CompoundTag tag = item.m_41784_();
                if (!tag.m_128441_(TAG_STORAGES)) {
                    tag.m_128365_(TAG_STORAGES, (Tag)new ListTag());
                }
                ListTag list = tag.m_128437_(TAG_STORAGES, 10);
                boolean found = false;
                for (int i = 0; i < list.size(); ++i) {
                    Target storage = Target.fromNbt(list.m_128728_(i));
                    if (storage.equals(validTarget)) {
                        list.remove(i);
                        found = true;
                        break;
                    }
                    if (!storage.pos.equals((Object)validTarget.pos)) continue;
                    list.set(i, (Tag)validTarget.toNbt());
                    found = true;
                    break;
                }
                if (!found) {
                    list.add((Object)validTarget.withoutSide().toNbt());
                }
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity living, InteractionHand hand) {
        if (!player.m_9236_().f_46443_ && hand == InteractionHand.MAIN_HAND && living instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)living;
            ServerLevel level = (ServerLevel)player.m_9236_();
            if (maid.m_269323_() != null && maid.m_269323_().m_20148_().equals(player.m_20148_()) && maid.getTask().getUid().equals((Object)StorageManageTask.TASK_ID)) {
                List<Target> storages = ChangeFlag.getStorages(itemStack);
                if (storages.size() == 0) {
                    return InteractionResult.CONSUME;
                }
                storages.forEach(interactedTarget -> {
                    Target target;
                    List<Target> possibleTargets = StorageAccessUtil.findTargetRewrite(level, maid, interactedTarget.withoutSide(), false);
                    if (possibleTargets.contains(interactedTarget)) {
                        target = interactedTarget;
                    } else if (possibleTargets.size() > 0) {
                        target = possibleTargets.get(0);
                    } else {
                        ChangeFlag.clearVisForMemories((ServerLevel)player.m_9236_(), maid, interactedTarget);
                        return;
                    }
                    Target storage = MemoryUtil.getViewedInventory(maid).ambitiousPos(level, target);
                    ChangeFlag.clearVisForMemories((ServerLevel)player.m_9236_(), maid, storage);
                    MemoryUtil.getViewedInventory(maid).addMarkChanged(storage);
                });
                player.m_213846_((Component)Component.m_237110_((String)"interaction.flag_changed", (Object[])new Object[]{storages.size()}));
                ChangeFlag.clearStorages(itemStack);
                MemoryUtil.clearTarget(maid);
                ChatTexts.send(maid, "chat_bubbles.maid_storage_manager.check_mark_changed");
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(itemStack, player, living, hand);
    }

    public static List<Target> getStorages(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.CHANGE_FLAG.get()) && !stack.m_41782_()) {
            return List.of();
        }
        ArrayList<Target> storages = new ArrayList<Target>();
        ListTag tags = stack.m_41784_().m_128437_(TAG_STORAGES, 10);
        for (int i = 0; i < tags.size(); ++i) {
            storages.add(Target.fromNbt(tags.m_128728_(i)));
        }
        return storages;
    }

    public static void clearStorages(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128365_(TAG_STORAGES, (Tag)new ListTag());
        stack.m_41751_(tag);
    }

    public static void clearVisForMemories(ServerLevel level, EntityMaid maid, Target storage) {
        ChangeFlag.clearVisForMemories(level, MemoryUtil.getRequestProgress(maid), storage);
        ChangeFlag.clearVisForMemories(level, MemoryUtil.getViewedInventory(maid), storage);
        ChangeFlag.clearVisForMemories(level, MemoryUtil.getCrafting(maid), storage);
        ChangeFlag.clearVisForMemories(level, MemoryUtil.getPlacingInv(maid), storage);
        ChangeFlag.clearVisForMemories(level, MemoryUtil.getResorting(maid), storage);
    }

    public static void clearVisForMemories(ServerLevel level, AbstractTargetMemory memory, Target storage) {
        memory.removeVisitedPos(storage);
        StorageAccessUtil.checkNearByContainers((Level)level, storage.getPos(), pos -> memory.removeVisitedPos(storage.sameType((BlockPos)pos, null)));
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, tooltip, p_41424_);
        CompoundTag tag = itemStack.m_41784_();
        tooltip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.change_flag.desc").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.change_flag.storages", (Object[])new Object[]{ChangeFlag.getStorages(itemStack).size()}));
    }
}

