/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.integration.tacz;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.block.entity.GunSmithTableBlockEntity;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModItems;
import com.tacz.guns.init.ModRecipe;
import com.tacz.guns.item.ModernKineticGunItem;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import studio.fantasyit.maid_storage_manager.craft.CollectCraftEvent;
import studio.fantasyit.maid_storage_manager.craft.action.CraftAction;
import studio.fantasyit.maid_storage_manager.craft.action.PathTargetLocator;
import studio.fantasyit.maid_storage_manager.craft.context.special.TaczRecipeAction;
import studio.fantasyit.maid_storage_manager.craft.generator.type.misc.GeneratorTACZ;
import studio.fantasyit.maid_storage_manager.craft.type.TaczType;

public class TaczRecipe {
    public static void addType(CollectCraftEvent event) {
        event.addCraftType(new TaczType());
        event.addAction(TaczType.TYPE, TaczRecipeAction::new, PathTargetLocator::commonNearestAvailablePos, CraftAction.PathEnoughLevel.NORMAL.value, false, true, 10, 1);
        event.addAutoCraftGuideGenerator(new GeneratorTACZ());
        event.addItemStackPredicate((Item)ModItems.MODERN_KINETIC_GUN.get(), (stack, target) -> {
            Item patt1918$temp = stack.m_41720_();
            if (patt1918$temp instanceof ModernKineticGunItem) {
                ModernKineticGunItem gun = (ModernKineticGunItem)patt1918$temp;
                return gun.getGunId(stack).equals((Object)gun.getGunId(target));
            }
            return false;
        });
    }

    public static ResourceLocation getBlockId(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GunSmithTableBlockEntity) {
            GunSmithTableBlockEntity gsbe = (GunSmithTableBlockEntity)blockEntity;
            return Optional.ofNullable(gsbe.getId()).orElse(DefaultAssets.DEFAULT_BLOCK_ID);
        }
        return DefaultAssets.EMPTY_BLOCK_ID;
    }

    public static List<GunSmithTableRecipe> getAllRecipesForBlockId(Level level, ResourceLocation blockId) {
        RecipeManager recipeManager = level.m_7465_();
        List allRecipesFor = recipeManager.m_44013_((RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get());
        Optional commonBlockIndex = TimelessAPI.getCommonBlockIndex((ResourceLocation)blockId);
        if (commonBlockIndex.isPresent()) {
            RecipeFilter filter;
            List tabs = ((CommonBlockIndex)commonBlockIndex.get()).getData().getTabs();
            if (DefaultAssets.DEFAULT_BLOCK_ID.equals((Object)blockId) && !((Boolean)SyncConfig.ENABLE_TABLE_FILTER.get()).booleanValue()) {
                tabs = TabConfig.DEFAULT_TABS;
            }
            List finalTabs = tabs;
            allRecipesFor = allRecipesFor.stream().filter(recipe -> {
                ResourceLocation group = recipe.getResult().getGroup();
                return finalTabs.stream().anyMatch(tab -> tab.id().equals((Object)group));
            }).toList();
            if ((!blockId.equals((Object)DefaultAssets.DEFAULT_BLOCK_ID) || ((Boolean)SyncConfig.ENABLE_TABLE_FILTER.get()).booleanValue()) && (filter = ((CommonBlockIndex)commonBlockIndex.get()).getFilter()) != null) {
                allRecipesFor = filter.filter(allRecipesFor, GunSmithTableRecipe::m_6423_);
            }
        }
        return allRecipesFor;
    }
}

