/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.vanilla;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonAttackAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonIdleAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.PosUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorStripping
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return new ResourceLocation("maid_storage_manager", "stripping");
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60838_((BlockGetter)level, pos) && StorageAccessUtil.getMarksForPosSet((Level)((ServerLevel)level), Target.virtual(pos, null), List.of(pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_())).stream().map(Pair::getB).anyMatch(t -> t.m_150930_((Item)ItemRegistry.ALLOW_ACCESS.get())) && PosUtil.findInUpperSquare(pos.m_7494_(), 1, 3, 1, t -> level.m_8055_(t).m_60795_() ? null : Boolean.valueOf(true)) == null;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        Arrays.stream(Ingredient.m_204132_((TagKey)ItemTags.f_13182_).m_43908_()).forEach(itemStack -> {
            Item patt3527$temp = itemStack.m_41720_();
            if (patt3527$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt3527$temp;
                BlockState axeStrippingState = AxeItem.getAxeStrippingState((BlockState)blockItem.m_40614_().m_49966_());
                if (axeStrippingState == null) {
                    return;
                }
                ItemStack strippedItem = axeStrippingState.m_60734_().m_5456_().m_7968_();
                @Nullable ResourceLocation _key = ForgeRegistries.ITEMS.getKey((Object)strippedItem.m_41720_());
                if (_key == null) {
                    return;
                }
                ResourceLocation key = new ResourceLocation(_key.m_135827_(), _key.m_135815_() + "_stripping");
                graph.addRecipe(key, List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), Ingredient.m_204132_((TagKey)ItemTags.f_271207_)), List.of(Integer.valueOf(1), Integer.valueOf(1)), List.of(strippedItem), items -> {
                    ArrayList<CraftGuideStepData> craftGuideData = new ArrayList<CraftGuideStepData>();
                    craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of((ItemStack)items.get(0)), List.of(), CommonUseAction.TYPE, false, new CompoundTag()));
                    craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_(), Direction.UP), List.of((ItemStack)items.get(1)), List.of(), CommonUseAction.TYPE, false, new CompoundTag()));
                    craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos.m_7494_()), List.of((ItemStack)items.get(1)), List.of(strippedItem), CommonAttackAction.TYPE, false, new CompoundTag()));
                    craftGuideData.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of(), List.of((ItemStack)items.get(1), (ItemStack)items.get(1)), CommonIdleAction.TYPE, false, new CompoundTag()));
                    return new CraftGuideData(craftGuideData, CommonType.TYPE);
                });
            }
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        Arrays.stream(Ingredient.m_204132_((TagKey)ItemTags.f_13182_).m_43908_()).forEach(itemStack -> {
            Item patt7306$temp = itemStack.m_41720_();
            if (patt7306$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt7306$temp;
                BlockState axeStrippingState = AxeItem.getAxeStrippingState((BlockState)blockItem.m_40614_().m_49966_());
                if (axeStrippingState == null) {
                    return;
                }
                ItemStack strippedItem = axeStrippingState.m_60734_().m_5456_().m_7968_();
                @Nullable ResourceLocation _key = ForgeRegistries.ITEMS.getKey((Object)strippedItem.m_41720_());
                if (_key == null) {
                    return;
                }
                ResourceLocation key = new ResourceLocation(_key.m_135827_(), _key.m_135815_() + "_stripping");
                RecipeIngredientCache.addRecipeCache(key, List.of(Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}), Ingredient.m_204132_((TagKey)ItemTags.f_271207_)));
            }
        });
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.maid_storage_manager.stripping");
    }
}

