/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.create;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.MaidPathFindingBFS;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.kinetics.fan.AirCurrent;
import com.simibubi.create.content.kinetics.fan.EncasedFanBlockEntity;
import com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes;
import com.simibubi.create.content.kinetics.fan.processing.FanProcessingType;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.config.ConfigTypes;
import studio.fantasyit.maid_storage_manager.craft.generator.type.create.GeneratorCreate;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.craft.type.FurnaceType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.integration.create.CreateIntegration;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.MathUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorCreateFanRecipes
extends GeneratorCreate<ProcessingRecipe<RecipeWrapper>, RecipeType<ProcessingRecipe<RecipeWrapper>>, RecipeWrapper, BlockPos> {
    ConfigTypes.ConfigType<Integer> COUNT = new ConfigTypes.ConfigType<Integer>("count", 8, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.fan.count"), ConfigTypes.ConfigTypeEnum.Integer);
    ConfigTypes.ConfigType<Boolean> BLASTING = new ConfigTypes.ConfigType<Boolean>("blasting", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.fan.blasting"), ConfigTypes.ConfigTypeEnum.Boolean);
    ConfigTypes.ConfigType<Boolean> SMOKING = new ConfigTypes.ConfigType<Boolean>("smoking", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.fan.smoking"), ConfigTypes.ConfigTypeEnum.Boolean);
    ConfigTypes.ConfigType<Boolean> HAUNTING = new ConfigTypes.ConfigType<Boolean>("haunting", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.fan.haunting"), ConfigTypes.ConfigTypeEnum.Boolean);
    ConfigTypes.ConfigType<Boolean> SPLASHING = new ConfigTypes.ConfigType<Boolean>("splashing", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.fan.splashing"), ConfigTypes.ConfigTypeEnum.Boolean);
    ConfigTypes.ConfigType<Boolean> REPLACE_FURNACE = new ConfigTypes.ConfigType<Boolean>("replace_furnace", true, (Component)Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.fan.replace_furnace"), ConfigTypes.ConfigTypeEnum.Boolean);

    @Override
    @NotNull
    public ResourceLocation getType() {
        return new ResourceLocation("create", "fan");
    }

    @Override
    public boolean allowMultiPosition() {
        return true;
    }

    @Override
    public boolean canCacheGraph() {
        return false;
    }

    @Override
    public boolean positionalAvailable(ServerLevel level, EntityMaid maid, BlockPos pos, MaidPathFindingBFS pathFinding) {
        return true;
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_((Block)AllBlocks.ENCASED_FAN.get());
    }

    @Override
    protected int getMinFullBucketCount(ProcessingRecipe<RecipeWrapper> recipe) {
        if (recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_).m_41741_() == 1) {
            return super.getMinFullBucketCount(recipe);
        }
        return MathUtil.lcm(super.getMinFullBucketCount(recipe), this.COUNT.getValue());
    }

    @Override
    @Deprecated
    RecipeType<ProcessingRecipe<RecipeWrapper>> getRecipeType() {
        return null;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        Pair furnaceReplace = new Pair((Object)new MutableBoolean(), (Object)new MutableBoolean());
        BlockEntity _be = level.m_7702_(pos);
        if (_be instanceof EncasedFanBlockEntity) {
            EncasedFanBlockEntity be = (EncasedFanBlockEntity)_be;
            AirCurrent airCurrent = be.getAirCurrent();
            Direction dir = airCurrent.direction;
            if (dir == null) {
                return;
            }
            int i = 0;
            while ((float)i < airCurrent.maxDistance) {
                FanProcessingType typeAt;
                int offset = airCurrent.pushing ? i : (int)(airCurrent.maxDistance - (float)i - 1.0f);
                BlockPos test = pos.m_5484_(dir, offset + 1);
                if (level.m_8055_(test).m_60713_((Block)AllBlocks.DEPOT.get())) {
                    typeAt = airCurrent.getTypeAt((float)offset);
                    if (typeAt != null) {
                        this.generateFor(typeAt, level, test, graph, (Pair<MutableBoolean, MutableBoolean>)furnaceReplace);
                    }
                } else if (level.m_8055_(test.m_7495_()).m_60713_((Block)AllBlocks.DEPOT.get()) && (typeAt = airCurrent.getTypeAt((float)offset)) != null) {
                    this.generateFor(typeAt, level, test.m_7495_(), graph, (Pair<MutableBoolean, MutableBoolean>)furnaceReplace);
                }
                ++i;
            }
            if (((MutableBoolean)furnaceReplace.getA()).getValue().booleanValue() && ((MutableBoolean)furnaceReplace.getB()).getValue().booleanValue() && this.REPLACE_FURNACE.getValue().booleanValue()) {
                graph.blockType(FurnaceType.TYPE);
            }
        }
    }

    private static boolean isProcessingRecipe(RecipeType<?> recipe) {
        return recipe == AllRecipeTypes.HAUNTING.getType() || recipe == AllRecipeTypes.SPLASHING.getType();
    }

    private RecipeType<?> getRecipeType(FanProcessingType typeAt) {
        if (typeAt instanceof AllFanProcessingTypes.BlastingType) {
            if (this.BLASTING.getValue().booleanValue()) {
                return RecipeType.f_44109_;
            }
        } else if (typeAt instanceof AllFanProcessingTypes.SmokingType) {
            if (this.SMOKING.getValue().booleanValue()) {
                return RecipeType.f_44110_;
            }
        } else if (typeAt instanceof AllFanProcessingTypes.HauntingType) {
            if (this.HAUNTING.getValue().booleanValue()) {
                return AllRecipeTypes.HAUNTING.getType();
            }
        } else if (typeAt instanceof AllFanProcessingTypes.SplashingType && this.SPLASHING.getValue().booleanValue()) {
            return AllRecipeTypes.SPLASHING.getType();
        }
        return null;
    }

    private List<Recipe<Container>> buildFor(RecipeType<Recipe<Container>> type1, RecipeType<Recipe<Container>> type2, RecipeType<Recipe<Container>> typeExc, RecipeManager manager, Level level) {
        ArrayList<Recipe<Container>> list = new ArrayList<Recipe<Container>>();
        ArrayList recItems = new ArrayList();
        manager.m_44013_(type1).forEach(value -> {
            if (value.m_7527_().isEmpty()) {
                return;
            }
            Ingredient first = (Ingredient)value.m_7527_().get(0);
            if (first.m_43947_()) {
                return;
            }
            ItemStack firstItem = first.m_43908_()[0];
            Optional excRecipe = manager.m_44015_(typeExc, (Container)new SimpleContainer(new ItemStack[]{firstItem}), level);
            if (excRecipe.isPresent() && ItemStack.m_41656_((ItemStack)((Recipe)excRecipe.get()).m_8043_(level.m_9598_()), (ItemStack)value.m_8043_(level.m_9598_()))) {
                return;
            }
            recItems.add(firstItem);
            list.add((Recipe<Container>)value);
        });
        manager.m_44013_(type2).forEach(value -> {
            if (value.m_7527_().isEmpty()) {
                return;
            }
            Ingredient first = (Ingredient)value.m_7527_().get(0);
            if (first.m_43947_()) {
                return;
            }
            if (recItems.stream().anyMatch(first)) {
                return;
            }
            ItemStack firstItem = first.m_43908_()[0];
            Optional excRecipe = manager.m_44015_(typeExc, (Container)new SimpleContainer(new ItemStack[]{firstItem}), level);
            if (excRecipe.isPresent() && ItemStack.m_41656_((ItemStack)((Recipe)excRecipe.get()).m_8043_(level.m_9598_()), (ItemStack)value.m_8043_(level.m_9598_()))) {
                return;
            }
            list.add((Recipe<Container>)value);
        });
        return list;
    }

    private List<Recipe<Container>> getInputs(FanProcessingType typeAt, Level level, RecipeManager manager) {
        if (typeAt instanceof AllFanProcessingTypes.BlastingType) {
            if (this.BLASTING.getValue().booleanValue()) {
                return this.buildFor((RecipeType<Recipe<Container>>)RecipeType.f_44109_, (RecipeType<Recipe<Container>>)RecipeType.f_44108_, (RecipeType<Recipe<Container>>)RecipeType.f_44110_, manager, level);
            }
        } else if (typeAt instanceof AllFanProcessingTypes.SmokingType) {
            if (this.SMOKING.getValue().booleanValue()) {
                return manager.m_44013_(RecipeType.f_44110_);
            }
        } else if (typeAt instanceof AllFanProcessingTypes.HauntingType) {
            if (this.HAUNTING.getValue().booleanValue()) {
                return manager.m_44013_(AllRecipeTypes.HAUNTING.getType());
            }
        } else if (typeAt instanceof AllFanProcessingTypes.SplashingType && this.SPLASHING.getValue().booleanValue()) {
            return manager.m_44013_(AllRecipeTypes.SPLASHING.getType());
        }
        return List.of();
    }

    private void generateFor(FanProcessingType typeAt, Level level, BlockPos test, ICachableGeneratorGraph graph, Pair<MutableBoolean, MutableBoolean> furnaceReplace) {
        RecipeType<?> type = this.getRecipeType(typeAt);
        if (type != null) {
            if (typeAt instanceof AllFanProcessingTypes.BlastingType) {
                ((MutableBoolean)furnaceReplace.getA()).setTrue();
            }
            if (typeAt instanceof AllFanProcessingTypes.SmokingType) {
                ((MutableBoolean)furnaceReplace.getB()).setTrue();
            }
            if (GeneratorCreateFanRecipes.isProcessingRecipe(type)) {
                this.addRecipeForPos(level, test, type, graph, recipe -> true);
            } else {
                StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, test);
                this.getInputs(typeAt, level, level.m_7465_()).forEach(recipe -> {
                    ItemStack resultItem = recipe.m_8043_(level.m_9598_());
                    if (!posFilter.isAvailable(resultItem)) {
                        return;
                    }
                    graph.addRecipeWrapId((Recipe<?>)recipe, this.getType(), items -> {
                        ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                        GeneratorCreateFanRecipes.each3items(items, t -> steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, test), t.stream().map(i -> i.m_255036_(i.m_41613_() * this.COUNT.getValue())).toList(), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag())));
                        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, test), List.of(), List.of(resultItem.m_255036_(resultItem.m_41613_() * this.COUNT.getValue())), CommonTakeItemAction.TYPE, false, new CompoundTag()));
                        return new CraftGuideData(steps, CommonType.TYPE);
                    });
                });
            }
        }
    }

    @Override
    public void onCache(RecipeManager manager) {
        CreateIntegration.getFanProcessingTypes().forEach(typeAt -> {
            RecipeType<?> type = this.getRecipeType((FanProcessingType)typeAt);
            if (type == null) {
                return;
            }
            if (GeneratorCreateFanRecipes.isProcessingRecipe(type)) {
                manager.m_44013_(type).stream().forEach(processingRecipe -> {
                    List itemIngredients = GeneratorCreateFanRecipes.optionalIngredientList((List<Ingredient>)processingRecipe.m_7527_()).orElse(List.of());
                    List fluidBuckets = GeneratorCreateFanRecipes.transformFluidIngredient((List<FluidIngredient>)processingRecipe.getFluidIngredients()).orElse(List.of());
                    ArrayList<Ingredient> all = new ArrayList<Ingredient>();
                    all.addAll(itemIngredients);
                    all.addAll(fluidBuckets);
                    ArrayList<Integer> counts = new ArrayList<Integer>();
                    all.forEach(t -> counts.add(0));
                    this.transformAllIngredients(processingRecipe, all, counts);
                    RecipeIngredientCache.addRecipeCache(processingRecipe.m_6423_(), all);
                });
            } else {
                manager.m_44013_(type).forEach(RecipeIngredientCache::addRecipeCache);
            }
        });
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.create.fan");
    }

    @Override
    public List<ConfigTypes.ConfigType<?>> getConfigurations() {
        return List.of(this.COUNT, this.SPLASHING, this.HAUNTING, this.SMOKING, this.BLASTING, this.REPLACE_FURNACE);
    }
}

