/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.botania;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonAttackAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.PosUtil;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;
import vazkii.botania.common.lib.BotaniaTags;

public class GeneratorBotaniaMythicalFlower
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return new ResourceLocation("botania", "mythical_flower");
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_204336_(BlockTags.f_144274_) && StorageAccessUtil.getMarksForPosSet((Level)((ServerLevel)level), Target.virtual(pos, null), List.of(pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_())).stream().map(Pair::getB).anyMatch(t -> t.m_150930_((Item)ItemRegistry.ALLOW_ACCESS.get())) && PosUtil.findInUpperSquare(pos.m_7494_(), 1, 3, 1, t -> level.m_8055_(t).m_60795_() ? null : Boolean.valueOf(true)) == null;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        for (ItemStack flower : Ingredient.m_204132_((TagKey)BotaniaTags.Items.MYSTICAL_FLOWERS).m_43908_()) {
            String color = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)flower.m_41720_())).m_135815_().split("_")[0];
            List<Ingredient> ingredients = List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{flower.m_41720_(), (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", color + "_petal"))}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_}));
            ItemStack output = ((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", color + "_double_flower"))).m_7968_().m_41777_();
            graph.addRecipe(new ResourceLocation("botania", "mythical_flower_plant_" + color), ingredients, List.of(Integer.valueOf(1), Integer.valueOf(1)), List.of(output), items -> {
                ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of((ItemStack)items.get(0)), List.of(), CommonUseAction.TYPE, false, new CompoundTag()));
                steps.add(new CraftGuideStepData(Target.virtual(pos.m_7494_(), null), List.of((ItemStack)items.get(1)), List.of(), CommonUseAction.TYPE, false, new CompoundTag()));
                steps.add(new CraftGuideStepData(Target.virtual(pos.m_7494_(), null), List.of(), List.of(output), CommonAttackAction.TYPE, false, new CompoundTag()));
                return new CraftGuideData(steps, CommonType.TYPE);
            });
        }
    }

    @Override
    public void onCache(RecipeManager manager) {
        for (ItemStack flower : Ingredient.m_204132_((TagKey)BotaniaTags.Items.MYSTICAL_FLOWERS).m_43908_()) {
            String color = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)flower.m_41720_())).m_135815_().split("_")[0];
            RecipeIngredientCache.addRecipeCache(new ResourceLocation("botania", "mythical_flower_plant_" + color), List.of(Ingredient.m_43929_((ItemLike[])new ItemLike[]{flower.m_41720_(), (ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", color + "_petal"))}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42499_})));
        }
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.botania.mythrical_flower");
    }
}

