/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.ae2;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.blockentity.misc.InscriberBlockEntity;
import appeng.core.definitions.AEBlocks;
import appeng.recipes.handlers.InscriberProcessType;
import appeng.recipes.handlers.InscriberRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorAE2Inscriber
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return new ResourceLocation("ae2", "inscriber");
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        if (!level.m_8055_(pos).m_60713_(AEBlocks.INSCRIBER.block())) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InscriberBlockEntity) {
            InscriberBlockEntity inscriber = (InscriberBlockEntity)blockEntity;
            return inscriber.getConfigManager().getSetting(Settings.AUTO_EXPORT) != YesNo.YES;
        }
        return false;
    }

    public ResourceLocation transformRecipeId(ResourceLocation recipeId, boolean skipFirst) {
        if (skipFirst) {
            return new ResourceLocation(recipeId.m_135827_(), recipeId.m_135815_() + "_skipped_first");
        }
        return recipeId;
    }

    @Override
    public boolean allowMultiPosition() {
        return true;
    }

    @Override
    public boolean canCacheGraph() {
        return false;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof InscriberBlockEntity) {
            InscriberBlockEntity inscriber = (InscriberBlockEntity)blockEntity;
            StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
            ItemStack topItem = inscriber.getInternalInventory().getStackInSlot(0);
            level.m_7465_().m_44013_(InscriberRecipe.TYPE).forEach(recipe -> {
                boolean skipFirst;
                if (!posFilter.isAvailable(recipe.getResultItem())) {
                    return;
                }
                if (!recipe.getTopOptional().m_43947_() && recipe.getTopOptional().test(recipe.getResultItem())) {
                    return;
                }
                boolean available = true;
                boolean hasPriority = false;
                if (!topItem.m_41619_()) {
                    if (recipe.getTopOptional().m_43947_()) {
                        available = false;
                    } else if (!recipe.getTopOptional().test(topItem)) {
                        available = false;
                    }
                    hasPriority = true;
                    skipFirst = true;
                } else if (recipe.getTopOptional().m_43947_()) {
                    skipFirst = true;
                } else if (recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
                    if (inscriber.getConfigManager().getSetting(Settings.INSCRIBER_SEPARATE_SIDES) == YesNo.NO) {
                        skipFirst = false;
                        available = false;
                    } else {
                        skipFirst = false;
                    }
                } else {
                    skipFirst = false;
                }
                if (available) {
                    ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
                    if (!skipFirst) {
                        ingredients.add(recipe.getTopOptional());
                    }
                    ingredients.add(recipe.getMiddleInput());
                    if (!recipe.getBottomOptional().m_43947_()) {
                        ingredients.add(recipe.getBottomOptional());
                    }
                    ItemStack result = recipe.getResultItem();
                    if (hasPriority) {
                        graph.blockRecipe(this.transformRecipeId(recipe.m_6423_(), false));
                    }
                    graph.addRecipe(this.transformRecipeId(recipe.m_6423_(), skipFirst), ingredients, ingredients.stream().map(Ingredient::m_43908_).map(items -> Arrays.stream(items).findFirst().map(ItemStack::m_41613_).orElse(0)).toList(), result, items -> {
                        ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                        int id = 0;
                        if (!skipFirst) {
                            steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of((ItemStack)items.get(id++)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
                        }
                        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.WEST), List.of((ItemStack)items.get(id++)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
                        if (id < items.size()) {
                            steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.DOWN), List.of((ItemStack)items.get(id++)), List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
                        }
                        steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of(), List.of(result), CommonTakeItemAction.TYPE, false, new CompoundTag()));
                        if (!skipFirst && recipe.getProcessType() == InscriberProcessType.INSCRIBE) {
                            steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos, Direction.UP), List.of(), List.of((ItemStack)items.get(0)), CommonTakeItemAction.TYPE, false, new CompoundTag()));
                        }
                        return new CraftGuideData(steps, CommonType.TYPE);
                    });
                }
            });
        }
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(InscriberRecipe.TYPE).forEach(recipe -> {
            if (recipe.getProcessType() == InscriberProcessType.INSCRIBE && !recipe.getTopOptional().m_43947_()) {
                ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
                ingredients.add(recipe.getMiddleInput());
                if (!recipe.getBottomOptional().m_43947_()) {
                    ingredients.add(recipe.getBottomOptional());
                }
                RecipeIngredientCache.addRecipeCache(this.transformRecipeId(recipe.m_6423_(), true), ingredients);
            }
            ArrayList<Ingredient> ingredientsFull = new ArrayList<Ingredient>();
            if (!recipe.getTopOptional().m_43947_()) {
                ingredientsFull.add(recipe.getTopOptional());
            }
            ingredientsFull.add(recipe.getMiddleInput());
            if (!recipe.getBottomOptional().m_43947_()) {
                ingredientsFull.add(recipe.getBottomOptional());
            }
            RecipeIngredientCache.addRecipeCache(this.transformRecipeId(recipe.m_6423_(), false), ingredientsFull);
        });
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.ae2.inscriber");
    }
}

