/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.ae2;

import appeng.core.definitions.AEBlocks;
import appeng.recipes.handlers.ChargerRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPlaceItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonTakeItemAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateCondition;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.ItemHandler.ItemHandlerStorage;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.util.StorageAccessUtil;

public class GeneratorAE2Charger
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return new ResourceLocation("ae2", "charger");
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60713_(AEBlocks.CHARGER.block());
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        StorageAccessUtil.Filter posFilter = GenerateCondition.getFilterOn(level, pos);
        level.m_7465_().m_44013_(ChargerRecipe.TYPE).forEach(recipe -> {
            if (!posFilter.isAvailable(recipe.getResultItem())) {
                return;
            }
            graph.addRecipe((Recipe<?>)recipe, items -> {
                ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), (List<ItemStack>)items, List.of(), CommonPlaceItemAction.TYPE, false, new CompoundTag()));
                steps.add(new CraftGuideStepData(new Target(ItemHandlerStorage.TYPE, pos), List.of(), List.of(recipe.getResultItem()), CommonTakeItemAction.TYPE, false, new CompoundTag()));
                return new CraftGuideData(steps, CommonType.TYPE);
            });
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(ChargerRecipe.TYPE).forEach(RecipeIngredientCache::addRecipeCache);
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.ae2.charger");
    }
}

