/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.special;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import studio.fantasyit.maid_storage_manager.craft.WorkBlockTags;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class StoneCuttingRecipeAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "stone_cutting");

    public StoneCuttingRecipeAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        if (this.craftGuideStepData.getStorage() == null) {
            return AbstractCraftActionContext.Result.FAIL;
        }
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        ItemStack tmpResult;
        ItemStack result;
        List<StonecutterRecipe> stonecuttingRecipe;
        Optional<StonecutterRecipe> first;
        Level level = this.maid.m_9236_();
        if (!level.m_8055_(this.craftGuideStepData.storage.pos).m_204336_(WorkBlockTags.STONE_CUTTER)) {
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        CombinedInvWrapper inv = this.maid.getAvailableInv(false);
        ItemStack input = this.craftGuideStepData.getInput().get(0);
        ItemStack output = this.craftGuideStepData.getOutput().get(0);
        ItemStack t1 = InvUtil.tryExtractForCrafting((IItemHandler)inv, input);
        if (ItemStackUtil.isSameInCrafting(t1, input) && (first = (stonecuttingRecipe = RecipeUtil.getStonecuttingRecipe(level, t1)).stream().filter(recipe -> ItemStackUtil.isSameInCrafting(recipe.m_8043_(level.m_9598_()), output)).findFirst()).isPresent() && ItemStackUtil.isSameInCrafting(result = (tmpResult = first.get().m_8043_(level.m_9598_())).m_255036_(tmpResult.m_41613_() * input.m_41613_()), output)) {
            this.craftLayer.addCurrentStepPlacedCounts(0, result.m_41613_());
            int maxCanPlace = InvUtil.maxCanPlace((IItemHandler)inv, result);
            if (maxCanPlace >= result.m_41613_()) {
                InvUtil.tryPlace((IItemHandler)inv, result);
                level.m_5594_(null, this.craftGuideStepData.storage.pos, SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return AbstractCraftActionContext.Result.SUCCESS;
            }
        }
        InvUtil.tryPlace((IItemHandler)inv, t1);
        return AbstractCraftActionContext.Result.FAIL;
    }

    @Override
    public void stop() {
    }
}

