/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.context.common;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.context.AbstractCraftActionContext;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class CommonPickupItemAction
extends AbstractCraftActionContext {
    public static final ResourceLocation TYPE = new ResourceLocation("maid_storage_manager", "pickup");
    int ingredientIndex = 0;
    List<ItemStack> ingredients;
    List<Entity> entities;

    public CommonPickupItemAction(EntityMaid maid, CraftGuideData craftGuideData, CraftGuideStepData craftGuideStepData, CraftLayer layer) {
        super(maid, craftGuideData, craftGuideStepData, layer);
    }

    @Override
    public void loadEnv(CompoundTag env) {
        this.ingredientIndex = env.m_128441_("ingredientIndex") ? env.m_128451_("ingredientIndex") : 0;
    }

    @Override
    public CompoundTag saveEnv(CompoundTag env) {
        env.m_128405_("ingredientIndex", this.ingredientIndex);
        return super.saveEnv(env);
    }

    @Override
    public AbstractCraftActionContext.Result start() {
        this.ingredients = this.craftGuideStepData.getNonEmptyOutput();
        if (this.ingredients.isEmpty()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        this.entities = null;
        return AbstractCraftActionContext.Result.CONTINUE;
    }

    @Override
    public AbstractCraftActionContext.Result tick() {
        if (this.allDone()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        ItemStack current = this.ingredients.get(this.ingredientIndex);
        int hasTaken = this.craftLayer.getCurrentStepCount(this.ingredientIndex);
        if (hasTaken >= current.m_41613_()) {
            ++this.ingredientIndex;
            if (this.ingredientIndex >= this.ingredients.size()) {
                this.ingredientIndex %= this.ingredients.size();
                return AbstractCraftActionContext.Result.NOT_DONE_INTERRUPTABLE;
            }
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        if (this.entities == null) {
            this.entities = this.maid.m_9236_().m_6249_((Entity)this.maid, this.maid.m_20191_().m_82400_(2.8), e -> {
                ItemEntity ie;
                return e instanceof ItemEntity && EntityMaid.canInsertItem((ItemStack)(ie = (ItemEntity)e).m_32055_()) && (!ie.m_32063_() || Config.pickupIgnoreDelay);
            });
        }
        for (Entity entity : this.entities) {
            ItemEntity ie;
            if (!entity.m_6084_() || !(entity instanceof ItemEntity) || !ItemStackUtil.isSameInCrafting((ie = (ItemEntity)entity).m_32055_(), current)) continue;
            int toTakeCount = Math.min(ie.m_32055_().m_41613_(), current.m_41613_() - hasTaken);
            ItemStack notPlaced = InvUtil.tryPlace((IItemHandler)this.maid.getAvailableInv(false), ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)toTakeCount));
            int realTake = toTakeCount - notPlaced.m_41613_();
            int realRemain = ie.m_32055_().m_41613_() - realTake;
            if (realTake != 0) {
                this.craftLayer.addCurrentStepPlacedCounts(this.ingredientIndex, realTake);
                this.maid.m_7938_((Entity)ie, toTakeCount - notPlaced.m_41613_());
                if (realRemain == 0) {
                    ie.m_146870_();
                } else {
                    ie.m_32045_(ie.m_32055_().m_255036_(realRemain));
                }
                if (current.m_41613_() <= hasTaken + realTake) {
                    ++this.ingredientIndex;
                    this.ingredientIndex %= this.ingredients.size();
                }
                return AbstractCraftActionContext.Result.CONTINUE;
            }
            return AbstractCraftActionContext.Result.NOT_DONE;
        }
        this.entities = null;
        ++this.ingredientIndex;
        if (this.ingredientIndex >= this.ingredients.size() && this.craftGuideStepData.isOptional()) {
            return AbstractCraftActionContext.Result.SUCCESS;
        }
        if (this.ingredientIndex >= this.ingredients.size()) {
            this.ingredientIndex %= this.ingredients.size();
            return AbstractCraftActionContext.Result.NOT_DONE_INTERRUPTABLE;
        }
        return AbstractCraftActionContext.Result.NOT_DONE;
    }

    @Override
    public void stop() {
    }

    private boolean allDone() {
        if (this.craftGuideStepData == null) {
            return false;
        }
        List<ItemStack> items = this.craftGuideStepData.getOutput();
        for (int i = 0; i < items.size(); ++i) {
            if (this.craftLayer.getCurrentStepCount(i) >= items.get(i).m_41613_()) continue;
            return false;
        }
        return true;
    }
}

