/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.misc;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;

public class StronglyConnected {
    private final AbstractBiCraftGraph graph;
    private final int[] dfn;
    private final int[] low;
    private int dfncnt = 0;
    private final Stack<AbstractBiCraftGraph.Node> stack = new Stack();
    private final Set<Integer> inStack = new HashSet<Integer>();
    private int sccId;

    public StronglyConnected(AbstractBiCraftGraph graph) {
        this.graph = graph;
        this.dfn = new int[graph.getNodeCount()];
        this.low = new int[graph.getNodeCount()];
        this.dfncnt = 0;
        this.sccId = 0;
    }

    public void process() {
        for (int i = 0; i < this.graph.getNodeCount(); ++i) {
            AbstractBiCraftGraph.Node node = this.graph.getNode(i);
            if (this.dfn[node.id] != 0) continue;
            this.tarjan(node);
        }
    }

    public void tarjan(AbstractBiCraftGraph.Node node) {
        this.low[node.id] = ++this.dfncnt;
        this.dfn[node.id] = this.dfncnt;
        this.stack.push(node);
        this.inStack.add(node.id);
        for (Pair<Integer, Integer> to : node.edges) {
            if (this.dfn[(Integer)to.getA()] == 0) {
                this.tarjan(this.graph.getNode((Integer)to.getA()));
                this.low[node.id] = Math.min(this.low[node.id], this.low[(Integer)to.getA()]);
                continue;
            }
            if (!this.inStack.contains(to.getA())) continue;
            this.low[node.id] = Math.min(this.low[node.id], this.dfn[(Integer)to.getA()]);
        }
        if (this.low[node.id] == this.dfn[node.id]) {
            AbstractBiCraftGraph.Node tNode;
            ++this.sccId;
            do {
                tNode = this.stack.pop();
                tNode.sccId = this.sccId;
                this.inStack.remove(tNode.id);
            } while (tNode.id != node.id);
        }
    }

    public int maxSccId() {
        return this.sccId;
    }
}

