/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.misc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Logger;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.StronglyConnected;

public class PrefilterByChunk {
    private final StronglyConnected tarjon;
    private final AbstractBiCraftGraph graph;
    private int[] sccTotalInputs;
    private List<Integer>[] sccToOtherSccs;

    public PrefilterByChunk(AbstractBiCraftGraph graph) {
        this.tarjon = new StronglyConnected(graph);
        this.graph = graph;
    }

    public void process() {
        int i;
        this.tarjon.process();
        this.sccTotalInputs = new int[this.tarjon.maxSccId() + 1];
        this.sccToOtherSccs = new List[this.tarjon.maxSccId() + 1];
        boolean[] sccNotVisitable = new boolean[this.tarjon.maxSccId() + 1];
        for (i = 0; i < this.sccToOtherSccs.length; ++i) {
            this.sccToOtherSccs[i] = new ArrayList<Integer>();
        }
        for (i = 0; i < this.graph.getNodeCount(); ++i) {
            AbstractBiCraftGraph.Node node = this.graph.getNode(i);
            if (node instanceof AbstractBiCraftGraph.ItemNode) {
                Iterator<Integer> in = (AbstractBiCraftGraph.ItemNode)node;
                int n = ((AbstractBiCraftGraph.ItemNode)((Object)in)).sccId;
                this.sccTotalInputs[n] = this.sccTotalInputs[n] + ((AbstractBiCraftGraph.ItemNode)((Object)in)).count;
            }
            for (Pair pair : node.edges) {
                if (node.sccId == this.graph.getNode((int)((Integer)pair.getA()).intValue()).sccId) continue;
                this.sccToOtherSccs[node.sccId].add(this.graph.getNode((int)((Integer)pair.getA()).intValue()).sccId);
            }
        }
        LinkedList<Integer> queue = new LinkedList<Integer>();
        for (int i2 = 0; i2 < this.sccTotalInputs.length; ++i2) {
            if (this.sccTotalInputs[i2] != 0 || !this.sccToOtherSccs[i2].isEmpty()) continue;
            queue.add(i2);
        }
        while (!queue.isEmpty()) {
            int tSccId = (Integer)queue.poll();
            sccNotVisitable[tSccId] = true;
            for (int n : this.sccToOtherSccs[tSccId]) {
                if (!this.sccToOtherSccs[n].stream().allMatch(sccId -> sccNotVisitable[sccId])) continue;
                queue.add(n);
            }
        }
        int count = 0;
        for (int i3 = 0; i3 < this.graph.getNodeCount(); ++i3) {
            AbstractBiCraftGraph.Node node = this.graph.getNode(i3);
            if (!sccNotVisitable[node.sccId]) continue;
            node.maxSuccess = 0;
            ++count;
        }
        Logger.debug("%s nodes are not visitable", count);
    }
}

