/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.graph;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.CraftResultNode;
import studio.fantasyit.maid_storage_manager.craft.algo.base.HistoryAndResultGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.VisitRecorder;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.CraftPlanEvaluator;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;

public class FlattenSearchGraph
extends HistoryAndResultGraph {
    Integer retVal = null;
    final Stack<Object> layers = new Stack();
    private Object lastLayer;
    private int speed = 90;
    private boolean waitInit = false;

    public FlattenSearchGraph(List<Pair<ItemStack, Integer>> items, List<CraftGuideData> craftGuides) {
        super(items, craftGuides);
    }

    private void setReturnValue(int value) {
        this.retVal = value;
        if (!this.layers.isEmpty()) {
            this.lastLayer = this.layers.pop();
        }
    }

    private void dfsItemPre(DfsLayerItem context) {
        AbstractBiCraftGraph.ItemNode node = context.node;
        if (!node.listed) {
            node.listed = true;
            this.listed.add(node);
        }
        int maxRequire = context.maxRequire;
        int stepCount = context.stepCount;
        this.logger.log("Item use available: %d", node.getCurrentRemain());
        if (node.getCurrentRemain() >= maxRequire) {
            if (!node.isLoopedIngredient || node.hasKeepIngredient || node.loopInputIngredientCount == 0) {
                this.pushHistory(node, 1, maxRequire);
                this.setReturnValue(maxRequire);
                return;
            }
            if (node.getCurrentRemain() - node.loopInputIngredientCount >= maxRequire) {
                this.pushHistory(node, 1, maxRequire);
                this.setReturnValue(maxRequire);
                return;
            }
        }
        if (node.edges.isEmpty()) {
            int alignedRequire = node.getCurrentRemain() / stepCount * stepCount;
            this.pushHistory(node, 1, alignedRequire);
            if (maxRequire > alignedRequire) {
                node.maxLack = Math.max(node.maxLack, maxRequire - alignedRequire);
            }
            this.setReturnValue(alignedRequire);
            return;
        }
        if (maxRequire >= ((VisitRecorder)context.visit().getValue()).minStepRequire(node)) {
            int alignedRequire = node.getCurrentRemain() / stepCount * stepCount;
            this.pushHistory(node, 1, alignedRequire);
            if (maxRequire > alignedRequire) {
                node.maxLack = Math.max(node.maxLack, maxRequire - alignedRequire);
            }
            node.clearMaxSuccessAfter = true;
            this.setReturnValue(alignedRequire);
            return;
        }
        if (this.addInStack(node) > this.maxDepthAllow) {
            int alignedRequire = node.getCurrentRemain() / stepCount * stepCount;
            this.pushHistory(node, 1, alignedRequire);
            if (maxRequire > alignedRequire) {
                node.maxLack = Math.max(node.maxLack, maxRequire - alignedRequire);
            }
            this.setReturnValue(alignedRequire);
            return;
        }
        int stepCost = node.getCurrentRemain();
        int oMaxRequire = maxRequire;
        int tNodeMinRequire = ((VisitRecorder)context.visit().getValue()).minStepRequire(node);
        boolean tKeepIngredient = node.hasKeepIngredient;
        boolean keepCurrently = false;
        if (!node.hasKeepIngredient && node.loopInputIngredientCount > 0) {
            maxRequire += node.loopInputIngredientCount;
            node.hasKeepIngredient = true;
            this.logger.log("Add keep loop use %s : %d", node.itemStack, node.loopInputIngredientCount);
            keepCurrently = true;
            context.visit().setValue((Object)new VisitRecorder(this.getNodeCount()));
        }
        if (node.loopInputIngredientCount > 0 && (stepCost -= node.loopInputIngredientCount) < 0) {
            stepCost = 0;
        }
        ((VisitRecorder)context.visit().getValue()).minStepRequire(node, maxRequire);
        context.remainToCraft.setValue(maxRequire - stepCost);
        this.logger.log("Item %s use -= %d", node.itemStack, stepCost);
        this.pushHistory(node, 1, stepCost);
        context.oMaxRequire.setValue(oMaxRequire);
        context.tNodeMinRequire.setValue(tNodeMinRequire);
        context.tKeepIngredient.setValue(tKeepIngredient);
        context.keepCurrently.setValue(keepCurrently);
        context.realMaxRequire.setValue(maxRequire);
        this.dfsStartAtAdd(node, (VisitRecorder)context.visit.getValue(), maxRequire);
    }

    private void dfsItemStartAtReturn(DfsLayerItem context, int startAt) {
        context.startAt.setValue(startAt);
    }

    private void dfsItemLoopCall(DfsLayerItem context) {
        int i = context.i.getValue();
        AbstractBiCraftGraph.ItemNode node = context.node;
        MutableInt remainToCraft = context.remainToCraft;
        int to = (Integer)((Pair)node.edges.get(i)).getA();
        int weight = (Integer)((Pair)node.edges.get(i)).getB();
        AbstractBiCraftGraph.CraftNode toNode = (AbstractBiCraftGraph.CraftNode)this.getNode(to);
        int maxRequiredForCurrentCraftNode = (remainToCraft.getValue() + weight - 1) / weight;
        if (toNode.hasLoopIngredient) {
            maxRequiredForCurrentCraftNode = Math.min((node.singleTimeCount + weight - 1) / weight, maxRequiredForCurrentCraftNode);
        }
        this.logger.logEntryNewLevel("Craft[%d] * %d", toNode.id, maxRequiredForCurrentCraftNode);
        this.dfsCraftAdd(toNode, maxRequiredForCurrentCraftNode, (VisitRecorder)context.visit.getValue(), context.estimating);
    }

    private void dfsItemLoopReturn(DfsLayerItem context, int available) {
        AbstractBiCraftGraph.ItemNode node = context.node;
        int i = (context.i.getValue() + context.startAt.getValue()) % node.edges.size();
        int weight = (Integer)((Pair)node.edges.get(i)).getB();
        this.logger.logExitLevel("Craft Finish=%d", available);
        int collect = Math.min(available * weight, context.remainToCraft.getValue());
        if (available > 0) {
            if (context.keepCurrently.getValue().booleanValue()) {
                collect = Math.min(node.getCurrentRemain() - node.loopInputIngredientCount, collect);
                if (collect < 0) {
                    collect = 0;
                }
                this.logger.log("Item keep loop toTake=%d in totalSuccess=%d", collect, available * weight);
            }
            this.logger.log("Item use -= %d", collect);
            this.pushHistory(node, 1, collect);
        } else {
            context.i.add(1);
        }
        context.remainToCraft.subtract(collect);
        if (context.remainToCraft.getValue() <= 0) {
            context.remainToCraft.setValue(0);
        }
        if (context.i.getValue() >= node.edges.size() || context.remainToCraft.getValue() <= 0) {
            ((VisitRecorder)context.visit().getValue()).minStepRequire(node, (int)context.tNodeMinRequire.getValue());
            node.hasKeepIngredient = context.tKeepIngredient.getValue();
            node.maxLack = Math.max(node.maxLack, context.remainToCraft.getValue());
            int crafted = context.realMaxRequire.getValue() - context.remainToCraft.getValue();
            if (context.keepCurrently.getValue().booleanValue() && crafted > context.oMaxRequire.getValue()) {
                this.logger.log("Item exceed += %d", crafted - context.oMaxRequire.getValue());
                this.pushHistory(node, 0, crafted - context.oMaxRequire.getValue());
            }
            if (context.remainToCraft.getValue() > 0) {
                node.maxSuccess = context.oMaxRequire.getValue() - context.remainToCraft.getValue();
                if (node.maxSuccess == node.lastMaxSuccess) {
                    ++node.maxSuccessCount;
                } else {
                    node.lastMaxSuccess = node.maxSuccess;
                    node.maxSuccessCount = 1;
                }
            }
            if (node.clearMaxSuccessAfter) {
                this.removeListedUntil(node);
                node.clearMaxSuccessAfter = false;
            }
            this.removeInStack(node);
            this.setReturnValue(Math.max(context.oMaxRequire.getValue() - context.remainToCraft.getValue(), 0));
        }
    }

    public void dfsItemAdd(AbstractBiCraftGraph.ItemNode node, int maxRequire, int stepCount, VisitRecorder visit, boolean estimating) {
        DfsLayerItem push = (DfsLayerItem)this.layers.push(new DfsLayerItem(node, maxRequire, stepCount, estimating, new MutableInt(), new MutableInt(maxRequire), new MutableInt(), new MutableInt(), new MutableInt(), new MutableBoolean(), new MutableBoolean(), new MutableInt(-1), (MutableObject<VisitRecorder>)new MutableObject((Object)visit)));
        this.dfsItemPre(push);
    }

    public void dfsStartAtAdd(AbstractBiCraftGraph.ItemNode node, VisitRecorder visit, int maxRequire) {
        this.layers.add(new DfsLayerStartAt(node, maxRequire, new MutableInt(0), this.historyId.getValue(), this.results.size(), new MutableInt(0), new MutableInt(Integer.MAX_VALUE), new MutableInt(0), new MutableInt(0), (MutableObject<VisitRecorder>)new MutableObject((Object)visit)));
        if (Config.craftingShortestPathEvaluator == CraftPlanEvaluator.NONE) {
            this.setReturnValue(0);
        } else if (node.bestRecipeStartAt != -1) {
            this.setReturnValue(node.bestRecipeStartAt);
        } else if (node.bestRecipeStartAtCalculating) {
            node.clearMaxSuccessAfter = true;
            this.setReturnValue(0);
        } else if (node.edges.size() <= 1) {
            this.setReturnValue(0);
        } else {
            node.bestRecipeStartAtCalculating = true;
            if (!node.listed) {
                node.listed = true;
                this.listed.add(node);
            }
        }
    }

    public void dfsStartAtCall(DfsLayerStartAt context) {
        while (context.i.getValue() < context.node.edges.size() && context.node.bestRecipeStartAt != -1 && context.i.getValue() != context.node.bestRecipeStartAt) {
            context.i.add(1);
        }
        if (context.i.getValue() >= context.node.edges.size()) {
            context.node.bestRecipeStartAt = context.startAt.getValue();
            context.node.bestRecipeStartAtCalculating = false;
            this.setReturnValue(context.startAt.getValue());
            if (context.node.clearMaxSuccessAfter) {
                this.removeListedUntil(context.node);
                context.node.clearMaxSuccessAfter = false;
            }
            return;
        }
        int to = (Integer)((Pair)context.node.edges.get(context.i.getValue())).getA();
        int weight = (Integer)((Pair)context.node.edges.get(context.i.getValue())).getB();
        AbstractBiCraftGraph.CraftNode toNode = (AbstractBiCraftGraph.CraftNode)this.getNode(to);
        int maxRequiredForCurrentCraftNode = (context.maxRequire + weight - 1) / weight;
        if (toNode.hasLoopIngredient) {
            maxRequiredForCurrentCraftNode = (context.node.singleTimeCount + weight - 1) / weight;
        }
        this.logger.logEntryNewLevel("Craft[%d] * %d", toNode.id, maxRequiredForCurrentCraftNode);
        context.maxRequiredForCurrentCraftNode.setValue(maxRequiredForCurrentCraftNode);
        this.dfsCraftAdd(toNode, maxRequiredForCurrentCraftNode, (VisitRecorder)context.visit().getValue(), true);
    }

    public void dfsStartAtRet(DfsLayerStartAt context, int available) {
        int weight = (Integer)((Pair)context.node.edges.get(context.i.getValue())).getB();
        this.logger.logExitLevel("Craft Finish=%d", available);
        if (context.node.isLoopedIngredient && available == context.maxRequiredForCurrentCraftNode.getValue()) {
            available = context.maxRequiredForCurrentCraftNode.getValue();
        }
        int collect = Math.min(available * weight, context.maxRequire);
        Map<Integer, Integer> changeMap = this.popHistoryAtAndCollectChanges(context.historyId);
        ArrayList<CraftResultNode> addResults = new ArrayList<CraftResultNode>();
        while (context.resultId < this.results.size()) {
            addResults.add((CraftResultNode)this.results.removeLast());
        }
        int score = Config.craftingShortestPathEvaluator.getScore(changeMap, addResults, this);
        if (collect > context.maxCollected.getValue() || collect == context.maxCollected.getValue() && score < context.minScore.getValue()) {
            context.maxCollected.setValue(collect);
            context.minScore.setValue(score);
            context.startAt.setValue((Number)context.i.getValue());
        }
        this.popHistoryAt(context.historyId);
        while (context.resultId < this.results.size()) {
            this.results.removeLast();
        }
        context.i.add(1);
    }

    public void dfsCraftAdd(AbstractBiCraftGraph.CraftNode toNode, int maxRequiredForCurrentCraftNode, VisitRecorder visit, boolean estimating) {
        DfsLayerCraft push = (DfsLayerCraft)this.layers.push(new DfsLayerCraft(toNode, maxRequiredForCurrentCraftNode, estimating, new MutableInt(maxRequiredForCurrentCraftNode), new MutableInt(), new MutableInt(maxRequiredForCurrentCraftNode), new MutableInt(toNode.edges.size()), new MutableInt(), new MutableInt(), new MutableBoolean(), (MutableObject<VisitRecorder>)new MutableObject((Object)visit)));
        if (this.addInStack(push.node) > this.maxDepthAllow) {
            this.removeInStack(push.node);
            this.setReturnValue(0);
        }
        if (this.results.size() >= Config.craftingMaxLayerLimit) {
            this.removeInStack(push.node);
            this.setReturnValue(0);
        }
        if (push.node.maxSuccess < push.restRequire.getValue()) {
            push.restRequire.setValue(push.node.maxSuccess);
            push.simulateRequire.setValue(push.node.maxSuccess);
            if (push.node.hasLoopIngredient) {
                push.simulateRequire.setValue(1);
            }
        }
        if (push.node.edges.isEmpty()) {
            push.totalSuccess.setValue(push.maxRequire);
            push.simulateRequire.setValue(0);
            push.restRequire.setValue(0);
        } else {
            for (Pair toNodePair : push.node.edges) {
                AbstractBiCraftGraph.Node toNode1 = this.getNode((Integer)toNodePair.getA());
                if (push.simulateRequire.getValue() * (Integer)toNodePair.getB() <= toNode1.maxSuccess) continue;
                push.simulateRequire.setValue(toNode1.maxSuccess / (Integer)toNodePair.getB());
            }
        }
    }

    public void dfsCraftCall(DfsLayerCraft context) {
        if (context.simulateRequire.getValue() <= 0) {
            this.dfsCraftSetReturn(context);
            return;
        }
        if (context.i.getValue() >= context.node.edges.size()) {
            context.historyId.setValue((Number)this.historyId.getValue());
            context.resultId.setValue(this.results.size());
            context.anyFail.setFalse();
            context.i.setValue(0);
        }
        Pair edge = (Pair)context.node.edges.get(context.i.getValue());
        AbstractBiCraftGraph.ItemNode toNode = (AbstractBiCraftGraph.ItemNode)this.getNode((Integer)edge.getA());
        this.logger.logEntryNewLevel("Item %s * %d", toNode.itemStack, context.simulateRequire.getValue() * (Integer)edge.getB());
        this.dfsItemAdd(toNode, context.simulateRequire.getValue() * (Integer)edge.getB(), (Integer)edge.getB(), (VisitRecorder)context.visit.getValue(), context.estimating);
    }

    public void dfsCraftRet(DfsLayerCraft context, int currentRequire) {
        Pair edge = (Pair)context.node.edges.get(context.i.getValue());
        this.logger.log("Item Finish=%d", currentRequire);
        this.logger.logExitLevel("Co Craft Finish=%d", currentRequire /= ((Integer)edge.getB()).intValue());
        if (currentRequire < context.simulateRequire.getValue()) {
            context.simulateRequire.setValue(currentRequire);
            this.popHistoryAt(context.historyId.getValue());
            while (context.resultId.getValue() < this.results.size()) {
                this.results.removeLast();
            }
            context.anyFail.setTrue();
            context.i.setValue(context.node.edges.size());
        } else {
            context.i.add(1);
        }
        if (context.i.getValue() >= context.node.edges.size() && !context.anyFail.getValue().booleanValue()) {
            this.logger.log("Craft add %d", context.simulateRequire.getValue());
            context.totalSuccess.add((Number)context.simulateRequire.getValue());
            context.restRequire.subtract((Number)context.simulateRequire.getValue());
            context.simulateRequire.setValue((Number)context.restRequire.getValue());
            if (context.node.hasLoopIngredient && context.restRequire.getValue() > 0) {
                context.simulateRequire.setValue(1);
            }
        }
    }

    public void dfsCraftSetReturn(DfsLayerCraft context) {
        Integer totalSuccess = context.totalSuccess.getValue();
        if (totalSuccess > 0) {
            this.logger.log("Craft finally success %d", totalSuccess);
            this.results.addLast(new CraftResultNode(context.node.id, totalSuccess, true));
            for (Pair to : context.node.revEdges) {
                AbstractBiCraftGraph.ItemNode cn = (AbstractBiCraftGraph.ItemNode)this.getNode((Integer)to.getA());
                this.logger.log("Item %s crafted += %d", cn.itemStack, (Integer)to.getB() * totalSuccess);
                this.pushHistory(cn, 0, (Integer)to.getB() * totalSuccess);
            }
        }
        this.pushHistory(context.node, 2, totalSuccess);
        if (totalSuccess < context.maxRequire) {
            context.node.maxSuccess = totalSuccess;
            if (context.node.maxSuccess == context.node.lastMaxSuccess) {
                ++context.node.maxSuccessCount;
            } else {
                context.node.lastMaxSuccess = context.node.maxSuccess;
                context.node.maxSuccessCount = 1;
            }
        }
        this.removeInStack(context.node);
        this.setReturnValue(totalSuccess);
    }

    @Override
    public void startContext(ItemStack item, int count) {
        super.startContext(item, count);
        this.layers.clear();
        this.waitInit = true;
        this.retVal = null;
    }

    @Override
    public void setSpeed(int i) {
        this.speed = i * 5;
    }

    public int copyGetRetValue() {
        int retVal = this.retVal;
        this.retVal = null;
        return retVal;
    }

    @Override
    public boolean process() {
        if (this.waitInit) {
            this.waitInit = false;
            this.dfsItemAdd(this.getItemNodeOrCreate(this.targetItem), this.targetCount, 1, new VisitRecorder(this.getNodeCount()), false);
        }
        for (int count = 0; !this.layers.isEmpty() && count < this.speed; ++count) {
            Object top = this.layers.peek();
            if (top instanceof DfsLayerItem) {
                DfsLayerItem item = (DfsLayerItem)top;
                if (this.retVal != null) {
                    if (this.lastLayer instanceof DfsLayerStartAt) {
                        this.dfsItemStartAtReturn(item, this.copyGetRetValue());
                        continue;
                    }
                    this.dfsItemLoopReturn(item, this.copyGetRetValue());
                    continue;
                }
                this.dfsItemLoopCall(item);
                continue;
            }
            if (!(top instanceof DfsLayerCraft)) continue;
            DfsLayerCraft craft = (DfsLayerCraft)top;
            if (this.retVal != null) {
                this.dfsCraftRet(craft, this.copyGetRetValue());
                continue;
            }
            this.dfsCraftCall(craft);
        }
        if (this.layers.isEmpty() && this.retVal != null) {
            this.targetAvailable = this.retVal;
        }
        return this.layers.isEmpty();
    }

    record DfsLayerItem(AbstractBiCraftGraph.ItemNode node, int maxRequire, int stepCount, boolean estimating, MutableInt i, MutableInt realMaxRequire, MutableInt remainToCraft, MutableInt oMaxRequire, MutableInt tNodeMinRequire, MutableBoolean tKeepIngredient, MutableBoolean keepCurrently, MutableInt startAt, MutableObject<VisitRecorder> visit) {
    }

    record DfsLayerStartAt(AbstractBiCraftGraph.ItemNode node, int maxRequire, MutableInt i, Integer historyId, int resultId, MutableInt maxCollected, MutableInt minScore, MutableInt startAt, MutableInt maxRequiredForCurrentCraftNode, MutableObject<VisitRecorder> visit) {
    }

    record DfsLayerCraft(AbstractBiCraftGraph.CraftNode node, int maxRequire, boolean estimating, MutableInt simulateRequire, MutableInt totalSuccess, MutableInt restRequire, MutableInt i, MutableInt historyId, MutableInt resultId, MutableBoolean anyFail, MutableObject<VisitRecorder> visit) {
    }
}

