/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.algo.base;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import oshi.util.tuples.Pair;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.algo.base.CraftResultNode;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.CraftPlanEvaluator;
import studio.fantasyit.maid_storage_manager.craft.algo.misc.LevelBasedLogger;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.work.CraftLayer;

public abstract class HistoryAndResultGraph
extends AbstractBiCraftGraph {
    public MutableInt historyId = new MutableInt();
    protected Deque<CraftResultNode> results = new LinkedList<CraftResultNode>();
    protected LevelBasedLogger logger = new LevelBasedLogger();
    protected ItemStack targetItem;
    protected int targetCount;
    protected int targetAvailable = -1;
    public Stack<HistoryRecord> history = new Stack();

    public HistoryAndResultGraph(List<Pair<ItemStack, Integer>> items, List<CraftGuideData> craftGuides) {
        super(items, craftGuides);
    }

    public void pushHistory(AbstractBiCraftGraph.Node node, int id, int value) {
        if (value == 0) {
            return;
        }
        this.history.push(new HistoryRecord(this.historyId.addAndGet(1), node, id, value));
        switch (id) {
            case 0: {
                ((AbstractBiCraftGraph.ItemNode)node).crafted += value;
                break;
            }
            case 1: {
                ((AbstractBiCraftGraph.ItemNode)node).required += value;
                break;
            }
            case 2: {
                ((AbstractBiCraftGraph.CraftNode)node).scheduled += value;
            }
        }
    }

    public void popHistoryAt(int index) {
        while (!this.history.isEmpty() && this.history.peek().historyStackId > index) {
            HistoryRecord pop = this.history.pop();
            switch (pop.id) {
                case 0: {
                    ((AbstractBiCraftGraph.ItemNode)pop.node).crafted -= pop.value;
                    break;
                }
                case 1: {
                    ((AbstractBiCraftGraph.ItemNode)pop.node).required -= pop.value;
                    break;
                }
                case 2: {
                    ((AbstractBiCraftGraph.CraftNode)pop.node).scheduled -= pop.value;
                }
            }
        }
    }

    public Map<Integer, Integer> popHistoryAtAndCollectChanges(int index) {
        HashMap<Integer, Integer> changes = new HashMap<Integer, Integer>();
        while (!this.history.isEmpty() && this.history.peek().historyStackId > index) {
            HistoryRecord pop = this.history.pop();
            if (!changes.containsKey(pop.node.id)) {
                changes.put(pop.node.id, 0);
            }
            changes.put(pop.node.id, (Integer)changes.get(pop.node.id) - pop.value);
            switch (pop.id) {
                case 0: {
                    ((AbstractBiCraftGraph.ItemNode)pop.node).crafted -= pop.value;
                    break;
                }
                case 1: {
                    ((AbstractBiCraftGraph.ItemNode)pop.node).required -= pop.value;
                    break;
                }
                case 2: {
                    ((AbstractBiCraftGraph.CraftNode)pop.node).scheduled -= pop.value;
                }
            }
        }
        return changes;
    }

    @Override
    public void startContext(ItemStack item, int count) {
        super.startContext(item, count);
        this.history.clear();
        this.historyId.setValue(0);
        this.targetItem = item;
        this.targetCount = count;
        this.results.clear();
        this.targetAvailable = -1;
    }

    @Override
    public List<CraftLayer> getResults() {
        if (this.targetAvailable == 0) {
            return List.of();
        }
        if (this.results.isEmpty()) {
            return List.of();
        }
        ArrayList<CraftLayer> results = new ArrayList<CraftLayer>();
        CraftResultNode lastOne = this.results.peekLast();
        while (!this.results.isEmpty()) {
            CraftResultNode resultNode = this.results.removeFirst();
            AbstractBiCraftGraph.CraftNode node = (AbstractBiCraftGraph.CraftNode)this.getNode(resultNode.index);
            ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
            Consumer<ItemStack> addWithCountMultiple = itemStack -> {
                if (itemStack.m_41619_()) {
                    return;
                }
                int count = resultNode.count * itemStack.m_41613_();
                for (ItemStack existing : itemStacks) {
                    if (!ItemStack.m_41656_((ItemStack)existing, (ItemStack)itemStack)) continue;
                    existing.m_41769_(count);
                    return;
                }
                itemStacks.add(itemStack.m_255036_(count));
            };
            node.craftGuideData.getAllInputItemsWithOptional().forEach(addWithCountMultiple);
            CraftLayer craftLayer = new CraftLayer(Optional.of(node.craftGuideData), itemStacks, resultNode.count);
            craftLayer.setUsableCraftData(node.sameData);
            results.add(craftLayer);
        }
        AbstractBiCraftGraph.CraftNode lastNode = (AbstractBiCraftGraph.CraftNode)this.getNode(lastOne.index);
        results.add(new CraftLayer(Optional.empty(), List.of(this.targetItem.m_255036_(this.targetAvailable)), lastNode.scheduled));
        return results;
    }

    @Override
    public List<Pair<ItemStack, Integer>> getFails() {
        return this.nodes.stream().filter(node -> node instanceof AbstractBiCraftGraph.ItemNode).map(node -> (AbstractBiCraftGraph.ItemNode)node).filter(node -> node.maxLack > 0).map(node -> new Pair((Object)node.itemStack, (Object)node.maxLack)).toList();
    }

    @Override
    public void setSpeed(int i) {
    }

    @Override
    public Optional<Integer> getMaxAvailable() {
        if (Config.craftingShortestPathEvaluator != CraftPlanEvaluator.NONE) {
            return Optional.empty();
        }
        if (this.targetAvailable == -1) {
            return super.getMaxAvailable();
        }
        return Optional.of(this.targetAvailable);
    }

    public record HistoryRecord(int historyStackId, AbstractBiCraftGraph.Node node, int id, int value) {
        public static final int RECORD_CRAFTED = 0;
        public static final int RECORD_REQUIRED = 1;
        public static final int RECORD_SCHEDULED = 2;
    }
}

