/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import java.util.Optional;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import studio.fantasyit.maid_storage_manager.Config;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.maid.data.StorageManagerConfigData;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.registry.MemoryModuleRegistry;
import studio.fantasyit.maid_storage_manager.util.InvUtil;
import studio.fantasyit.maid_storage_manager.util.MemoryUtil;

public class Conditions {
    public static boolean takingRequestList(EntityMaid maid) {
        if (MemoryUtil.getCrafting(maid).isSwappingHandWhenCrafting() && MemoryUtil.getCrafting(maid).hasPlan()) {
            return true;
        }
        if (!maid.m_21205_().m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        return !RequestListItem.isIgnored(maid.m_21205_()) && !RequestListItem.isCoolingDown(maid.m_21205_());
    }

    public static boolean inventoryNotFull(EntityMaid maid) {
        return InvUtil.hasAnyFree((IItemHandler)maid.getAvailableInv(false));
    }

    public static boolean inventoryFull(EntityMaid maid) {
        return !Conditions.inventoryNotFull(maid);
    }

    public static boolean hasStorageBlock(EntityMaid maid) {
        return RequestListItem.getStorageBlock(maid.m_21205_()) != null;
    }

    public static boolean listNotDone(EntityMaid maid) {
        if (RequestListItem.isBlackMode(maid.m_21205_())) {
            return !RequestListItem.isBlackModeDone(maid.m_21205_());
        }
        return RequestListItem.getItemStacksNotDone(maid.m_21205_()).size() != 0;
    }

    public static boolean listAllDone(EntityMaid maid) {
        return !Conditions.listNotDone(maid);
    }

    public static boolean listAllStored(EntityMaid maid) {
        if (RequestListItem.isBlackMode(maid.m_21205_())) {
            return false;
        }
        return RequestListItem.isAllStored(maid.m_21205_());
    }

    public static boolean hasReachedValidTargetOrReset(EntityMaid maid) {
        return Conditions.hasReachedValidTargetOrReset(maid, 2.0);
    }

    public static boolean hasReachedValidTargetOrReset(EntityMaid maid, double pathCloseEnoughThreshold) {
        Brain brain = maid.m_6274_();
        return brain.m_21952_((MemoryModuleType)InitEntities.TARGET_POS.get()).map(targetPos -> {
            boolean loosenArrive;
            Vec3 targetV3d = targetPos.m_7024_();
            boolean strictArrive = maid.m_20238_(targetV3d) < Math.pow(pathCloseEnoughThreshold, 2.0);
            boolean bl = loosenArrive = maid.m_20238_(targetV3d) < Math.pow(pathCloseEnoughThreshold * 2.0, 2.0) && maid.m_20275_(targetV3d.m_7096_(), maid.m_20186_(), targetV3d.m_7094_()) < Math.pow(pathCloseEnoughThreshold, 2.0);
            if (!strictArrive && !loosenArrive) {
                Optional walkTarget = brain.m_21952_(MemoryModuleType.f_26370_);
                if (walkTarget.isEmpty() || !((WalkTarget)walkTarget.get()).m_26420_().m_7024_().equals((Object)targetV3d)) {
                    brain.m_21936_((MemoryModuleType)InitEntities.TARGET_POS.get());
                }
                return false;
            }
            return true;
        }).orElse(false);
    }

    public static boolean isWaitingForReturn(EntityMaid maid) {
        return maid.m_6274_().m_21874_((MemoryModuleType)MemoryModuleRegistry.RETURN_TO_SCHEDULE_AT.get());
    }

    public static boolean isNothingToPlace(EntityMaid maid) {
        return InvUtil.forSlotMatches((IItemHandler)maid.getAvailableInv(false), slot -> {
            if (slot.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
                return RequestListItem.isIgnored(slot);
            }
            return true;
        }).stream().allMatch(stack -> stack.m_41619_());
    }

    public static boolean shouldStopAndPickUpItems(EntityMaid maid) {
        if (MemoryUtil.isWorking(maid)) {
            return false;
        }
        CombinedInvWrapper inv = maid.getAvailableInv(false);
        return (double)InvUtil.freeSlots((IItemHandler)inv) >= (double)inv.getSlots() * Config.pickupRequireWhenPlace;
    }

    public static boolean triesReach(EntityMaid maid) {
        return MemoryUtil.getRequestProgress(maid).getTries() > Config.maxStoreTries;
    }

    public static boolean usePriorityTarget(EntityMaid maid) {
        return switch (((StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault())).memoryAssistant()) {
            default -> throw new IncompatibleClassChangeError();
            case StorageManagerConfigData.MemoryAssistant.MEMORY_ONLY, StorageManagerConfigData.MemoryAssistant.MEMORY_FIRST -> true;
            case StorageManagerConfigData.MemoryAssistant.ALWAYS_SCAN -> false;
        };
    }

    public static boolean useScanTarget(EntityMaid maid) {
        return switch (((StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault())).memoryAssistant()) {
            default -> throw new IncompatibleClassChangeError();
            case StorageManagerConfigData.MemoryAssistant.MEMORY_ONLY -> false;
            case StorageManagerConfigData.MemoryAssistant.MEMORY_FIRST, StorageManagerConfigData.MemoryAssistant.ALWAYS_SCAN -> true;
        };
    }

    public static boolean noSortPlacement(EntityMaid maid) {
        return ((StorageManagerConfigData.Data)maid.getOrCreateData(StorageManagerConfigData.KEY, (Object)StorageManagerConfigData.Data.getDefault())).noSortPlacement();
    }

    public static boolean shouldCheckStock(EntityMaid maid) {
        ItemStack mainHandItem = maid.m_21205_();
        if (RequestListItem.getStorageBlock(mainHandItem) == null) {
            return false;
        }
        if (!RequestListItem.isStockMode(mainHandItem)) {
            return false;
        }
        return !RequestListItem.hasCheckedStock(mainHandItem);
    }
}

