/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.apache.logging.log4j.util.Strings;
import studio.fantasyit.maid_storage_manager.render.SeeThroughBoxRenderType;
import studio.fantasyit.maid_storage_manager.storage.Target;

@OnlyIn(value=Dist.CLIENT)
public class BoxRenderUtil {
    public static boolean useSeeThroughBox = false;

    public static void renderStorage(Target storage, float[] colors, RenderLevelStageEvent event, String key, Map<BlockPos, Integer> floating) {
        BoxRenderUtil.renderStorage(storage, colors, event, key, floating, 0xFFFFFF);
    }

    public static void renderStorage(Target storage, float[] colors, RenderLevelStageEvent event, String key, Map<BlockPos, Integer> floating, int textColor) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Vec3 position = event.getCamera().m_90583_().m_82548_();
        AABB aabb = new AABB(storage.getPos()).m_82383_(position);
        VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)(useSeeThroughBox ? SeeThroughBoxRenderType.seeThroughBox() : RenderType.f_110371_));
        LevelRenderer.m_109646_((PoseStack)event.getPoseStack(), (VertexConsumer)buffer, (AABB)aabb, (float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        if (storage.getSide().isPresent()) {
            BlockPos sidePos = storage.getPos().m_121945_(storage.getSide().get());
            int dx = sidePos.m_123341_() - storage.getPos().m_123341_();
            int dy = sidePos.m_123342_() - storage.getPos().m_123342_();
            int dz = sidePos.m_123343_() - storage.getPos().m_123343_();
            AABB sideAabb = new AABB(sidePos).m_82383_(position);
            if (dx != 0) {
                sideAabb = dx > 0 ? sideAabb.m_165891_(sideAabb.f_82288_ + 0.07) : sideAabb.m_165880_(sideAabb.f_82291_ - 0.07);
            } else {
                sideAabb = sideAabb.m_165891_(sideAabb.f_82291_ - 0.2);
                sideAabb = sideAabb.m_165880_(sideAabb.f_82288_ + 0.2);
            }
            if (dy != 0) {
                sideAabb = dy > 0 ? sideAabb.m_165893_(sideAabb.f_82289_ + 0.07) : sideAabb.m_165887_(sideAabb.f_82292_ - 0.07);
            } else {
                sideAabb = sideAabb.m_165893_(sideAabb.f_82292_ - 0.2);
                sideAabb = sideAabb.m_165887_(sideAabb.f_82289_ + 0.2);
            }
            if (dz != 0) {
                sideAabb = dz > 0 ? sideAabb.m_165895_(sideAabb.f_82290_ + 0.07) : sideAabb.m_165889_(sideAabb.f_82293_ - 0.07);
            } else {
                sideAabb = sideAabb.m_165895_(sideAabb.f_82293_ - 0.2);
                sideAabb = sideAabb.m_165889_(sideAabb.f_82290_ + 0.2);
            }
            LevelRenderer.m_109646_((PoseStack)event.getPoseStack(), (VertexConsumer)buffer, (AABB)sideAabb, (float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        }
        if (!Strings.isBlank((String)key)) {
            Vec3 livingFrom = storage.getPos().m_252807_().m_82520_(0.0, (double)0.7f, 0.0);
            BoxRenderUtil.drawText(event, mc, livingFrom, key, textColor, (float)floating.getOrDefault(storage.getPos(), 0).intValue() * 0.3f);
            floating.put(storage.getPos(), floating.getOrDefault(storage.getPos(), 0) + 1);
        }
    }

    public static void renderEntity(Entity entity, float[] colors, RenderLevelStageEvent event, String key) {
        BoxRenderUtil.renderEntity(entity, colors, event, key, 0xFFFFFF);
    }

    public static void renderEntity(Entity entity, float[] colors, RenderLevelStageEvent event, String key, int textColor) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        Vec3 position = event.getCamera().m_90583_().m_82548_();
        AABB aabb = entity.m_20191_().m_82383_(position).m_82400_(0.3);
        VertexConsumer buffer = mc.m_91269_().m_110104_().m_6299_((RenderType)(useSeeThroughBox ? SeeThroughBoxRenderType.seeThroughBox() : RenderType.f_110371_));
        LevelRenderer.m_109646_((PoseStack)event.getPoseStack(), (VertexConsumer)buffer, (AABB)aabb, (float)colors[0], (float)colors[1], (float)colors[2], (float)colors[3]);
        if (!Strings.isBlank((String)key)) {
            Vec3 livingFrom = entity.m_20318_(event.getPartialTick()).m_82520_(0.0, (double)(entity.m_20206_() + 0.5f), 0.0);
            BoxRenderUtil.drawText(event, mc, livingFrom, key, textColor, 0.0f);
        }
    }

    public static void drawText(RenderLevelStageEvent event, Minecraft mc, Vec3 livingFrom, String key, int textColor, float floatingTransform) {
        PoseStack pose = event.getPoseStack();
        Vec3 fromPos = mc.f_91074_.m_20299_(event.getPartialTick());
        Vec3 posFromPlayer = fromPos.m_82505_(livingFrom);
        pose.m_85836_();
        pose.m_85837_(posFromPlayer.f_82479_, posFromPlayer.f_82480_, posFromPlayer.f_82481_);
        pose.m_252880_(0.0f, floatingTransform, 0.0f);
        pose.m_252781_(Axis.f_252436_.m_252977_(-event.getCamera().m_90590_()));
        pose.m_252781_(Axis.f_252529_.m_252977_(event.getCamera().m_90589_()));
        pose.m_85841_(-0.025f, -0.025f, -1.0f);
        pose.m_252880_((float)(-mc.f_91062_.m_92895_(key)) / 2.0f, 0.0f, 0.0f);
        mc.f_91062_.m_271703_(key, 0.0f, 0.0f, textColor, mc.f_91062_.m_92718_(), pose.m_85850_().m_252922_(), (MultiBufferSource)mc.m_91269_().m_110104_(), useSeeThroughBox ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
        mc.m_91269_().m_110104_().m_109911_();
        pose.m_85849_();
    }
}

