/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.storage.ae2;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.storage.Target;
import studio.fantasyit.maid_storage_manager.storage.ae2.Ae2BaseContext;
import studio.fantasyit.maid_storage_manager.storage.base.IStorageExtractableContext;

public class Ae2CollectContext
extends Ae2BaseContext
implements IStorageExtractableContext {
    private int current = 0;
    private List<AEItemKey> keys;
    List<ItemStack> itemList = null;
    boolean matchNbt = false;
    boolean lastDone = false;

    @Override
    public void start(EntityMaid maid, ServerLevel level, Target target) {
        super.start(maid, level, target);
        if (this.init(maid, level, target)) {
            this.keys = this.inv.getAvailableStacks().keySet().stream().filter(key -> key instanceof AEItemKey).map(key -> (AEItemKey)key).toList();
        }
    }

    @Override
    public void setExtract(List<ItemStack> itemList, boolean matchNbt) {
        this.itemList = itemList;
        this.matchNbt = matchNbt;
        this.current = 0;
        this.setDone(false);
        this.lastDone = false;
    }

    @Override
    public void setExtractByExisting(Predicate<ItemStack> predicate) {
        if (this.keys != null) {
            this.setExtract(this.keys.stream().map(AEItemKey::getReadOnlyStack).filter(predicate).toList(), true);
        } else {
            this.setExtract(List.of(), true);
        }
    }

    @Override
    public void reset() {
        this.current = 0;
        this.setDone(false);
        if (this.inv != null) {
            this.keys = this.inv.getAvailableStacks().keySet().stream().filter(key -> key instanceof AEItemKey).map(key -> (AEItemKey)key).toList();
        }
    }

    @Override
    public boolean hasTask() {
        return this.itemList != null;
    }

    @Override
    public void clearTask() {
        this.itemList = null;
    }

    @Override
    public void tick(Function<ItemStack, ItemStack> process) {
        if (this.inv == null) {
            return;
        }
        while (this.current < this.itemList.size()) {
            ItemStack item = this.itemList.get(this.current);
            if (!item.m_41619_()) {
                List<Object> filteredKey;
                AEItemKey keyTmp = AEItemKey.of((ItemStack)item);
                List<Object> list = filteredKey = keyTmp == null ? List.of() : List.of(keyTmp);
                if (!this.matchNbt) {
                    filteredKey = this.keys.stream().filter(aeItemKey -> aeItemKey.getItem() == item.m_41720_()).toList();
                }
                int totalRestCount = item.m_41613_();
                for (AEItemKey aEItemKey : filteredKey) {
                    ItemStack tmp;
                    ItemStack apply;
                    int scheduled;
                    int costed;
                    long extract = this.inv.extract((AEKey)aEItemKey, (long)totalRestCount, Actionable.SIMULATE, IActionSource.empty());
                    if (extract == 0L) continue;
                    while (extract > 0L && (costed = (scheduled = (int)Math.min(extract, (long)item.m_41741_())) - (apply = process.apply(tmp = aEItemKey.getReadOnlyStack().m_255036_(scheduled))).m_41613_()) != 0) {
                        this.inv.extract((AEKey)aEItemKey, (long)costed, Actionable.MODULATE, IActionSource.empty());
                        extract -= (long)costed;
                        totalRestCount -= costed;
                    }
                    if (totalRestCount > 0) continue;
                    break;
                }
            }
            ++this.current;
        }
        this.lastDone = true;
        this.setDone(true);
    }
}

