/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.smithing;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SmithingRecipe;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;
import studio.fantasyit.maid_storage_manager.util.RecipeUtil;

public class SmithingCraftMenu
extends AbstractCraftMenu<SmithingCraftMenu> {
    public SmithingCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_SMITHING.get(), p_38852_, player);
    }

    @Override
    protected void addFilterSlots() {
        this.m_38897_(new FilterSlot(this.stepDataContainer, 0, 34, 69));
        this.m_38897_(new FilterSlot(this.stepDataContainer, 1, 52, 69));
        this.m_38897_(new FilterSlot(this.stepDataContainer, 2, 70, 69));
        this.m_38897_(new FilterSlot(this.stepDataContainer, 3, 126, 69, true));
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case SET_ALL_INPUT: {
                int i;
                ListTag list = data.m_128437_("inputs", 10);
                for (i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    ItemStack stack = ItemStackUtil.parseStack(tag);
                    this.stepDataContainer.setItemNoTrigger(i, stack);
                }
                for (i = list.size(); i < this.stepDataContainer.m_6643_(); ++i) {
                    this.stepDataContainer.setItemNoTrigger(i, ItemStack.f_41583_);
                }
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
            }
        }
    }

    @Override
    public void recalculateRecipe() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.stepDataContainer.inputCount; ++i) {
            items.add(this.stepDataContainer.m_8020_(i));
        }
        Optional<SmithingRecipe> recipe = RecipeUtil.getSmithingRecipe(this.player.m_9236_(), items);
        recipe.ifPresentOrElse(smithingRecipe -> {
            ItemStack resultItem = smithingRecipe.m_8043_(this.player.m_9236_().m_9598_());
            this.stepDataContainer.setItemNoTrigger(3, resultItem);
        }, () -> this.stepDataContainer.setItemNoTrigger(3, ItemStack.f_41583_));
    }
}

