/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu.craft.anvil;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.craft.base.AbstractCraftMenu;
import studio.fantasyit.maid_storage_manager.network.CraftGuideGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class AnvilCraftMenu
extends AbstractCraftMenu<AnvilCraftMenu> {
    AnvilMenu anvilMenu;
    public int xpCost = -1;

    public AnvilCraftMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.CRAFT_GUIDE_MENU_ANVIL.get(), p_38852_, player);
        this.anvilMenu = new AnvilMenu(p_38852_, player.m_150109_());
    }

    @Override
    protected void addFilterSlots() {
        this.m_38897_(new FilterSlot(this.stepDataContainer, 0, 28, 73));
        this.m_38897_(new FilterSlot(this.stepDataContainer, 1, 77, 73));
        this.m_38897_(new FilterSlot(this.stepDataContainer, 2, 135, 73, true));
    }

    @Override
    public void handleGuiPacket(CraftGuideGuiPacket.Type type, int key, int value, @Nullable CompoundTag data) {
        switch (type) {
            case SET_ALL_INPUT: {
                ListTag list = data.m_128437_("inputs", 10);
                for (int i = 0; i < list.size(); ++i) {
                    CompoundTag tag = list.m_128728_(i);
                    ItemStack stack = ItemStackUtil.parseStack(tag);
                    this.stepDataContainer.m_6836_(i, stack);
                }
                this.save();
                break;
            }
            case SET_ITEM: {
                if (data == null) break;
                this.m_38853_(key).m_5852_(ItemStackUtil.parseStack(data));
                this.save();
                break;
            }
            case EXTRA: {
                this.stepDataContainer.step.setExtraData(data);
                this.save();
            }
        }
    }

    @Override
    public void recalculateRecipe() {
        if (this.anvilMenu == null) {
            return;
        }
        CompoundTag extra = this.stepDataContainer.step.getExtraData();
        String name = extra.m_128461_("name");
        this.anvilMenu.m_182406_(0, 0, this.stepDataContainer.m_8020_(0));
        this.anvilMenu.m_182406_(1, 0, this.stepDataContainer.m_8020_(1));
        this.anvilMenu.m_39020_(name);
        this.anvilMenu.m_6640_();
        this.stepDataContainer.setItemNoTrigger(2, this.anvilMenu.m_38853_(2).m_7993_());
        this.xpCost = this.anvilMenu.m_39028_();
    }
}

