/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.menu;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.items.RequestListItem;
import studio.fantasyit.maid_storage_manager.menu.container.CountSlot;
import studio.fantasyit.maid_storage_manager.menu.container.FilterContainer;
import studio.fantasyit.maid_storage_manager.menu.container.FilterSlot;
import studio.fantasyit.maid_storage_manager.menu.container.ISaveFilter;
import studio.fantasyit.maid_storage_manager.network.ItemSelectorGuiPacket;
import studio.fantasyit.maid_storage_manager.registry.GuiRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class ItemSelectorMenu
extends AbstractContainerMenu
implements ISaveFilter {
    public Player player;
    ItemStack target;
    public FilterContainer filteredItems;
    public SimpleContainer storageHandler;
    public boolean matchTag = false;
    public boolean blackmode = false;
    public boolean stockMode = false;
    public boolean shouldClear = false;
    public boolean unitSecond = false;
    public int repeat = 0;

    public ItemSelectorMenu(int p_38852_, Player player) {
        super((MenuType)GuiRegistry.ITEM_SELECTOR_MENU.get(), p_38852_);
        this.player = player;
        this.target = player.m_21205_();
        CompoundTag tag = this.target.m_41784_();
        this.filteredItems = new FilterContainer(10, this);
        this.filteredItems.deserializeNBT(tag.m_128437_("items", 10));
        this.matchTag = tag.m_128471_("match_tag");
        this.repeat = tag.m_128451_("interval");
        this.blackmode = tag.m_128471_("blackmode");
        this.stockMode = tag.m_128471_("stock_mode");
        this.unitSecond = tag.m_128471_("unit_second");
        if (this.unitSecond) {
            this.repeat /= 20;
        }
        this.storageHandler = new SimpleContainer(1){

            public void m_6596_() {
                super.m_6596_();
                ItemSelectorMenu.this.save();
            }
        };
        this.storageHandler.m_6836_(0, ItemStackUtil.parseStack(tag.m_128469_("storage_define")));
        this.addPlayerSlots();
        this.addFilterSlots();
        this.addSpecialSlots();
    }

    public void clear() {
        RequestListItem.clearItemProcess(this.target);
        this.filteredItems.reset();
        this.m_38946_();
    }

    @Override
    public void save() {
        if (this.player.m_9236_().f_46443_) {
            return;
        }
        CompoundTag tag = this.target.m_41784_();
        ListTag list = new ListTag();
        if (tag.m_128441_("items")) {
            list = tag.m_128437_("items", 10);
        }
        while (list.size() <= this.filteredItems.m_6643_()) {
            list.add((Object)new CompoundTag());
        }
        for (int i = 0; i < this.filteredItems.m_6643_(); ++i) {
            CompoundTag tmp = list.m_128728_(i);
            tmp.m_128365_("item", (Tag)this.filteredItems.m_8020_(i).serializeNBT());
            tmp.m_128405_("requested", this.filteredItems.count[i].getValue().intValue());
            list.set(i, (Tag)tmp);
        }
        tag.m_128365_("items", (Tag)list);
        tag.m_128379_("match_tag", this.matchTag);
        if (this.unitSecond) {
            tag.m_128405_("interval", this.repeat * 20);
        } else {
            tag.m_128405_("interval", this.repeat);
        }
        tag.m_128379_("blackmode", this.blackmode);
        tag.m_128379_("stock_mode", this.stockMode);
        tag.m_128379_("unit_second", this.unitSecond);
        tag.m_128365_("storage_define", (Tag)this.storageHandler.m_8020_(0).serializeNBT());
        this.target.m_41751_(tag);
    }

    private void addFilterSlots() {
        int cellHeight = 18;
        int startY = 18;
        for (int i = 0; i < 5; ++i) {
            this.m_38897_(new FilterSlot(this.filteredItems, i, 40, 18 + i * 18));
            this.m_38897_(new FilterSlot(this.filteredItems, i + 5, 75, 18 + i * 18));
            this.m_38895_(new CountSlot(this.filteredItems.count[i], this.filteredItems));
            this.m_38895_(new CountSlot(this.filteredItems.count[i + 5], this.filteredItems));
            this.m_38895_(new BasicData(this.filteredItems.done[i]));
            this.m_38895_(new BasicData(this.filteredItems.done[i + 5]));
        }
    }

    private void addPlayerSlots() {
        int i;
        int cellHeight = 18;
        int cellWidth = 18;
        int startY = 118;
        int startX = 8;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.player.m_150109_(), 9 + i * 9 + j, 8 + j * 18, 118 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.player.m_150109_(), i, 8 + i * 18, 176));
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        Slot slot;
        if (slotId >= 0 && (slot = this.m_38853_(slotId)) instanceof FilterSlot) {
            ItemStack insert;
            FilterSlot fs = (FilterSlot)slot;
            int slot2 = fs.m_150661_();
            if (clickTypeIn == ClickType.THROW) {
                return;
            }
            ItemStack held = this.m_142621_();
            if (clickTypeIn == ClickType.CLONE) {
                if (player.m_7500_() && held.m_41619_()) {
                    ItemStack stackInSlot = this.filteredItems.m_8020_(slot2).m_41777_();
                    stackInSlot.m_41764_(stackInSlot.m_41741_());
                    this.m_142503_(stackInSlot);
                    return;
                }
                return;
            }
            if (held.m_41619_()) {
                insert = ItemStack.f_41583_;
            } else {
                insert = held.m_41777_();
                insert.m_41764_(1);
            }
            this.filteredItems.m_6836_(slot2, insert);
            this.m_38853_(slotId).m_6654_();
        } else {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    private void addSpecialSlots() {
        this.m_38897_(new Slot((Container)this.storageHandler, 0, 8, 71));
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ItemSelectorMenu.this.unitSecond ? 1 : 0;
            }

            public void m_6422_(int p_40208_) {
                ItemSelectorMenu.this.unitSecond = p_40208_ == 1;
                ItemSelectorMenu.this.save();
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ItemSelectorMenu.this.matchTag ? 1 : 0;
            }

            public void m_6422_(int p_40208_) {
                ItemSelectorMenu.this.matchTag = p_40208_ == 1;
                ItemSelectorMenu.this.save();
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ItemSelectorMenu.this.blackmode ? 1 : 0;
            }

            public void m_6422_(int p_40208_) {
                ItemSelectorMenu.this.blackmode = p_40208_ == 1;
                ItemSelectorMenu.this.save();
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ItemSelectorMenu.this.stockMode ? 1 : 0;
            }

            public void m_6422_(int p_40208_) {
                ItemSelectorMenu.this.stockMode = p_40208_ == 1;
                ItemSelectorMenu.this.save();
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return 0;
            }

            public void m_6422_(int p_40208_) {
                if (p_40208_ != 0) {
                    ItemSelectorMenu.this.clear();
                }
            }
        });
        this.m_38895_(new DataSlot(){

            public int m_6501_() {
                return ItemSelectorMenu.this.repeat;
            }

            public void m_6422_(int p_40208_) {
                ItemSelectorMenu.this.repeat = p_40208_;
            }
        });
    }

    @NotNull
    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        Slot slot = this.m_38853_(p_38942_);
        if (slot.m_6657_()) {
            if (slot instanceof FilterSlot) {
                FilterSlot fs = (FilterSlot)slot;
                fs.m_5852_(ItemStack.f_41583_);
            } else {
                int i;
                int containerSize = this.filteredItems.m_6643_();
                boolean found = false;
                for (i = 0; i < containerSize; ++i) {
                    if (!ItemStack.m_150942_((ItemStack)this.filteredItems.m_8020_(i), (ItemStack)slot.m_7993_())) continue;
                    found = true;
                }
                if (!found) {
                    for (i = 0; i < containerSize; ++i) {
                        if (!this.filteredItems.m_8020_(i).m_41619_()) continue;
                        this.filteredItems.m_6836_(i, slot.m_7993_().m_255036_(1));
                        break;
                    }
                }
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return player.m_21205_() == this.target;
    }

    public void handleUpdate(ItemSelectorGuiPacket.SlotType type, int key, int value) {
        switch (type) {
            case COUNT: {
                this.filteredItems.count[key].setValue(value);
                this.save();
                break;
            }
            case MATCH_TAG: {
                this.matchTag = value == 1;
                this.save();
                break;
            }
            case CLEAR: {
                this.clear();
                break;
            }
            case REPEAT: {
                this.repeat = value;
                this.save();
                break;
            }
            case BLACKLIST: {
                this.blackmode = value == 1;
                this.save();
                break;
            }
            case STOCKMODE: {
                this.stockMode = value == 1;
                this.save();
                break;
            }
            case UNITSECOND: {
                if (this.unitSecond != (value == 1)) {
                    this.repeat = this.unitSecond ? (this.repeat *= 20) : (this.repeat /= 20);
                }
                this.unitSecond = value == 1;
                this.save();
            }
        }
    }

    public boolean m_5622_(Slot p_38945_) {
        return !(p_38945_ instanceof FilterSlot);
    }

    public void m_6199_(Container p_38868_) {
        super.m_6199_(p_38868_);
        this.save();
    }

    protected static class BasicData
    extends DataSlot {
        private final MutableInt value;

        BasicData(MutableInt value) {
            this.value = value;
        }

        public int m_6501_() {
            return this.value.getValue();
        }

        public void m_6422_(int p_39402_) {
            this.value.setValue(p_39402_);
        }
    }
}

