/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.maid.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import studio.fantasyit.maid_storage_manager.maid.memory.AbstractTargetMemory;
import studio.fantasyit.maid_storage_manager.storage.Target;

public class PlacingInventoryMemory
extends AbstractTargetMemory {
    public static final Codec<PlacingInventoryMemory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractTargetMemory.TargetData.CODEC.fieldOf("targetData").forGetter(AbstractTargetMemory::getTargetData), (App)Codec.list((Codec)ItemStack.f_41582_).fieldOf("arrangeItems").forGetter(PlacingInventoryMemory::getArrangeItems), (App)Codec.BOOL.fieldOf("anySuccess").forGetter(PlacingInventoryMemory::isAnySuccess), (App)Codec.INT.fieldOf("failCount").forGetter(PlacingInventoryMemory::getFailCount), (App)Target.CODEC.listOf().fieldOf("suppressedTarget").orElse(List.of()).forGetter(PlacingInventoryMemory::getSuppressedPos)).apply((Applicative)instance, PlacingInventoryMemory::new));
    private int failCount;
    public List<ItemStack> arrangeItems;
    private boolean anySuccess;
    private List<Target> suppressedPos;

    public PlacingInventoryMemory(AbstractTargetMemory.TargetData targetData, List<ItemStack> arrangeItems, boolean anySuccess, int failCount, List<Target> suppressedPos) {
        super(targetData);
        this.arrangeItems = new ArrayList<ItemStack>(arrangeItems);
        this.anySuccess = anySuccess;
        this.failCount = failCount;
        this.suppressedPos = new ArrayList<Target>(suppressedPos);
    }

    public PlacingInventoryMemory() {
        this.arrangeItems = new ArrayList<ItemStack>();
        this.anySuccess = false;
        this.suppressedPos = new ArrayList<Target>();
    }

    public List<ItemStack> getArrangeItems() {
        return this.arrangeItems;
    }

    public void setArrangeItems(List<ItemStack> arrangeItems) {
        this.arrangeItems = arrangeItems;
    }

    public void clearArrangeItems() {
        this.arrangeItems.clear();
    }

    public void resetAnySuccess() {
        this.anySuccess = false;
    }

    public void anySuccess() {
        this.anySuccess = true;
    }

    public boolean isAnySuccess() {
        return this.anySuccess;
    }

    @Override
    public int getFailCount() {
        return this.failCount;
    }

    @Override
    public void addFailCount() {
        ++this.failCount;
    }

    @Override
    public void resetFailCount() {
        this.failCount = 0;
    }

    public List<Target> getSuppressedPos() {
        return this.suppressedPos;
    }

    public void addSuppressedPos(Target target) {
        this.suppressedPos.add(target);
    }

    public boolean anySuppressed() {
        return !this.suppressedPos.isEmpty();
    }

    public void removeSuppressed() {
        this.suppressedPos.clear();
    }

    public void removeSuppressed(Target target) {
        this.suppressedPos.remove(target);
    }

    public void removeSuppressed(List<Target> suppressedFilterTarget) {
        this.suppressedPos.removeIf(suppressedFilterTarget::contains);
    }

    public boolean isSuppressed(Target target) {
        return this.suppressedPos.contains(target);
    }
}

