/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.craft.work.ProgressData;
import studio.fantasyit.maid_storage_manager.data.MaidProgressData;
import studio.fantasyit.maid_storage_manager.event.RenderHandMapLikeEvent;
import studio.fantasyit.maid_storage_manager.items.HangUpItem;
import studio.fantasyit.maid_storage_manager.render.map_like.ProgressPadRender;

public class ProgressPad
extends HangUpItem
implements RenderHandMapLikeEvent.MapLikeRenderItem {
    public static final String TAG_BINDING_UUID = "binding_uuid";
    public static final String TAG_VIEWING = "viewing";
    public static final String TAG_STYLE = "style";

    public ProgressPad() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nullable
    public static UUID getBindingUUID(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return null;
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (!tag.m_128441_(TAG_BINDING_UUID)) {
            return null;
        }
        return tag.m_128342_(TAG_BINDING_UUID);
    }

    public static void setBindingUUID(ItemStack itemStack, @Nullable UUID uuid) {
        if (!itemStack.m_41782_()) {
            itemStack.m_41751_(new CompoundTag());
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (uuid == null) {
            tag.m_128473_(TAG_BINDING_UUID);
        } else {
            tag.m_128362_(TAG_BINDING_UUID, uuid);
        }
    }

    public static Style getStyle(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return Style.NORMAL;
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (!tag.m_128441_(TAG_STYLE)) {
            return Style.NORMAL;
        }
        return Style.valueOf(tag.m_128461_(TAG_STYLE));
    }

    public static void setStyle(ItemStack itemStack, Style style) {
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        tag.m_128359_(TAG_STYLE, style.name());
        itemStack.m_41751_(tag);
    }

    public static void rollStyle(ItemStack itemStack, ServerPlayer player, int value) {
        Style style = ProgressPad.getStyle(itemStack);
        style = Style.values()[(style.ordinal() + Style.values().length + value) % Style.values().length];
        player.m_240418_((Component)Component.m_237115_((String)("interaction.progress_pad.style." + style.name().toLowerCase())), false);
        ProgressPad.setStyle(itemStack, style);
    }

    public static Viewing getViewing(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return Viewing.WORKING;
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (!tag.m_128441_(TAG_VIEWING)) {
            return Viewing.WORKING;
        }
        return Viewing.valueOf(tag.m_128461_(TAG_VIEWING));
    }

    public static void setViewing(ItemStack itemStack, Viewing viewing) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_(TAG_VIEWING, viewing.name());
    }

    public static void rollViewing(ItemStack itemInHand, ServerPlayer serverPlayer, int value) {
        Viewing selectId = ProgressPad.getViewing(itemInHand);
        selectId = Viewing.values()[(selectId.ordinal() + value + Viewing.values().length) % Viewing.values().length];
        serverPlayer.m_240418_((Component)Component.m_237115_((String)("interaction.progress_pad.viewing." + selectId.name().toLowerCase())), false);
        ProgressPad.setViewing(itemInHand, selectId);
    }

    public static Merge getMerge(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return Merge.OVERFLOW_ONLY;
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (!tag.m_128441_("merge")) {
            return Merge.OVERFLOW_ONLY;
        }
        return Merge.valueOf(tag.m_128461_("merge"));
    }

    public static void setMerge(ItemStack itemStack, Merge merge) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_("merge", merge.name());
        itemStack.m_41751_(tag);
    }

    public static void rollMerge(ItemStack itemStack, ServerPlayer player, int value) {
        Merge merge = ProgressPad.getMerge(itemStack);
        merge = Merge.values()[(merge.ordinal() + value + Merge.values().length) % Merge.values().length];
        player.m_240418_((Component)Component.m_237115_((String)("interaction.progress_pad.merge." + merge.name().toLowerCase())), false);
        ProgressPad.setMerge(itemStack, merge);
    }

    public static Selecting getSelecting(ItemStack itemStack) {
        if (!itemStack.m_41782_()) {
            return Selecting.Viewing;
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (!tag.m_128441_("selecting")) {
            return Selecting.Viewing;
        }
        return Selecting.valueOf(tag.m_128461_("selecting"));
    }

    public static void setSelecting(ItemStack itemStack, Selecting selecting) {
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128359_("selecting", selecting.name());
        itemStack.m_41751_(tag);
    }

    public static void rollSelecting(ItemStack itemStack, ServerPlayer player, int value) {
        Selecting selecting = ProgressPad.getSelecting(itemStack);
        selecting = Selecting.values()[(selecting.ordinal() + value + Selecting.values().length) % Selecting.values().length];
        player.m_240418_((Component)Component.m_237115_((String)("interaction.progress_pad.selecting." + selecting.name().toLowerCase())), false);
        ProgressPad.setSelecting(itemStack, selecting);
    }

    public static void rollValue(ItemStack itemStack, ServerPlayer player, int value) {
        switch (ProgressPad.getSelecting(itemStack)) {
            case Viewing: {
                ProgressPad.rollViewing(itemStack, player, value);
                break;
            }
            case Style: {
                ProgressPad.rollStyle(itemStack, player, value);
                break;
            }
            case Merge: {
                ProgressPad.rollMerge(itemStack, player, value);
            }
        }
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack itemStack, Player p_41399_, LivingEntity entity, InteractionHand p_41401_) {
        if (!p_41399_.m_9236_().f_46443_ && p_41401_ == InteractionHand.MAIN_HAND && entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (p_41399_.m_20148_().equals(maid.m_269323_().m_20148_())) {
                ProgressPad.setBindingUUID(itemStack, maid.m_20148_());
                InitTrigger.MAID_EVENT.trigger((ServerPlayer)p_41399_, "progress_pad");
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6880_(itemStack, p_41399_, entity, p_41401_);
    }

    @Override
    public RenderHandMapLikeEvent.MapLikeRenderer getRenderer() {
        return ProgressPadRender.INSTANCE;
    }

    @Override
    public boolean available(ItemStack stack) {
        ProgressData data = MaidProgressData.getByMaid(ProgressData.ProgressMeta.fromItemStack(stack));
        return data != null;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext context) {
        if (!context.m_43725_().f_46443_ && ProgressPad.getBindingUUID(context.m_43722_()) == null) {
            return InteractionResult.FAIL;
        }
        return super.m_6225_(context);
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, @NotNull List<Component> toolTip, @NotNull TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, toolTip, p_41424_);
        UUID bindingUUID = ProgressPad.getBindingUUID(itemStack);
        if (bindingUUID != null) {
            ProgressData byMaid = MaidProgressData.getByMaid(ProgressData.ProgressMeta.fromItemStack(itemStack));
            if (byMaid == null) {
                toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.progress_pad.binding", (Object[])new Object[]{bindingUUID.toString()}));
            } else {
                toolTip.add((Component)Component.m_237110_((String)"tooltip.maid_storage_manager.progress_pad.binding", (Object[])new Object[]{byMaid.maidName}));
            }
        }
        toolTip.add((Component)(switch (ProgressPad.getViewing(itemStack)) {
            default -> throw new IncompatibleClassChangeError();
            case Viewing.WORKING -> Component.m_237115_((String)"tooltip.maid_storage_manager.progress_pad.viewing_working");
            case Viewing.DONE -> Component.m_237115_((String)"tooltip.maid_storage_manager.progress_pad.viewing_done");
            case Viewing.WAITING -> Component.m_237115_((String)"tooltip.maid_storage_manager.progress_pad.viewing_waiting");
        }));
    }

    @Override
    public boolean allowClickThrough() {
        return false;
    }

    public static enum Style {
        NORMAL,
        SMALL;

    }

    public static enum Viewing {
        WORKING,
        DONE,
        WAITING;

    }

    public static enum Merge {
        NONE,
        OVERFLOW_ONLY,
        ALWAYS;

    }

    public static enum Selecting {
        Viewing,
        Style,
        Merge;

    }
}

