/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.items;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.fantasyit.maid_storage_manager.items.HangUpItem;
import studio.fantasyit.maid_storage_manager.items.render.CustomItemRenderer;
import studio.fantasyit.maid_storage_manager.menu.FilterMenu;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.ItemStackUtil;

public class FilterListItem
extends HangUpItem
implements MenuProvider {
    public static final String TAG_ITEMS = "items";
    public static final String TAG_ITEMS_ITEM = "item";
    public static final String TAG_MATCH_TAG = "match_tag";
    public static final String TAG_UUID = "uuid";
    public static final String TAG_BLACK_MODE = "black_mode";

    public FilterListItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public static boolean matchNbt(ItemStack mainHandItem) {
        if (!mainHandItem.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return false;
        }
        if (!mainHandItem.m_41782_()) {
            return false;
        }
        CompoundTag tag = Objects.requireNonNull(mainHandItem.m_41783_());
        return tag.m_128471_(TAG_MATCH_TAG);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, @NotNull Player player, @NotNull InteractionHand p_41434_) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!serverPlayer.m_6144_()) {
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this, buffer -> buffer.writeInt(-1));
            }
            return InteractionResultHolder.m_19096_((Object)player.m_21120_(p_41434_));
        }
        return InteractionResultHolder.m_19098_((Object)player.m_21120_(p_41434_));
    }

    public void m_7373_(@NotNull ItemStack itemStack, @Nullable Level p_41422_, @NotNull List<Component> toolTip, @NotNull TooltipFlag p_41424_) {
        super.m_7373_(itemStack, p_41422_, toolTip, p_41424_);
        toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.filter_list.desc").m_130940_(ChatFormatting.GRAY));
        if (!itemStack.m_41782_()) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.filter_list.no_tag"));
            return;
        }
        CompoundTag tag = Objects.requireNonNull(itemStack.m_41783_());
        if (tag.m_128471_(TAG_BLACK_MODE)) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.filter_list.black_mode"));
        } else {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.filter_list.white_mode"));
        }
        if (!tag.m_128441_(TAG_ITEMS)) {
            toolTip.add((Component)Component.m_237115_((String)"tooltip.maid_storage_manager.request_list.open_gui_to_config"));
        } else {
            ListTag list = tag.m_128437_(TAG_ITEMS, 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemstack;
                CompoundTag itemTag = list.m_128728_(i);
                if (!itemTag.m_128441_(TAG_ITEMS_ITEM) || (itemstack = ItemStackUtil.parseStack(itemTag.m_128469_(TAG_ITEMS_ITEM))).m_41619_()) continue;
                MutableComponent component = Component.m_237110_((String)"gui.maid_storage_manager.filter_list.item", (Object[])new Object[]{itemstack.m_41786_().getString()});
                toolTip.add((Component)component);
            }
        }
    }

    @NotNull
    public static UUID getUUID(ItemStack stack) {
        if (!stack.m_150930_((Item)ItemRegistry.REQUEST_LIST_ITEM.get())) {
            return UUID.randomUUID();
        }
        if (!stack.m_41782_()) {
            return UUID.randomUUID();
        }
        CompoundTag tag = Objects.requireNonNull(stack.m_41783_());
        if (!tag.m_128441_(TAG_UUID)) {
            tag.m_128362_(TAG_UUID, UUID.randomUUID());
        }
        return tag.m_128342_(TAG_UUID);
    }

    @NotNull
    public Component m_5446_() {
        return Component.m_237115_((String)"gui.maid_storage_manager.filter_list.title");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new FilterMenu(p_39954_, p_39956_, -1);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return CustomItemRenderer.getInstance();
            }
        });
    }
}

