/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.event;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import studio.fantasyit.maid_storage_manager.integration.request.IngredientRequestClient;
import studio.fantasyit.maid_storage_manager.network.ClientInputPacket;
import studio.fantasyit.maid_storage_manager.network.Network;
import studio.fantasyit.maid_storage_manager.registry.ItemRegistry;
import studio.fantasyit.maid_storage_manager.util.BoxRenderUtil;

@Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class InputEvent {
    public static final Lazy<KeyMapping> KEY_REQUEST_INGREDIENT = Lazy.of(() -> new KeyMapping("key.maid_storage_manager.request_ingredient", InputConstants.Type.KEYSYM, 342, "key.maid_storage_manager.category"));
    public static final Lazy<KeyMapping> KEY_SEE_THROUGH_MARK_BOX = Lazy.of(() -> new KeyMapping("key.maid_storage_manager.see_through_mark_box", InputConstants.Type.KEYSYM, 342, "key.maid_storage_manager.category"));
    public static final Lazy<KeyMapping> KEY_ROLL_SPECIAL_MODE = Lazy.of(() -> new KeyMapping("key.maid_storage_manager.roll_special_mode", InputConstants.Type.KEYSYM, 342, "key.maid_storage_manager.category"));
    protected static boolean pressingSpecialKey = false;

    @SubscribeEvent
    public static void onScroll(InputEvent.MouseScrollingEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (player.m_6144_()) {
            if (itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) || itemStack.m_150930_((Item)ItemRegistry.STORAGE_DEFINE_BAUBLE.get()) || itemStack.m_150930_((Item)ItemRegistry.LOGISTICS_GUIDE.get()) || itemStack.m_150930_((Item)ItemRegistry.PROGRESS_PAD.get())) {
                event.setCanceled(true);
                Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new ClientInputPacket(ClientInputPacket.Type.SCROLL, (int)(event.getScrollDelta() * 100.0)));
            }
        } else if (pressingSpecialKey) {
            event.setCanceled(true);
            if (itemStack.m_150930_((Item)ItemRegistry.CRAFT_GUIDE.get()) || itemStack.m_150930_((Item)ItemRegistry.PROGRESS_PAD.get())) {
                Network.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new ClientInputPacket(ClientInputPacket.Type.ALT_SCROLL, (int)(event.getScrollDelta() * 100.0)));
            }
        }
    }

    @SubscribeEvent
    public static void onKey(InputEvent.Key event) {
        InputConstants.Key key = InputConstants.m_84827_((int)event.getKey(), (int)event.getScanCode());
        if (((KeyMapping)KEY_REQUEST_INGREDIENT.get()).getKey().equals((Object)key)) {
            if (event.getAction() == 1) {
                IngredientRequestClient.keyPressed = true;
            } else if (event.getAction() == 0) {
                IngredientRequestClient.keyPressed = false;
            }
        }
        if (((KeyMapping)KEY_SEE_THROUGH_MARK_BOX.get()).getKey().equals((Object)key)) {
            if (event.getAction() == 1) {
                BoxRenderUtil.useSeeThroughBox = true;
            } else if (event.getAction() == 0) {
                BoxRenderUtil.useSeeThroughBox = false;
            }
        }
        if (((KeyMapping)KEY_ROLL_SPECIAL_MODE.get()).getKey().equals((Object)key)) {
            if (event.getAction() == 1) {
                pressingSpecialKey = true;
            } else if (event.getAction() == 0) {
                pressingSpecialKey = false;
            }
        }
    }

    @Mod.EventBusSubscriber(modid="maid_storage_manager", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)KEY_REQUEST_INGREDIENT.get());
            event.register((KeyMapping)KEY_SEE_THROUGH_MARK_BOX.get());
            event.register((KeyMapping)KEY_ROLL_SPECIAL_MODE.get());
        }
    }
}

