/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.generator.type.botania;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonPickupItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonThrowItemAction;
import studio.fantasyit.maid_storage_manager.craft.context.common.CommonUseAction;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideData;
import studio.fantasyit.maid_storage_manager.craft.data.CraftGuideStepData;
import studio.fantasyit.maid_storage_manager.craft.generator.algo.ICachableGeneratorGraph;
import studio.fantasyit.maid_storage_manager.craft.generator.cache.RecipeIngredientCache;
import studio.fantasyit.maid_storage_manager.craft.generator.type.base.IAutoCraftGuideGenerator;
import studio.fantasyit.maid_storage_manager.craft.generator.util.GenerateIngredientUtil;
import studio.fantasyit.maid_storage_manager.craft.type.CommonType;
import studio.fantasyit.maid_storage_manager.data.InventoryItem;
import studio.fantasyit.maid_storage_manager.storage.Target;
import vazkii.botania.common.block.PetalApothecaryBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.crafting.PetalsRecipe;

public class GeneratorBotaniaApothecary
implements IAutoCraftGuideGenerator {
    @Override
    @NotNull
    public ResourceLocation getType() {
        return PetalsRecipe.TYPE_ID;
    }

    @Override
    public boolean isBlockValid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_60734_() instanceof PetalApothecaryBlock;
    }

    @Override
    public void generate(List<InventoryItem> inventory, Level level, BlockPos pos, ICachableGeneratorGraph graph, Map<ResourceLocation, List<BlockPos>> recognizedTypePositions) {
        level.m_7465_().m_44013_(BotaniaRecipeTypes.PETAL_TYPE).forEach(t -> {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)t.m_7527_());
            ingredients.add(0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_}));
            ingredients.add(t.getReagent());
            ItemStack output = t.m_8043_(level.m_9598_());
            graph.addRecipe(t.m_6423_(), ingredients, ingredients.stream().map(_t -> 1).toList(), output, items -> {
                ArrayList<CraftGuideStepData> steps = new ArrayList<CraftGuideStepData>();
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of((ItemStack)items.get(0)), List.of(), CommonUseAction.TYPE));
                GenerateIngredientUtil.each3items(items.subList(1, items.size()), subItemList -> steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), (List<ItemStack>)subItemList, List.of(), CommonThrowItemAction.TYPE)));
                steps.add(new CraftGuideStepData(Target.virtual(pos, Direction.UP), List.of(), List.of(output), CommonPickupItemAction.TYPE));
                return new CraftGuideData(steps, CommonType.TYPE);
            });
        });
    }

    @Override
    public void onCache(RecipeManager manager) {
        manager.m_44013_(BotaniaRecipeTypes.PETAL_TYPE).forEach(t -> {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>((Collection<Ingredient>)t.m_7527_());
            ingredients.add(0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42447_}));
            ingredients.add(t.getReagent());
            RecipeIngredientCache.addRecipeCache(t.m_6423_(), ingredients);
        });
    }

    @Override
    public Component getConfigName() {
        return Component.m_237115_((String)"config.maid_storage_manager.crafting.generating.botania.petal_apothecary");
    }

    @Override
    public boolean canCacheGraph() {
        return false;
    }
}

