/*
 * Decompiled with CFR 0.152.
 */
package studio.fantasyit.maid_storage_manager.craft.debug;

import java.util.Arrays;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import studio.fantasyit.maid_storage_manager.craft.algo.base.AbstractBiCraftGraph;
import studio.fantasyit.maid_storage_manager.craft.debug.IDebugContextSetter;
import studio.fantasyit.maid_storage_manager.craft.debug.Tester;

public class CraftingDebugContext {
    public final String id;
    public final Logger logger;
    private final LoggerConfig config;
    int level = 0;
    protected boolean[] disable = new boolean[TYPE.values().length];
    int graphIndex = 0;

    public void convey(Object anyOther) {
        if (anyOther instanceof IDebugContextSetter) {
            IDebugContextSetter setter = (IDebugContextSetter)anyOther;
            setter.setDebugContext(this);
        } else if (anyOther != null) {
            this.logNoLevel(TYPE.COMMON, "[?]Convey to non-debug class: %s", anyOther.getClass().getName());
        } else {
            this.logNoLevel(TYPE.COMMON, "[?]Convey to null", new Object[0]);
        }
    }

    public CraftingDebugContext(boolean b) {
        this.id = "debug_" + System.currentTimeMillis();
        if (b) {
            this.logger = null;
            this.config = null;
            return;
        }
        tData tmp = CraftingDebugContext.getLogger(this.id, null);
        this.logger = tmp.logger;
        this.config = tmp.config;
        Arrays.stream(TYPE.values()).filter(type -> type.disableByDefault).forEach(this::disable);
    }

    public CraftingDebugContext(boolean b, String pathOverride) {
        this.id = "debug_" + System.currentTimeMillis();
        if (b) {
            this.logger = null;
            this.config = null;
            return;
        }
        tData tmp = CraftingDebugContext.getLogger(this.id, pathOverride);
        this.logger = tmp.logger;
        this.config = tmp.config;
        Arrays.stream(TYPE.values()).filter(type -> type.disableByDefault).forEach(this::disable);
    }

    public void disable(TYPE type) {
        this.disable[type.ordinal()] = true;
    }

    public void enable(TYPE type) {
        this.disable[type.ordinal()] = false;
    }

    private static tData getLogger(String id, String pathOverride) {
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        PatternLayout layout = PatternLayout.newBuilder().withConfiguration(config).withPattern("%d{HH:mm:ss.SSS}[%-20t] %msg%n").build();
        String baseFilePath = (String)(pathOverride != null ? pathOverride : String.valueOf(FMLPaths.GAMEDIR.get()) + "/logs/msm_crafting/") + id + ".log";
        CompositeTriggeringPolicy policy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{SizeBasedTriggeringPolicy.createPolicy((String)"1 GB")});
        RollingFileAppender appender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(baseFilePath).withFilePattern(baseFilePath + "-%i.log.gz").setName(id)).setLayout((Layout)layout)).withPolicy((TriggeringPolicy)policy).setConfiguration(config)).build();
        appender.start();
        config.addAppender((Appender)appender);
        LoggerConfig loggerConfig = LoggerConfig.newBuilder().withAdditivity(false).withLevel(Level.DEBUG).withLoggerName(id).withConfig(config).build();
        loggerConfig.addAppender((Appender)appender, Level.DEBUG, null);
        config.addLogger(id, loggerConfig);
        context.updateLoggers(config);
        return new tData(LogManager.getLogger((String)id), loggerConfig);
    }

    private static void closeLogger(Logger logger, LoggerConfig loggerConfig) {
        if (loggerConfig == null || logger == null) {
            return;
        }
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = context.getConfiguration();
        config.removeLogger(loggerConfig.getName());
        Appender appender = (Appender)loggerConfig.getAppenders().get(loggerConfig.getName());
        if (appender != null) {
            loggerConfig.removeAppender(appender.getName());
            appender.stop();
            config.getAppenders().remove(appender.getName());
        }
        context.updateLoggers(config);
    }

    public void logEntryNewLevel(TYPE type, String message, Object ... a) {
        ++this.level;
        this.log(type, message, a);
    }

    public void logExitLevel(TYPE type, String message, Object ... a) {
        this.log(type, message, a);
        --this.level;
    }

    public void exitLogLevel(TYPE type, String message, Object ... a) {
        --this.level;
        this.log(type, message, a);
    }

    public boolean isDummy() {
        return this instanceof Dummy || this.logger == null;
    }

    public void log(TYPE type, String message, Object ... a) {
        if (this.isDummy()) {
            return;
        }
        if (this.disable[type.ordinal()]) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.name(type));
        for (int i = 0; i < this.level; ++i) {
            sb.append(" -");
        }
        sb.append("> ");
        sb.append(String.format(message, a));
        this.logger.debug(sb.toString());
    }

    public void logNoLevel(TYPE type, String message, Object ... a) {
        if (this.isDummy()) {
            return;
        }
        if (this.disable[type.ordinal()]) {
            return;
        }
        this.logger.debug(this.name(type) + String.format(message, a));
    }

    public String name(TYPE type) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(type.name());
        for (int i = 0; i < 18 - type.name().length(); ++i) {
            sb.append(" ");
        }
        sb.append("]  ");
        return sb.toString();
    }

    public void clearLevel() {
        this.level = 0;
    }

    public void stop() {
        CraftingDebugContext.closeLogger(this.logger, this.config);
    }

    public void saveGraph(AbstractBiCraftGraph graph, ItemStack target, int count) {
        if (this.isDummy()) {
            return;
        }
        String path = String.valueOf(FMLPaths.GAMEDIR.get()) + "/logs/msm_crafting/" + this.id + "_crafting_data_" + CraftingDebugContext.in(target.m_41720_()) + "_" + this.graphIndex++ + ".json";
        Tester.exportTo(graph, target, count, path);
        graph.restoreCurrent();
    }

    private static String in(Item item) {
        ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return key.m_135815_() + "_" + key.m_135827_();
    }

    public static enum TYPE {
        COMMON(false),
        PLANNER(false),
        GENERATOR(false),
        CRAFT(false),
        LOOP_RESOLVER(false),
        PREFILTER(false),
        GENERATOR_RECIPE(true),
        SIMULATOR(false),
        GENERATOR_GUIDE(true);

        public final boolean disableByDefault;

        private TYPE(boolean disableByDefault) {
            this.disableByDefault = disableByDefault;
        }
    }

    private record tData(Logger logger, LoggerConfig config) {
    }

    public static class Dummy
    extends CraftingDebugContext {
        public static final CraftingDebugContext INSTANCE = new Dummy();

        public Dummy() {
            super(true);
            Arrays.stream(TYPE.values()).forEach(this::disable);
        }

        @Override
        public void convey(Object anyOther) {
        }
    }
}

