/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.bakeries.recipe.toaster;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.renyigesai.bakeries.recipe.toaster.AbstractToasterRecipe;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class ToasterRecipe
extends AbstractToasterRecipe {
    public ToasterRecipe(ResourceLocation id, ItemStack output, int time, Ingredient recipeItems) {
        super(Type.INSTANCE, Serializer.INSTANCE, id, output, time, recipeItems);
    }

    public static class Type
    implements RecipeType<ToasterRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "toaster";

        private Type() {
        }
    }

    public static class Serializer<T extends AbstractToasterRecipe>
    implements RecipeSerializer<T> {
        public static final Serializer INSTANCE = new Serializer<ToasterRecipe>(ToasterRecipe::new);
        public static final ResourceLocation ID = new ResourceLocation("bakeries", "toaster");
        private final CookieBaker<T> factory;

        private Serializer(CookieBaker<T> pFactory) {
            this.factory = pFactory;
        }

        public T fromJson(ResourceLocation pRecipeId, JsonObject pSerializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"output"));
            int time = GsonHelper.m_13927_((JsonObject)pSerializedRecipe, (String)"time");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)pSerializedRecipe, (String)"ingredient") ? GsonHelper.m_13933_((JsonObject)pSerializedRecipe, (String)"ingredient") : GsonHelper.m_13930_((JsonObject)pSerializedRecipe, (String)"ingredient");
            Ingredient ingredient = Ingredient.m_288218_((JsonElement)jsonelement, (boolean)false);
            return this.factory.create(pRecipeId, output, time, ingredient);
        }

        @Nullable
        public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buf) {
            int time = buf.readInt();
            int ingredientCount = buf.readInt();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            return this.factory.create(pRecipeId, output, time, ingredient);
        }

        public void toNetwork(FriendlyByteBuf buf, T recipe) {
            buf.writeInt(((AbstractToasterRecipe)recipe).time);
            buf.writeInt(((AbstractToasterRecipe)recipe).m_7527_().size());
            for (Ingredient ing : ((AbstractToasterRecipe)recipe).m_7527_()) {
                ing.m_43923_(buf);
            }
            buf.writeItemStack(((AbstractToasterRecipe)recipe).m_8043_(null), false);
        }

        static interface CookieBaker<T extends AbstractToasterRecipe> {
            public T create(ResourceLocation var1, ItemStack var2, int var3, Ingredient var4);
        }
    }
}

